/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.FileUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResultSetFactory
implements ResultSetFactory {
    private File file = null;
    private String delimiter = ";";
    private boolean firstLineContainsColumnNames = false;
    private boolean trim = true;
    private boolean useTemplates = false;
    private String templateMarker = null;
    private Map<String, String> templates = null;

    public FileResultSetFactory(String fileName) {
        this(new File(fileName));
    }

    public FileResultSetFactory(File file) {
        this.file = file;
        this.setDefaultTemplateConfiguration();
    }

    public File getFile() {
        if (this.file.exists() && this.file.isFile()) {
            return this.file;
        }
        try {
            this.file = FileUtil.findFile((String)this.file.getPath());
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not find: " + this.file.getPath() + ". Current dir = " + System.getProperty("user.dir"));
        }
        return this.file;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setFirstLineContainsColumnNames(boolean firstLineContainsColumnNames) {
        this.firstLineContainsColumnNames = firstLineContainsColumnNames;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }

    public void setTemplateConfiguration(String marker, Map<String, String> templates) {
        this.templates = templates;
        this.templateMarker = marker;
    }

    public void setDefaultTemplateConfiguration() {
        HashMap<String, String> defaultTemplates = new HashMap<String, String>();
        defaultTemplates.put("defaultString", "");
        defaultTemplates.put("defaultDate", "1970-01-01");
        defaultTemplates.put("defaultInteger", "0");
        this.setTemplateConfiguration("$", defaultTemplates);
    }

    @Override
    public MockResultSet create(String id) {
        MockResultSet resultSet = new MockResultSet(id);
        File fileToRead = this.getFile();
        List lines = FileUtil.getLinesFromFile((File)fileToRead);
        if (lines.isEmpty()) {
            return resultSet;
        }
        int firstLineNumber = 0;
        if (this.firstLineContainsColumnNames) {
            String[] names;
            String firstLine = (String)lines.get(firstLineNumber);
            ++firstLineNumber;
            for (String name : names = StringUtil.split((String)firstLine, (String)this.delimiter, (boolean)this.trim)) {
                resultSet.addColumn(name);
            }
        }
        for (int ii = firstLineNumber; ii < lines.size(); ++ii) {
            String line = (String)lines.get(ii);
            Object[] values = StringUtil.split((String)line, (String)this.delimiter, (boolean)this.trim);
            if (this.useTemplates) {
                for (int yy = 0; yy < values.length; ++yy) {
                    if (null == values[yy] || !((String)values[yy]).startsWith(this.templateMarker) || !this.templates.containsKey(((String)values[yy]).substring(1))) continue;
                    values[yy] = this.templates.get(((String)values[yy]).substring(1));
                }
            }
            resultSet.addRow(values);
        }
        return resultSet;
    }
}

