/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.AbstractResultSetHandler;
import com.mockrunner.jdbc.ParameterSets;
import com.mockrunner.mock.jdbc.MockParameterMap;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParameterResultSetHandler
extends AbstractResultSetHandler {
    protected boolean exactMatchParameter = false;
    private final Map<String, ParameterSets> executedStatementParameters = new TreeMap<String, ParameterSets>();

    public void addParameterMapForExecutedStatement(String sql, MockParameterMap parameters) {
        if (null != parameters) {
            if (null == this.executedStatementParameters.get(sql)) {
                this.executedStatementParameters.put(sql, new ParameterSets(sql));
            }
            ParameterSets sets = this.executedStatementParameters.get(sql);
            sets.addParameterSet(parameters);
        }
    }

    public ParameterSets getParametersForExecutedStatement(String sql) {
        return this.executedStatementParameters.get(sql);
    }

    public Map<String, ParameterSets> getExecutedStatementParameterMap() {
        return Collections.unmodifiableMap(this.executedStatementParameters);
    }

    @Deprecated
    public Map<String, ParameterSets> getExecutedStatementParameter() {
        return this.getExecutedStatementParameterMap();
    }

    public void setExactMatchParameter(boolean exactMatchParameter) {
        this.exactMatchParameter = exactMatchParameter;
    }

    public Integer getUpdateCount(String sql, MockParameterMap parameters) {
        return this.getUpdateCount(sql, parameters, this.exactMatchParameter);
    }

    public Integer[] getUpdateCounts(String sql, MockParameterMap parameters) {
        return this.getUpdateCounts(sql, parameters, this.exactMatchParameter);
    }

    public boolean hasMultipleUpdateCounts(String sql, MockParameterMap parameters) {
        return this.hasMultipleUpdateCounts(sql, parameters, this.exactMatchParameter);
    }

    public MockResultSet getResultSet(String sql, MockParameterMap parameters) {
        return this.getResultSet(sql, parameters, this.exactMatchParameter);
    }

    public MockResultSet[] getResultSets(String sql, MockParameterMap parameters) {
        return this.getResultSets(sql, parameters, this.exactMatchParameter);
    }

    public boolean hasMultipleResultSets(String sql, MockParameterMap parameters) {
        return this.hasMultipleResultSets(sql, parameters, this.exactMatchParameter);
    }

    public boolean getThrowsSQLException(String sql, MockParameterMap parameters) {
        return this.getSQLException(sql, parameters) != null;
    }

    public SQLException getSQLException(String sql, MockParameterMap parameters) {
        return this.getSQLException(sql, parameters, this.exactMatchParameter);
    }

    public MockResultSet getGeneratedKeys(String sql, MockParameterMap parameters) {
        return this.getGeneratedKeys(sql, parameters, this.exactMatchParameter);
    }

    @Override
    public void prepareResultSet(String sql, MockResultSet resultSet) {
        this.prepareResultSet(sql, resultSet, new MockParameterMap());
    }

    @Override
    public void prepareResultSets(String sql, MockResultSet[] resultSets) {
        this.prepareResultSets(sql, resultSets, new MockParameterMap());
    }

    public void prepareResultSet(String sql, MockResultSet resultSet, Object[] parameters) {
        this.prepareResultSet(sql, resultSet, Arrays.asList(parameters));
    }

    public void prepareResultSets(String sql, MockResultSet[] resultSets, Object[] parameters) {
        this.prepareResultSets(sql, resultSets, Arrays.asList(parameters));
    }

    public void prepareResultSet(String sql, MockResultSet resultSet, List<Object> parameters) {
        MockParameterMap params = this.createParameterMap(parameters);
        this.prepareResultSet(sql, resultSet, params);
    }

    public void prepareResultSets(String sql, MockResultSet[] resultSets, List<Object> parameters) {
        MockParameterMap params = this.createParameterMap(parameters);
        this.prepareResultSets(sql, resultSets, params);
    }

    @Override
    public void prepareResultSet(String sql, MockResultSet resultSet, MockParameterMap parameters) {
        super.prepareResultSet(sql, resultSet, parameters);
    }

    @Override
    public void prepareResultSets(String sql, MockResultSet[] resultSets, MockParameterMap parameters) {
        super.prepareResultSets(sql, resultSets, parameters);
    }

    @Override
    public void prepareThrowsSQLException(String sql) {
        this.prepareThrowsSQLException(sql, new MockParameterMap());
    }

    public void prepareThrowsSQLException(String sql, Object[] parameters) {
        SQLException exc = new SQLException("Statement " + sql + " was specified to throw an exception");
        this.prepareThrowsSQLException(sql, exc, parameters);
    }

    public void prepareThrowsSQLException(String sql, List<Object> parameters) {
        SQLException exc = new SQLException("Statement " + sql + " was specified to throw an exception");
        this.prepareThrowsSQLException(sql, exc, parameters);
    }

    @Override
    public void prepareThrowsSQLException(String sql, MockParameterMap parameters) {
        super.prepareThrowsSQLException(sql, parameters);
    }

    @Override
    public void prepareThrowsSQLException(String sql, SQLException exc) {
        this.prepareThrowsSQLException(sql, new MockParameterMap());
    }

    public void prepareThrowsSQLException(String sql, SQLException exc, Object[] parameters) {
        this.prepareThrowsSQLException(sql, exc, Arrays.asList(parameters));
    }

    public void prepareThrowsSQLException(String sql, SQLException exc, List<Object> parameters) {
        MockParameterMap params = this.createParameterMap(parameters);
        this.prepareThrowsSQLException(sql, exc, params);
    }

    @Override
    public void prepareThrowsSQLException(String sql, SQLException exc, MockParameterMap parameters) {
        super.prepareThrowsSQLException(sql, exc, parameters);
    }

    @Override
    public void prepareUpdateCount(String sql, int updateCount) {
        this.prepareUpdateCount(sql, updateCount, new MockParameterMap());
    }

    @Override
    public void prepareUpdateCounts(String sql, Integer[] updateCounts) {
        this.prepareUpdateCounts(sql, updateCounts, new MockParameterMap());
    }

    public void prepareUpdateCount(String sql, int updateCount, Object[] parameters) {
        this.prepareUpdateCount(sql, updateCount, Arrays.asList(parameters));
    }

    public void prepareUpdateCounts(String sql, Integer[] updateCounts, Object[] parameters) {
        this.prepareUpdateCounts(sql, updateCounts, Arrays.asList(parameters));
    }

    public void prepareUpdateCount(String sql, int updateCount, List<Object> parameters) {
        MockParameterMap params = this.createParameterMap(parameters);
        this.prepareUpdateCount(sql, updateCount, params);
    }

    public void prepareUpdateCounts(String sql, Integer[] updateCounts, List<Object> parameters) {
        MockParameterMap params = this.createParameterMap(parameters);
        this.prepareUpdateCounts(sql, updateCounts, params);
    }

    @Override
    public void prepareUpdateCount(String sql, int updateCount, MockParameterMap parameters) {
        super.prepareUpdateCount(sql, updateCount, parameters);
    }

    @Override
    public void prepareUpdateCounts(String sql, Integer[] updateCounts, MockParameterMap parameters) {
        super.prepareUpdateCounts(sql, updateCounts, parameters);
    }

    @Override
    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult) {
        this.prepareGeneratedKeys(sql, generatedKeysResult, new MockParameterMap());
    }

    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult, Object[] parameters) {
        this.prepareGeneratedKeys(sql, generatedKeysResult, Arrays.asList(parameters));
    }

    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult, List<Object> parameters) {
        MockParameterMap params = this.createParameterMap(parameters);
        this.prepareGeneratedKeys(sql, generatedKeysResult, params);
    }

    @Override
    public void prepareGeneratedKeys(String sql, MockResultSet generatedKeysResult, MockParameterMap parameters) {
        super.prepareGeneratedKeys(sql, generatedKeysResult, parameters);
    }

    public void removeResultSet(String sql, MockParameterMap parameters) {
        super.removeResultSet(sql, parameters, this.exactMatchParameter);
    }

    public void removeThrowsSqlException(String sql, MockParameterMap parameters) {
        super.removeThrowsSqlException(sql, parameters, this.exactMatchParameter);
    }

    public void removeUpdateCount(String sql, MockParameterMap parameters) {
        super.removeUpdateCount(sql, parameters, this.exactMatchParameter);
    }

    public void removeGeneratedKeys(String sql, MockParameterMap parameters) {
        super.removeGeneratedKeys(sql, parameters, this.exactMatchParameter);
    }

    private MockParameterMap createParameterMap(List<Object> parameters) {
        MockParameterMap params = new MockParameterMap();
        for (int ii = 0; ii < parameters.size(); ++ii) {
            params.put(ii + 1, parameters.get(ii));
        }
        return params;
    }
}

