/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.ejb;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.ejb.Configuration;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.mockejb.jndi.MockContextFactory;

public class JNDIUtil {
    public static void initMockContextFactory() throws NamingException {
        String factory = System.getProperty("java.naming.factory.initial");
        if (null == factory || !factory.equals(MockContextFactory.class.getName())) {
            MockContextFactory.setAsInitial();
        }
    }

    public static void resetMockContextFactory() {
        String factory = System.getProperty("java.naming.factory.initial");
        if (null != factory && factory.equals(MockContextFactory.class.getName())) {
            MockContextFactory.revertSetAsInitial();
        }
    }

    public static Context getContext(Configuration configuration) {
        Context context = configuration.getContext();
        if (null == context) {
            try {
                JNDIUtil.initMockContextFactory();
                context = new InitialContext();
            }
            catch (NamingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
            configuration.setContext(context);
        }
        return context;
    }

    public static void bindUserTransaction(Configuration configuration, Context context, UserTransaction transaction) throws NamingException {
        if (configuration.getBindMockUserTransactionToJNDI()) {
            context.rebind(configuration.getUserTransactionJNDIName(), (Object)transaction);
            context.rebind("javax.transaction.UserTransaction", (Object)transaction);
            context.rebind("java:comp/UserTransaction", (Object)transaction);
        }
    }
}

