/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.web;

import com.mockrunner.base.NestedApplicationException;
import java.io.StringReader;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static Element getBodyFragmentFromJDOMDocument(Document document) {
        List childs;
        Element element = document.getRootElement().getChild("BODY");
        if (null == element) {
            element = document.getRootElement().getChild("body");
        }
        if (null != element && null != (childs = element.getChildren()) && childs.size() > 0) {
            return (Element)childs.get(0);
        }
        return null;
    }

    public static Element getBodyFragmentJDOMDocument(Document document) {
        return XmlUtil.getBodyFragmentFromJDOMDocument(document);
    }

    public static String createStringFromJDOMDocument(Document document) {
        try {
            return new XMLOutputter().outputString(document);
        }
        catch (Exception exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public static Document createJDOMDocument(org.w3c.dom.Document document) {
        return new DOMBuilder().build(document);
    }

    public static DOMParser getHTMLParser() {
        try {
            HTMLConfiguration config = new HTMLConfiguration();
            config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
            config.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
            DOMParser parser = new DOMParser((XMLParserConfiguration)config);
            return parser;
        }
        catch (Exception exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public static org.w3c.dom.Document parseHTML(String source) {
        try {
            return XmlUtil.parse(XmlUtil.getHTMLParser(), source);
        }
        catch (Exception exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public static org.w3c.dom.Document parse(DOMParser parser, String source) {
        try {
            parser.parse(new InputSource(new StringReader(source)));
            return parser.getDocument();
        }
        catch (Exception exc) {
            throw new NestedApplicationException(exc);
        }
    }
}

