/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.util.web.XmlUtil;
import java.io.FileInputStream;
import java.util.List;
import junit.framework.TestCase;
import org.jdom.Document;
import org.jdom.Element;

public class XmlUtilTest
extends TestCase {
    private String source;

    private void prepareHTMLFile() throws Exception {
        FileInputStream stream = new FileInputStream("target/test-classes/com/mockrunner/test/util/test.html");
        StringBuffer output = new StringBuffer();
        int nextChar = stream.read();
        while (-1 != nextChar) {
            output.append((char)nextChar);
            nextChar = stream.read();
        }
        this.source = output.toString();
    }

    private void prepareHTML() {
        StringBuffer output = new StringBuffer();
        output.append("<html>\n");
        output.append("<head>\n");
        output.append("<meta http-equiv=\"refresh\" content=\"");
        output.append("0;URL=http://www.mockrunner.com>\"\n");
        output.append("</head>\n");
        output.append("<body>\n");
        output.append("<h3>");
        output.append("You will be redirected to ");
        output.append("<a href=\"http://www.mockrunner.com\">");
        output.append("http://www.mockrunner.com</a>");
        output.append("</h3>\n");
        output.append("</body>\n");
        output.append("</html>\n");
        this.source = output.toString();
    }

    public void testParseHTML() throws Exception {
        this.prepareHTML();
        Document document = XmlUtil.createJDOMDocument(XmlUtil.parseHTML(this.source));
        Element rootElement = document.getRootElement();
        XmlUtilTest.assertEquals((String)"html", (String)rootElement.getName());
        List children = rootElement.getChildren();
        XmlUtilTest.assertTrue((children.size() == 2 ? 1 : 0) != 0);
        Element headElement = (Element)children.get(0);
        XmlUtilTest.assertEquals((String)"head", (String)headElement.getName());
        Element metaElement = headElement.getChild("meta");
        XmlUtilTest.assertEquals((String)"refresh", (String)metaElement.getAttributeValue("http-equiv"));
        XmlUtilTest.assertEquals((String)"0;URL=http://www.mockrunner.com>", (String)metaElement.getAttributeValue("content"));
        Element bodyElement = (Element)children.get(1);
        Element h3Element = bodyElement.getChild("h3");
        XmlUtilTest.assertEquals((String)"You will be redirected to ", (String)h3Element.getText());
        Element linkElement = h3Element.getChild("a");
        XmlUtilTest.assertEquals((String)"http://www.mockrunner.com", (String)linkElement.getAttributeValue("href"));
        XmlUtilTest.assertEquals((String)"http://www.mockrunner.com", (String)linkElement.getText());
    }

    public void testParseHTMLFile() throws Exception {
        this.prepareHTMLFile();
        Document document = XmlUtil.createJDOMDocument(XmlUtil.parseHTML(this.source));
        Element rootElement = document.getRootElement();
        XmlUtilTest.assertEquals((String)"html", (String)rootElement.getName());
        List children = rootElement.getChildren();
        XmlUtilTest.assertTrue((children.size() == 2 ? 1 : 0) != 0);
        Element headElement = (Element)children.get(0);
        XmlUtilTest.assertEquals((String)"head", (String)headElement.getName());
        Element bodyElement = (Element)children.get(1);
        XmlUtilTest.assertEquals((String)"body", (String)bodyElement.getName());
        Element table = XmlUtil.getBodyFragmentFromJDOMDocument(document);
        XmlUtilTest.assertEquals((String)"table", (String)table.getName());
    }
}

