/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.mobilefuse.sdk.AdError;
import com.mobilefuse.sdk.MobileFuse;
import com.mobilefuse.sdk.MobileFuseBannerAd;
import com.mobilefuse.sdk.MobileFuseInterstitialAd;
import com.mobilefuse.sdk.SdkInitListener;
import java.util.concurrent.atomic.AtomicBoolean;

public class MobileFuseMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter {
    private static final String PARAM_NAME_APP_KEY = "app_id";
    private static final String PARAM_NAME_CUSTOM_PARAMS_JSON = "custom_parameters";
    private static final String PARAM_NAME_BG_COLOR = "background_color";
    private static final String PARAM_NAME_INITIALLY_MUTED = "initiallyMuted";
    private Handler handler = new Handler(Looper.getMainLooper());
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus initializationStatus;
    private MobileFuseBannerAd bannerAd;
    private MobileFuseInterstitialAd interstitialAd;

    public MobileFuseMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
        this.logDebug("Create MobileFuse MAX adapter.");
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.logDebug("Try to initialize MobileFuse SDK");
        if (initialized.compareAndSet(false, true)) {
            Context context = activity != null ? activity.getApplicationContext() : this.getApplicationContext();
            Bundle serverParameters = parameters.getServerParameters();
            String appKey = serverParameters.getString(PARAM_NAME_APP_KEY, null);
            this.logDebug("Initializing MobileFuse SDK with App Key: " + appKey + "...");
            if (appKey == null) {
                this.logDebug("Can't initialize MobileFuse SDK. The appKey is null.");
                initialized.set(false);
                onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, null);
                return;
            }
            initializationStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            this.handler.post(() -> MobileFuse.init((Context)context, (String)appKey, (SdkInitListener)new SdkInitListener(){

                public void onInitSuccess() {
                    MobileFuseMediationAdapter.this.logDebug("MobileFuse SDK initialized");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(initializationStatus, null);
                }

                public void onInitError() {
                    MobileFuseMediationAdapter.this.logDebug("MobileFuse SDK failed to initialize");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(initializationStatus, "failed to initialize MobileFuse sdk");
                }
            }));
        } else {
            this.logDebug("MobileFuse SDK already initialized");
            onCompletionListener.onCompletion(initializationStatus, null);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat maxAdFormat, Activity activity, final MaxAdViewAdapterListener maxListener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.logDebug("Loading banner ad for placement \"" + placementId + "\"");
        MobileFuseBannerAd.AdSize adSize = MobileFuseBannerAd.AdSize.BANNER_320x50;
        if (maxAdFormat == MaxAdFormat.BANNER) {
            adSize = MobileFuseBannerAd.AdSize.BANNER_320x50;
        } else if (maxAdFormat == MaxAdFormat.LEADER) {
            adSize = MobileFuseBannerAd.AdSize.BANNER_728x90;
        } else if (maxAdFormat == MaxAdFormat.MREC) {
            adSize = MobileFuseBannerAd.AdSize.BANNER_300x250;
        }
        this.bannerAd = new MobileFuseBannerAd(activity, placementId, adSize);
        this.bannerAd.setListener(new MobileFuseBannerAd.Listener(){

            public void onAdExpanded() {
                MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdExpanded");
                maxListener.onAdViewAdExpanded();
            }

            public void onAdCollapsed() {
                MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdCollapsed");
                maxListener.onAdViewAdCollapsed();
            }

            public void onAdLoaded() {
                MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdLoaded");
                maxListener.onAdViewAdLoaded((View)MobileFuseMediationAdapter.this.bannerAd);
            }

            public void onAdNotFilled() {
                MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdNotFilled");
                maxListener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
            }

            public void onAdRendered() {
                MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdRendered");
                maxListener.onAdViewAdDisplayed();
            }

            public void onAdClicked() {
                MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdClicked");
                maxListener.onAdViewAdClicked();
            }

            public void onAdExpired() {
                MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdExpired");
                maxListener.onAdViewAdLoadFailed(MaxAdapterError.AD_EXPIRED);
            }

            public void onAdError(AdError adError) {
                if (adError != null) {
                    MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdError [adErrorCode" + adError.getErrorCode() + ", adErrorMsg: " + adError.getErrorMessage() + "]");
                } else {
                    MobileFuseMediationAdapter.this.logDebug("BannerAd::onAdError");
                }
                maxListener.onAdViewAdDisplayFailed(MaxAdapterError.INTERNAL_ERROR);
            }
        });
        if (parameters.getServerParameters() != null) {
            String backgroundColorValue;
            Bundle serverParameters = parameters.getServerParameters();
            Boolean initiallyMuted = this.getCustomParamBooleanValue(serverParameters, PARAM_NAME_INITIALLY_MUTED);
            if (initiallyMuted != null) {
                this.bannerAd.setMuted(initiallyMuted.booleanValue());
            }
            if ((backgroundColorValue = this.getCustomParamStringValue(serverParameters, PARAM_NAME_BG_COLOR)) != null) {
                if (backgroundColorValue.startsWith("#")) {
                    backgroundColorValue = backgroundColorValue.substring(1);
                } else if (backgroundColorValue.startsWith("0x")) {
                    backgroundColorValue = backgroundColorValue.substring(2);
                }
                if (backgroundColorValue.length() <= 6) {
                    backgroundColorValue = "ff" + backgroundColorValue;
                }
                long backgroundColor = -1L;
                try {
                    backgroundColor = Long.parseLong(backgroundColorValue, 16);
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                if (backgroundColor > -1L) {
                    this.bannerAd.setBackground((Drawable)new ColorDrawable((int)backgroundColor));
                }
            }
        }
        this.logDebug("Request BannerAd instance to load an ad.");
        this.bannerAd.loadAd();
    }

    private String getCustomParamStringValue(Bundle serverParameters, String customParamName) {
        try {
            Bundle customParams = this.getServerCustomParams(serverParameters);
            if (!customParams.containsKey(customParamName)) {
                return null;
            }
            return customParams.getString(customParamName).trim();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Boolean getCustomParamBooleanValue(Bundle serverParameters, String customParamName) {
        try {
            Bundle customParams = this.getServerCustomParams(serverParameters);
            if (!customParams.containsKey(customParamName)) {
                return null;
            }
            return customParams.getBoolean(customParamName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Bundle getServerCustomParams(Bundle serverParameters) {
        if (!serverParameters.containsKey(PARAM_NAME_CUSTOM_PARAMS_JSON)) {
            return null;
        }
        return serverParameters.getBundle(PARAM_NAME_CUSTOM_PARAMS_JSON);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxInterstitialAdapterListener maxListener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.logDebug("Loading interstitial ad for placement \"" + placementId + "\"");
        this.interstitialAd = new MobileFuseInterstitialAd(activity, placementId);
        this.interstitialAd.setListener(new MobileFuseInterstitialAd.Listener(){

            public void onAdClosed() {
                MobileFuseMediationAdapter.this.logDebug("InterstitialAd::onAdClosed");
                maxListener.onInterstitialAdHidden();
            }

            public void onAdLoaded() {
                MobileFuseMediationAdapter.this.logDebug("InterstitialAd::onAdLoaded");
                maxListener.onInterstitialAdLoaded();
            }

            public void onAdNotFilled() {
                MobileFuseMediationAdapter.this.logDebug("InterstitialAd::onAdNotFilled");
                maxListener.onInterstitialAdLoadFailed(MaxAdapterError.NO_FILL);
            }

            public void onAdRendered() {
                MobileFuseMediationAdapter.this.logDebug("InterstitialAd::onAdRendered");
                maxListener.onInterstitialAdDisplayed();
            }

            public void onAdClicked() {
                MobileFuseMediationAdapter.this.logDebug("InterstitialAd::onAdClicked");
                maxListener.onInterstitialAdClicked();
            }

            public void onAdExpired() {
                MobileFuseMediationAdapter.this.logDebug("InterstitialAd::onAdExpired");
                maxListener.onInterstitialAdLoadFailed(MaxAdapterError.AD_EXPIRED);
            }

            public void onAdError(AdError adError) {
                if (adError != null) {
                    MobileFuseMediationAdapter.this.logDebug("InterstitialAd::onAdError [adErrorCode" + adError.getErrorCode() + ", adErrorMsg: " + adError.getErrorMessage() + "]");
                } else {
                    MobileFuseMediationAdapter.this.logDebug("InterstitialAd::onAdError");
                }
            }
        });
        this.logDebug("Request InterstitialAd instance to load an ad.");
        this.interstitialAd.loadAd();
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener maxListener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.logDebug("Showing interstitial ad for placement \"" + placementId);
        if (this.interstitialAd == null || !this.interstitialAd.isLoaded()) {
            maxListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
            return;
        }
        this.interstitialAd.showAd();
    }

    public String getSdkVersion() {
        return MobileFuse.getSdkVersion();
    }

    public String getAdapterVersion() {
        return "1.2.2.0";
    }

    public void onDestroy() {
        this.logDebug("Destroy adapter");
        try {
            if (this.bannerAd != null) {
                this.bannerAd.destroy();
                this.bannerAd = null;
            }
            this.interstitialAd = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void logDebug(String msg) {
        Log.d((String)"MobileFuse MAX adapter", (String)(msg + " (adapter instance: " + ((Object)((Object)this)).hashCode() + ")"));
    }
}

