/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.mobgame.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class InstallReceiver
extends BroadcastReceiver {
    private final String TAG = InstallReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        com.mobgame.ads.InstallReceiver i = new com.mobgame.ads.InstallReceiver();
        i.onReceive(context, intent);
        if (intent != null) {
            Bundle extras = intent.getExtras();
            if (extras != null && extras.containsKey("referrer")) {
                String referrerString = extras.getString("referrer");
                Log.d((String)this.TAG, (String)("referrerString :" + referrerString));
                if (!referrerString.equals("")) {
                    String afterReferrerString = InstallReceiver.filterNonAscii(referrerString);
                    Utils.setReferrer(context, afterReferrerString);
                } else {
                    Utils.setReferrer(context, "");
                }
            } else {
                Utils.setReferrer(context, null);
            }
        } else {
            Utils.setReferrer(context, null);
        }
    }

    public static String filterNonAscii(String inString) {
        Charset charset = Charset.forName("US-ASCII");
        CharsetDecoder decoder = charset.newDecoder();
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        String result = inString;
        try {
            ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(inString));
            CharBuffer cbuf = decoder.decode(bbuf);
            result = cbuf.toString();
        }
        catch (CharacterCodingException cce) {
            String string2 = "Exception during character encoding/decoding: " + cce.getMessage();
            cce.printStackTrace();
        }
        return result;
    }
}

