package com.mobgame.js;

import android.app.Activity;
import android.util.Log;
import android.webkit.JavascriptInterface;

import com.mobgame.gui.MobGameHaveBackButtonFragment;
import com.mobgame.gui.MobGameSocialDialogFragment;
import com.mobgame.gui.MobGameWebFragment;

public class JsHandler {

	private static String TAG = JsHandler.class.getSimpleName();

	private Activity activity;
	private MobGameWebFragment webFragment;
	private MobGameSocialDialogFragment webDialogFragment;
	private MobGameHaveBackButtonFragment webDialogHaveBackButton;

	private enum switchCommandJS {
		mobLoginSuccess, // Login thanh cong
		mobLoginStartFb, // login FB
		mobFacebookForUpdate, 
		mobLoginGuest,
		mobLoginGooglePlay,
		mobLoginStartGg,
		mobOpenFanPage,
		mobOpenGroup, 
		mobOpenContact,
		mobPaymentStartIAP, 
		mobPaymentStartPayPal,
		mobPaymentSuccess, 
		mobOpenBrowser, 
		mobOpenModal,
		mobSendEmail, 
		mobSendSMS,
		mobAppInvite,
		mobOpenOfferWall,
		mobMakePhoneCall,
		mobActionShareFB,
		mobCopyToClipboard,
		loadImageUpload,
		mobGetIssue,
		deleteImageData,
		mobGetError,
		mobCloseWindow,
		mobChooseFriend,
		mobLoginZalo
	}
	public JsHandler(Activity activity){
		this.activity = activity;
	}
	public JsHandler(Activity activity, MobGameWebFragment webFragment) {
		this.activity = activity;
		this.webFragment = webFragment;
	}
	public JsHandler(Activity activity, MobGameSocialDialogFragment webDialogFragment) {
		this.activity = activity;
		this.webDialogFragment = webDialogFragment;
	}
	public JsHandler(Activity activity, MobGameHaveBackButtonFragment webDialogHaveBackButton) {
		this.activity = activity;
		this.webDialogHaveBackButton = webDialogHaveBackButton;
	}

	@JavascriptInterface
	public void mobAppSDKexecute(String command, String params) {
		Log.i(TAG, "mobAppSDKexecute: command = " + command + "; params = " + params);

		switch (switchCommandJS.valueOf(command)) {

			/**********  LOGIN  **********/
			case mobLoginStartFb:
				CmdLogin.getInstance().mobLoginFacebook(activity, webFragment, params);
				break;
			case mobFacebookForUpdate:
				CmdLogin.getInstance().mobUpgradeFacebook(activity, webFragment, params);
				break;
			case mobLoginStartGg:
				CmdLogin.getInstance().mobLoginGoogleAccount(activity, webFragment, params);
				break;
			case mobLoginGooglePlay:
				CmdLogin.getInstance().mobLoginGooglePlay(activity, webFragment, params);
				break;
			case mobLoginGuest:
				CmdLogin.getInstance().mobLoginGuest(activity, webFragment, params);
				break;
			case mobLoginSuccess:
				CmdLogin.getInstance().mobLoginSuccess(activity, webFragment, params);
				break;
			case mobLoginZalo:
				CmdLogin.getInstance().mobLoginZalo(activity , webFragment , params);
				break;
			// END LOGIN

			/**********  PAYMENT  **********/
			case mobPaymentStartIAP:
				CmdPayment.getInstance().mobPaymentStartIAP(activity, params);
				break;
//		case mobPaymentStartPayPal:
//			CmdPayment.getInstance().mobPaymentStartPaypal(activity, params);
//			break;
			case mobPaymentSuccess:
				CmdPayment.getInstance().mobPaymentSuccess(activity, params);
				break;
			// END PAYMENT

			/**********  DASHBOARD  **********/
			case mobOpenContact:
				CmdDashboard.getInstance().mobOpenContact(activity, params);
				break;
			case mobAppInvite:
				CmdDashboard.getInstance().mobAppInvite(activity, params);
				break;
			case mobActionShareFB:
				CmdDashboard.getInstance().mobAppShare(activity, params);
				break;
			case mobSendEmail:
				CmdDashboard.getInstance().mobSendEmail(activity, params);
				break;
			case mobSendSMS:
				CmdDashboard.getInstance().mobSendSMS(activity, params);
				break;
			case mobOpenBrowser:
				CmdDashboard.getInstance().mobOpenBrowser(activity, params);
				break;
			case mobOpenFanPage:
				CmdDashboard.getInstance().mobOpenFBFanpage(activity, params);
				break;
			case mobOpenGroup:
				CmdDashboard.getInstance().mobOpenFBGroup(activity, params);
				break;
			case mobOpenModal:
				CmdDashboard.getInstance().mobOpenModal(activity, params);
				break;
			case mobMakePhoneCall:
				CmdDashboard.getInstance().mobMakePhoneCall(activity, params);
				break;
			case mobOpenOfferWall:
				CmdDashboard.getInstance().mobOpenOfferWall(activity, params);
				break;
			case mobCopyToClipboard:
				CmdDashboard.getInstance().mobCopyToClipboard(activity, params);
				break;
			case loadImageUpload:
				CmdDashboard.getInstance().mobSelectImage(activity, webFragment, params);
				break;
			case mobGetIssue:
				CmdDashboard.getInstance().mobGetIssue(activity, webFragment, params);
				break;
			case deleteImageData:
				CmdDashboard.getInstance().deleteImageData(activity, webFragment, params);
				break;

			case mobGetError:
				CmdDashboard.getInstance().clearImageData(activity);
				break;
			case mobCloseWindow:
				webDialogFragment.dismiss();
				break;
			case mobChooseFriend:
				CmdDashboard.getInstance().mobChooseFriend(activity, params);
				break;
			// END DASHBOARD
//		case openFormEvent:
//			MobGameWebFragment webfragment = new MobGameWebFragment();
//			break;
			default:
				break;
		}

	}


}