package com.mobgame.api;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;

import com.mobgame.MobGameSDK;
import com.mobgame.model.EncodedResponse;
import com.mobgame.utils.EncryptionUtils;

import java.io.IOException;
import java.util.Map;

import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostTask extends AsyncTask<Void, Void, Void> {

	private String url;
	private Map<String, String> postParams;
	private boolean isEncrypted;
	private Callback callback;
	private boolean isInviteFriend = false;
	private String accountId;

	public PostTask(String url) {
		this.url = url;
	}
	
	public PostTask(String url, boolean isEncrypted) {
		this.url = url;
		this.isEncrypted = isEncrypted;
	}
	
	public PostTask(String url, Map<String, String> postParams, boolean isEncrypted) {
		this.url = url;
		this.postParams = postParams;
		this.isEncrypted = isEncrypted;
	}
	
	public PostTask(String url, Map<String, String> postParams, boolean isEncrypted, Callback callback) {
		this.url = url;
		this.postParams = postParams;
		this.isEncrypted = isEncrypted;
		this.callback = callback;
	}
	public PostTask(String url, Map<String, String> postParams, boolean isEncrypted, boolean isInviteFriend ,
			String accountId,Callback callback ) {
		this.url = url;
		this.postParams = postParams;
		this.isEncrypted = isEncrypted;
		this.callback = callback;
		this.isInviteFriend = isInviteFriend;
		this.accountId = accountId;
	}
	public void setCallback(Callback callback) {
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		try {
			Context c = MobGameSDK.getApplicationContext();
			OkHttpClient client = RestfulApi.getCommonClient();
			
			RequestBody formBody;
			if (postParams == null) {
				formBody = RequestBody.create(null, new byte[0]);
			} else {
				FormBody.Builder builder = new FormBody.Builder();
				for (String key : postParams.keySet()) {
					builder.add(key, postParams.get(key));
				}
				formBody = builder.build();
			}

			if (isEncrypted) {
				Uri uri = Uri.parse(url);
				if (uri.getQueryParameter("sign") == null) {
					if(isInviteFriend){
						url = uri
								.buildUpon()
								.appendQueryParameter("sign", EncryptionUtils.getSignedString(c, accountId))
								.build()
								.toString(); 
					}else{
						url = uri
								.buildUpon()
								.appendQueryParameter("sign", EncryptionUtils.getSignedString(c))
								.build()
								.toString(); 
					}
					
				}
				Request request = new Request.Builder()
					.url(url)
					.method("POST", formBody)
					.build();
				String result = client.newCall(request).execute().body().string();
				if(isInviteFriend){
					if(callback != null){
						callback.onSuccess("success");
					}
				}else{
					EncodedResponse response = EncodedResponse.parse(result);
					if (callback != null) {
						callback.onSuccess(response.getDecodedData());
					}
				}

			} else {
				Request request = new Request.Builder()
					.url(url)
					.method("POST", formBody)
					.build();
				String response = client.newCall(request).execute().body().string();
				if (callback != null) {
					callback.onSuccess(response);
				}
			}

		} catch (IOException e) {
			e.printStackTrace();
			if (callback != null) {
				callback.onFailure(e);
			}
		}
		return null;
	}
	

	public interface Callback {
		public void onSuccess(String response);
		public void onFailure(Throwable e);
	}

}