/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import com.facebook.AccessToken;
import com.mobgame.R;
import com.mobgame.api.UpgradeToFacebookTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.LoginResponse;
import com.mobgame.model.MobAccessToken;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.Set;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MobGameUpgradeDialog
extends Dialog {
    private Activity activity;
    private TextView txtAlert;
    private TextView txtBonusFacebook;
    private TextView txtBonusEmail;
    private TextView txtBonusInfo;
    private TextView txtConnect;
    private Button btnUpgrade;
    private Button btnRegisterEmail;
    private Button btnUpgradeInfo;
    private Button btnCancel;
    private boolean isShowUpgrade = false;
    long startTime = 0L;
    Handler timerHandler = new Handler();
    Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            long millis = System.currentTimeMillis() - MobGameUpgradeDialog.this.startTime;
            int seconds = (int)(millis / 1000L);
            if ((seconds %= 60) <= 10) {
                if (MobGameUpgradeDialog.this.btnCancel != null) {
                    MobGameUpgradeDialog.this.btnCancel.setText((CharSequence)(Res.string((Context)MobGameUpgradeDialog.this.activity, R.string.remind_me) + " (" + (10 - seconds) + "s)"));
                }
                MobGameUpgradeDialog.this.timerHandler.postDelayed((Runnable)this, 1000L);
            } else if (MobGameUpgradeDialog.this.isShowing()) {
                MobGameUpgradeDialog.this.mOnCancelClickListener.onClick((View)MobGameUpgradeDialog.this.btnCancel);
                MobGameUpgradeDialog.this.dismiss();
                MobGameUpgradeDialog.this.isShowUpgrade = false;
            }
        }
    };
    View.OnClickListener mOnCancelClickListener;
    private FacebookManager.LoginCallback mFacebookCallback = new FacebookManager.LoginCallback(){

        @Override
        public void onSuccess(AccessToken accessToken, Set<String> recentlyGrantedPermissions, Set<String> recentlyDeniedPermissions) {
            new UpgradeToFacebookTask(accessToken.getToken(), new Callback<LoginResponse>(){

                public void onFailure(Call<LoginResponse> call, Throwable e) {
                    MobGameUpgradeDialog.this.handleException(MobGameUpgradeDialog.this.activity, e.getMessage());
                }

                public void onResponse(Call<LoginResponse> call, Response<LoginResponse> response) {
                    LoginResponse loginResponse = (LoginResponse)response.body();
                    if (loginResponse.getError() != 0) {
                        MobGameUpgradeDialog.this.handleException(MobGameUpgradeDialog.this.activity, loginResponse.getMessage());
                    } else {
                        MobAccessToken accessToken = loginResponse.getAccessToken();
                        GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "login");
                        LocalBroadcastManager.getInstance((Context)MobGameUpgradeDialog.this.activity).sendBroadcast(intent);
                        MobGameUpgradeDialog.this.dismiss();
                        MobGameUpgradeDialog.this.isShowUpgrade = false;
                    }
                }
            }).execute(new Void[0]);
        }

        @Override
        public void onError(Throwable t) {
            Utils.hideLoading();
        }

        @Override
        public void onCancel() {
            Utils.hideLoading();
        }
    };

    public MobGameUpgradeDialog(Activity a) {
        super((Context)a, R.style.MobUpgradeDialog);
        this.activity = a;
    }

    public MobGameUpgradeDialog(Activity a, int themeResId) {
        super((Context)a, R.style.MobUpgradeDialog);
        this.activity = a;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.dialog_upgrade);
        Window dialog_window = this.getWindow();
        dialog_window.setFlags(1024, 1024);
        this.btnUpgrade = (Button)this.findViewById(R.id.btn_upgrade_facebook);
        this.btnRegisterEmail = (Button)this.findViewById(R.id.btn_register_email);
        this.btnUpgradeInfo = (Button)this.findViewById(R.id.btn_upgrade_info);
        this.btnCancel = (Button)this.findViewById(R.id.btn_cancel);
        this.txtAlert = (TextView)this.findViewById(R.id.txt_alert);
        this.txtConnect = (TextView)this.findViewById(R.id.txt_connect_with_facebook_tip);
        this.txtBonusFacebook = (TextView)this.findViewById(R.id.txt_mobcoin_facebook);
        this.txtBonusEmail = (TextView)this.findViewById(R.id.txt_mobcoin_email);
        this.txtBonusInfo = (TextView)this.findViewById(R.id.txt_mobcoin_info);
        this.txtAlert.setText((CharSequence)Res.string((Context)this.activity, R.string.notice));
        this.btnRegisterEmail.setText((CharSequence)Res.string((Context)this.activity, R.string.bind_account));
        this.btnUpgradeInfo.setText((CharSequence)Res.string((Context)this.activity, R.string.complete_now));
        this.btnCancel.setText((CharSequence)Res.string((Context)this.activity, R.string.remind_me));
        UserInfo userInfo = GameConfigManager.getInstance().getUserInfo();
        UserInfo.UserDaily userDaily = null;
        if (userInfo != null) {
            userDaily = userInfo.getUserDaily();
        }
        if (userDaily == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)userDaily.getTooltip())) {
            this.txtConnect.setVisibility(0);
            this.txtConnect.setText((CharSequence)userDaily.getTooltip());
        } else {
            this.txtConnect.setVisibility(8);
        }
        this.btnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MobGameUpgradeDialog.this.dismiss();
                MobGameUpgradeDialog.this.isShowUpgrade = false;
                if (MobGameUpgradeDialog.this.mOnCancelClickListener != null) {
                    MobGameUpgradeDialog.this.mOnCancelClickListener.onClick(v);
                }
            }
        });
        int typeHello = userDaily.getTypeHello();
        if (typeHello == 2) {
            if (userDaily.getBonusFacebook() > 0) {
                this.txtBonusFacebook.setText((CharSequence)("+" + userDaily.getBonusFacebook()));
                this.txtBonusFacebook.setVisibility(0);
            }
            this.btnUpgrade.setVisibility(0);
            this.btnUpgrade.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MobGameUpgradeDialog.this.timerHandler != null) {
                        MobGameUpgradeDialog.this.timerHandler.removeCallbacks(MobGameUpgradeDialog.this.timerRunnable);
                        MobGameUpgradeDialog.this.btnCancel.setText((CharSequence)Res.string((Context)MobGameUpgradeDialog.this.activity, R.string.remind_me));
                    }
                    Utils.showLoading(MobGameUpgradeDialog.this.activity, Res.string((Context)MobGameUpgradeDialog.this.activity, R.string.connecting_facebook));
                    FacebookManager.getInstance().login(MobGameUpgradeDialog.this.activity, MobGameUpgradeDialog.this.mFacebookCallback);
                }
            });
        } else if (typeHello == 3) {
            if (userDaily.getBonusInfo() > 0) {
                this.txtBonusInfo.setText((CharSequence)("+" + userDaily.getBonusInfo()));
                this.txtBonusInfo.setVisibility(0);
            }
            final String fUrl = userDaily.getUpdateInfoDetails().getUrl();
            final int fType = userDaily.getUpdateInfoDetails().getType();
            this.btnUpgradeInfo.setVisibility(0);
            this.btnUpgradeInfo.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameUpgradeDialog.this.dismiss();
                    MobGameUpgradeDialog.this.isShowUpgrade = false;
                    Intent i = new Intent("com.mobgame.broadcast");
                    i.putExtra("category", "MobGameUpgradeDialog.btnUpgradeInfo");
                    LocalBroadcastManager.getInstance((Context)MobGameUpgradeDialog.this.activity).sendBroadcast(i);
                    if (fType == 2) {
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "mobOpenBrowser");
                        intent.putExtra("data", "{url:'" + fUrl + "'}");
                        LocalBroadcastManager.getInstance((Context)MobGameUpgradeDialog.this.activity.getApplicationContext()).sendBroadcast(intent);
                    } else if (fType == 1) {
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "dashboard");
                        intent.putExtra("data", "{items:[{action:'" + fUrl + "'}], autohide_header_bar:false, enable_side_menu:false}");
                        LocalBroadcastManager.getInstance((Context)MobGameUpgradeDialog.this.activity.getApplicationContext()).sendBroadcast(intent);
                    }
                }
            });
        } else if (typeHello == 4) {
            if (userDaily.getBonusFacebook() > 0) {
                this.txtBonusFacebook.setText((CharSequence)("+" + userDaily.getBonusFacebook()));
                this.txtBonusFacebook.setVisibility(0);
            }
            if (userDaily.getBonusEmail() > 0) {
                this.txtBonusEmail.setText((CharSequence)("+" + userDaily.getBonusEmail()));
                this.txtBonusEmail.setVisibility(0);
            }
            this.btnUpgrade.setVisibility(0);
            this.btnUpgrade.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MobGameUpgradeDialog.this.timerHandler != null) {
                        MobGameUpgradeDialog.this.timerHandler.removeCallbacks(MobGameUpgradeDialog.this.timerRunnable);
                        MobGameUpgradeDialog.this.btnCancel.setText((CharSequence)Res.string((Context)MobGameUpgradeDialog.this.activity, R.string.remind_me));
                    }
                    Utils.showLoading(MobGameUpgradeDialog.this.activity, Res.string((Context)MobGameUpgradeDialog.this.activity, R.string.connecting_facebook));
                    FacebookManager.getInstance().login(MobGameUpgradeDialog.this.activity, MobGameUpgradeDialog.this.mFacebookCallback);
                }
            });
            final String fUrl = userDaily.getUpgradeEmailDetails().getUrl();
            final int fType = userDaily.getUpgradeEmailDetails().getType();
            this.btnRegisterEmail.setVisibility(0);
            this.btnRegisterEmail.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameUpgradeDialog.this.dismiss();
                    MobGameUpgradeDialog.this.isShowUpgrade = false;
                    if (fType == 2) {
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "mobOpenBrowser");
                        intent.putExtra("data", "{url:'" + fUrl + "'}");
                        LocalBroadcastManager.getInstance((Context)MobGameUpgradeDialog.this.activity.getApplicationContext()).sendBroadcast(intent);
                    } else if (fType == 1) {
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "dashboard");
                        intent.putExtra("data", "{items:[{action:'" + fUrl + "'}], autohide_header_bar:false, enable_side_menu:false}");
                        LocalBroadcastManager.getInstance((Context)MobGameUpgradeDialog.this.activity.getApplicationContext()).sendBroadcast(intent);
                    }
                }
            });
        }
        this.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                MobGameUpgradeDialog.this.startTime = System.currentTimeMillis();
                MobGameUpgradeDialog.this.timerHandler.postDelayed(MobGameUpgradeDialog.this.timerRunnable, 500L);
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", "float_button");
                intent.putExtra("message", "hide");
                LocalBroadcastManager.getInstance((Context)MobGameUpgradeDialog.this.activity).sendBroadcast(intent);
            }
        });
    }

    public void setOnCancelClickListener(View.OnClickListener listener) {
        this.mOnCancelClickListener = listener;
        if (this.btnCancel != null) {
            this.btnCancel.setOnClickListener(listener);
        }
    }

    private void handleException(Activity activity, String message) {
        Toast.makeText((Context)activity, (CharSequence)message, (int)1).show();
        Utils.hideLoading();
    }

    public void show() {
        this.isShowUpgrade = true;
        UserInfo userInfo = GameConfigManager.getInstance().getUserInfo();
        if (userInfo != null) {
            super.show();
        }
    }

    public boolean isShowUpgrade() {
        return this.isShowUpgrade;
    }
}

