/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gcm.GCMBaseIntentService;
import com.google.android.gcm.GCMRegistrar;
import com.mobgame.R;
import com.mobgame.api.SaveGCMTask;
import com.mobgame.component.GameConfigManager;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

public class MobGameGCMIntentService
extends GCMBaseIntentService {
    private static final String TAG = MobGameGCMIntentService.class.getSimpleName();
    private static final String GCM_SENDER_ID = "461098885975";
    private static Class<?> mainClass;
    private static Handler registerHandler;

    public MobGameGCMIntentService() {
        super(new String[]{GCM_SENDER_ID});
    }

    protected int getDrawableSmall(Context c) {
        return Res.drawableResource(c, R.drawable.ic_stat_mob);
    }

    protected void onRegistered(Context c, String registrationId) {
        Log.i((String)TAG, (String)("onRegistered:" + registrationId));
        MobGameGCMIntentService.registerToServer(c, registrationId);
    }

    protected void onUnregistered(Context context, String regId) {
        Log.i((String)TAG, (String)("onUnregistered:" + regId));
    }

    protected void onError(Context context, String errorId) {
        Log.i((String)TAG, (String)("onError: " + errorId));
    }

    protected boolean onRecoverableError(Context context, String errorId) {
        Log.i((String)TAG, (String)("onRecoverableError: " + errorId));
        return super.onRecoverableError(context, errorId);
    }

    protected void onMessage(Context context, Intent messageIntent) {
        Log.i((String)TAG, (String)("onMessage: " + messageIntent));
        Vibrator v = (Vibrator)context.getSystemService("vibrator");
        v.vibrate(30L);
        Bundle extras = messageIntent.getExtras();
        String title = extras.getString("title");
        String message = extras.getString("message");
        String id2 = extras.getString("id");
        Log.i((String)TAG, (String)("id: " + id2));
        Log.i((String)TAG, (String)("title: " + title));
        Log.i((String)TAG, (String)("message: " + message));
        Intent intent = new Intent("com.mobgame.broadcast");
        intent.putExtra("category", "gcm");
        intent.putExtra("id", id2);
        intent.putExtra("title", title);
        intent.putExtra("mesage", message);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
        GameConfigManager.getInstance().setHasUnreadNotifications(true);
        if (!TextUtils.isEmpty((CharSequence)id2)) {
            Utils.addNtf(context, Integer.parseInt(id2));
        }
        if (!TextUtils.isEmpty((CharSequence)title) || !TextUtils.isEmpty((CharSequence)message)) {
            this.showNotification(context, title, message);
        }
    }

    protected void showNotification(Context context, String title, String message) {
        Log.i((String)TAG, (String)("showNotification:title=" + title + ";msg=" + message));
        try {
            Log.i((String)TAG, (String)("mainClass:" + mainClass));
            if (mainClass == null) {
                try {
                    String className = Preference.getString(context, "shared_pref_main_activity");
                    mainClass = Class.forName(className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            Drawable ico = this.getApplicationInfo().loadIcon(this.getPackageManager());
            Bitmap bitmap = Utils.drawableToBitmap(ico);
            int bitmapSize = (int)Math.min(64.0f * DeviceUtils.getDensity(context), (float)bitmap.getWidth());
            CharSequence appTitle = context.getApplicationInfo().loadLabel(context.getPackageManager());
            NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
            bigTextStyle.setBigContentTitle((CharSequence)title);
            bigTextStyle.bigText((CharSequence)message);
            bigTextStyle.setSummaryText(appTitle);
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder((Context)this).setWhen(System.currentTimeMillis()).setContentText((CharSequence)message).setContentTitle((CharSequence)title).setSmallIcon(this.getDrawableSmall(context)).setLargeIcon(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmapSize, (int)bitmapSize, (boolean)false)).setAutoCancel(true).setTicker((CharSequence)title).setNumber(Utils.countNtfs(context)).setStyle((NotificationCompat.Style)bigTextStyle).setDefaults(7);
            Intent resultIntent = new Intent((Context)this, mainClass);
            resultIntent.setFlags(0x14000000);
            resultIntent.putExtra("title", title);
            resultIntent.putExtra("message", message);
            TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this);
            stackBuilder.addParentStack(mainClass);
            stackBuilder.addNextIntent(resultIntent);
            PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)resultIntent, (int)0);
            mBuilder.setContentIntent(resultPendingIntent);
            NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
            mNotificationManager.notify(1, mBuilder.build());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void register(Context context) {
        Log.i((String)TAG, (String)"register");
        try {
            if (context instanceof Activity) {
                Activity activity = (Activity)context;
                mainClass = activity.getClass();
                Preference.save(context, "shared_pref_main_activity", mainClass.getName());
                Log.i((String)TAG, (String)("mainClass:" + mainClass.getName()));
            }
            Context appContext = context.getApplicationContext();
            GCMRegistrar.checkDevice((Context)appContext);
            GCMRegistrar.checkManifest((Context)appContext);
            String regId = GCMRegistrar.getRegistrationId((Context)appContext);
            Log.i((String)TAG, (String)("regId:" + regId));
            if (TextUtils.isEmpty((CharSequence)regId)) {
                Log.i((String)TAG, (String)"Automatically registers application on startup");
                GCMRegistrar.register((Context)appContext, (String[])new String[]{GCM_SENDER_ID});
            } else {
                MobGameGCMIntentService.registerToServer(appContext, regId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void destroy(Context context) {
        if (registerHandler != null) {
            registerHandler.removeCallbacksAndMessages(null);
        }
        GCMRegistrar.onDestroy((Context)context.getApplicationContext());
    }

    private static void registerToServer(Context context, String regId) {
        Log.i((String)TAG, (String)"register");
        if (!TextUtils.isEmpty((CharSequence)regId)) {
            new SaveGCMTask(regId).execute(new Void[0]);
        }
    }

    static {
        registerHandler = new Handler();
    }
}

