/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.cache;

import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.cache.RequestCacheData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final int CACHE_MAX_SIZE = 40;
    public static final String AF_CACHE_DIR = "AFRequestCache";
    private static CacheManager ourInstance = new CacheManager();

    public static CacheManager getInstance() {
        return ourInstance;
    }

    private CacheManager() {
    }

    private File getCacheDir(Context context) {
        return new File(context.getFilesDir(), AF_CACHE_DIR);
    }

    public void init(Context context) {
        try {
            if (!this.getCacheDir(context).exists()) {
                this.getCacheDir(context).mkdir();
            }
        }
        catch (Exception e) {
            Log.i((String)AppsFlyerLib.LOG_TAG, (String)"Could not create cache directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cacheRequest(RequestCacheData data, Context context) {
        OutputStreamWriter out = null;
        try {
            File cacheDir = this.getCacheDir(context);
            if (!cacheDir.exists()) {
                cacheDir.mkdir();
                return;
            }
            File[] cacheFileList = cacheDir.listFiles();
            if (cacheFileList != null && cacheFileList.length > 40) {
                Log.i((String)AppsFlyerLib.LOG_TAG, (String)"reached cache limit, not caching request");
                return;
            }
            Log.i((String)AppsFlyerLib.LOG_TAG, (String)"caching request...");
            File requestFile = new File(this.getCacheDir(context), Long.toString(System.currentTimeMillis()));
            requestFile.createNewFile();
            out = new OutputStreamWriter(new FileOutputStream(requestFile.getPath(), true));
            out.write("version=");
            out.write(data.getVersion());
            out.write(10);
            out.write("url=");
            out.write(data.getRequestURL());
            out.write(10);
            out.write("data=");
            out.write(data.getPostData());
            out.write(10);
            out.flush();
            return;
        }
        catch (Exception e) {
            Log.i((String)AppsFlyerLib.LOG_TAG, (String)"Could not cache request");
            return;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public List<RequestCacheData> getCachedRequests(Context context) {
        ArrayList<RequestCacheData> requests = new ArrayList<RequestCacheData>();
        try {
            File cacheDir = this.getCacheDir(context);
            if (!cacheDir.exists()) {
                cacheDir.mkdir();
            } else {
                File[] files;
                for (File file : files = cacheDir.listFiles()) {
                    Log.i((String)AppsFlyerLib.LOG_TAG, (String)("Found cached request" + file.getName()));
                    requests.add(this.loadRequestData(file));
                }
            }
        }
        catch (Exception e) {
            Log.i((String)AppsFlyerLib.LOG_TAG, (String)"Could not cache request");
        }
        return requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestCacheData loadRequestData(File file) {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            char[] chars = new char[(int)file.length()];
            reader.read(chars);
            RequestCacheData cacheData = new RequestCacheData(chars);
            cacheData.setCacheKey(file.getName());
            RequestCacheData requestCacheData = cacheData;
            return requestCacheData;
        }
        catch (Exception e) {
            RequestCacheData requestCacheData = null;
            return requestCacheData;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void deleteRequest(String cacheKey, Context context) {
        File cacheDir = this.getCacheDir(context);
        File cachedRequestFile = new File(cacheDir, cacheKey);
        Log.i((String)AppsFlyerLib.LOG_TAG, (String)("Deleting " + cacheKey + " from cache"));
        if (cachedRequestFile.exists()) {
            try {
                cachedRequestFile.delete();
            }
            catch (Exception e) {
                Log.i((String)AppsFlyerLib.LOG_TAG, (String)("Could not delete " + cacheKey + " from cache"), (Throwable)e);
            }
        }
    }
}

