/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.floatbutton;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.OvershootInterpolator;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mobgame.R;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.gui.floatbutton.MobGameFloatConfirmDialog;
import com.mobgame.gui.floatbutton.MobGameFloatGestureView;
import com.mobgame.gui.floatbutton.MobGameFloatMenuView;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.Calendar;

@SuppressLint(value={"InflateParams", "ClickableViewAccessibility"})
public class MobGameOverlayView {
    private static final int ANIMAION_TIME_ROTATE = 800;
    private static final int ANIMAION_TIME_FADE_OUT = 400;
    private static final int ANIMAION_TIME_FADE_IN = 400;
    private static final int IDLE_TIME = 6000;
    private static final int IDLE_TIME2 = 2000;
    private Activity activity;
    private View rootView;
    private View layoutBottom;
    private View layoutFloat;
    private TextView txtDismiss;
    private Handler idleHandler = new Handler();
    private MobGameFloatGestureView floatArea;
    private ImageView floatButton;
    private ImageView floatButtonNtf;
    private MobGameFloatMenuView floatMenu;
    private boolean isInit;
    private boolean isShowingMenu;
    private boolean isOutsideBottomArea;
    private int boundWidth;
    private int boundHeight;
    private int relativePositionOnScreen;
    private int statusBarHeight;
    private float density;
    private boolean isShowDialogAgain;
    private Runnable mIdleRunnable = new Runnable(){

        @Override
        public void run() {
            if (!MobGameOverlayView.this.isShowingMenu) {
                MobGameOverlayView.this.fadeOut(true);
            } else {
                MobGameOverlayView.this.hideMenu();
                MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 6000L);
            }
        }
    };
    private Runnable mIdleRunnable2 = new Runnable(){

        @Override
        public void run() {
            MobGameOverlayView.this.fadeOut2(true);
        }
    };
    private MobGameFloatGestureView.EventListener mButtonEventListener = new MobGameFloatGestureView.EventListener(){

        @Override
        public void onTouchDown(MotionEvent event) {
            MobGameOverlayView.this.isOutsideBottomArea = true;
            MobGameOverlayView.this.fadeIn(false);
        }

        @Override
        public void onTouchMove(MotionEvent event) {
            MobGameOverlayView.this.hideMenu();
            if (MobGameOverlayView.this.isInBottomArea(event.getRawX(), event.getRawY())) {
                if (MobGameOverlayView.this.isOutsideBottomArea) {
                    MobGameOverlayView.this.showLayoutBottom();
                }
                MobGameOverlayView.this.isOutsideBottomArea = false;
            } else {
                if (!MobGameOverlayView.this.isOutsideBottomArea) {
                    MobGameOverlayView.this.hideLayoutBottom();
                }
                MobGameOverlayView.this.isOutsideBottomArea = true;
            }
            if (MobGameOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                MobGameOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
                MobGameOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)194, (int)39, (int)45));
            } else {
                MobGameOverlayView.this.txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
                MobGameOverlayView.this.txtDismiss.setTextColor(Color.rgb((int)255, (int)255, (int)255));
            }
        }

        @Override
        public void onTouchUp(MotionEvent event) {
            MobGameOverlayView.this.idleHandler.removeCallbacksAndMessages(null);
            MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 6000L);
            MobGameOverlayView.this.hideLayoutBottom();
            MobGameOverlayView.this.floatArea.moveToEdge(true);
            if (event != null && MobGameOverlayView.this.isInDismissArea(event.getRawX(), event.getRawY())) {
                MobGameOverlayView.this.isShowDialogAgain = Preference.getBoolean((Context)MobGameOverlayView.this.activity, "shared_pref_float_button_show_dialog", true);
                if (MobGameOverlayView.this.isShowDialogAgain) {
                    MobGameOverlayView.this.showConfirmDialog();
                }
                MobGameOverlayView.this.layoutFloat.setVisibility(8);
                MobGameOverlayView.this.floatArea.hide();
                MobGameOverlayView.this.hideMenu();
                long dismissTime = Calendar.getInstance().getTimeInMillis();
                Preference.save((Context)MobGameOverlayView.this.activity, "shared_pref_float_button_dismiss_time", dismissTime);
            }
        }

        @Override
        public void onClick(MotionEvent event) {
            if (MobGameOverlayView.this.isShowingMenu) {
                MobGameOverlayView.this.hideMenu();
            } else {
                MobGameOverlayView.this.showMenu();
            }
        }

        @Override
        public void onMove(int x, int y) {
            x = Math.max(0, Math.min(MobGameOverlayView.this.boundWidth - MobGameOverlayView.this.floatArea.getSizeInPixels(), x));
            y = Math.max(0, Math.min(MobGameOverlayView.this.boundHeight - MobGameOverlayView.this.relativePositionOnScreen - MobGameOverlayView.this.floatArea.getSizeInPixels(), y));
            MobGameOverlayView.this.layoutFloat.setX((float)x);
            MobGameOverlayView.this.layoutFloat.setY((float)y);
        }
    };
    private MobGameFloatMenuView.EventListener mMenuEventListener = new MobGameFloatMenuView.EventListener(){

        @Override
        public void onShow() {
            MobGameOverlayView.this.idleHandler.removeCallbacksAndMessages(null);
            MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 6000L);
            MobGameOverlayView.this.floatButton.animate().setDuration(800L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).rotation(90.0f).setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator anim2) {
                }

                public void onAnimationRepeat(Animator anim2) {
                }

                public void onAnimationEnd(Animator anim2) {
                    MobGameOverlayView.this.isShowingMenu = true;
                }

                public void onAnimationCancel(Animator anim2) {
                }
            });
        }

        @Override
        public void onHide() {
            MobGameOverlayView.this.idleHandler.removeCallbacksAndMessages(null);
            MobGameOverlayView.this.idleHandler.postDelayed(MobGameOverlayView.this.mIdleRunnable, 6000L);
            MobGameOverlayView.this.hideLayoutBottom();
            MobGameOverlayView.this.floatArea.moveToEdge(true);
            MobGameOverlayView.this.floatButton.animate().setDuration(800L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).rotation(0.0f).setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator arg0) {
                }

                public void onAnimationRepeat(Animator arg0) {
                }

                public void onAnimationEnd(Animator arg0) {
                    MobGameOverlayView.this.isShowingMenu = false;
                }

                public void onAnimationCancel(Animator arg0) {
                }
            });
        }

        @Override
        public void onClick(View v, MobMenuItem menuItem) {
            MobGameOverlayView.this.hideMenu();
            GoogleAnalyticsManager.getInstance().trackEvent("Float icon", "button_press", menuItem.getLabel(), 1L);
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", menuItem.getCommand());
            intent.putExtra("data", menuItem.getParams());
            LocalBroadcastManager.getInstance((Context)MobGameOverlayView.this.activity.getApplicationContext()).sendBroadcast(intent);
        }
    };
    DialogFragment dialog = null;

    public MobGameOverlayView(Activity a) {
        this.activity = a;
        this.floatMenu = new MobGameFloatMenuView(this.activity);
        this.floatArea = new MobGameFloatGestureView(this.activity);
        this.density = DeviceUtils.getDensity((Context)a);
        this.statusBarHeight = DeviceUtils.getStatusBarHeightInPixels((Context)this.activity);
        this.attachView();
        this.initView();
        this.hide();
    }

    public void attachView() {
        this.rootView = LayoutInflater.from((Context)this.activity).inflate(R.layout.float_overlay_view, null);
        WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2002, 8, -2);
        params.gravity = 51;
        params.flags = 56;
        windowManager.addView(this.rootView, (ViewGroup.LayoutParams)params);
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @SuppressLint(value={"NewApi"})
            public void onGlobalLayout() {
                if (MobGameOverlayView.this.rootView != null) {
                    MobGameOverlayView.this.boundWidth = MobGameOverlayView.this.rootView.getWidth();
                    MobGameOverlayView.this.boundHeight = MobGameOverlayView.this.rootView.getHeight();
                    MobGameOverlayView.this.floatArea.setMovableWidth(MobGameOverlayView.this.boundWidth);
                    MobGameOverlayView.this.floatArea.setMovableHeight(MobGameOverlayView.this.boundHeight);
                    int[] locations = new int[2];
                    MobGameOverlayView.this.rootView.getLocationOnScreen(locations);
                    MobGameOverlayView.this.relativePositionOnScreen = locations[1];
                    if (!MobGameOverlayView.this.isInit) {
                        MobGameOverlayView.this.isInit = true;
                        MobGameOverlayView.this.floatArea.moveTo(0, MobGameOverlayView.this.boundHeight / 2);
                    }
                }
            }
        });
    }

    public void initView() {
        this.layoutBottom = this.rootView.findViewById(R.id.layout_bottom);
        this.layoutFloat = this.rootView.findViewById(R.id.layout_float);
        this.txtDismiss = (TextView)this.rootView.findViewById(R.id.txt_dismiss);
        this.floatButton = (ImageView)this.rootView.findViewById(R.id.img_float);
        this.floatButtonNtf = (ImageView)this.rootView.findViewById(R.id.img_float_ntf);
        int imgRes = Res.drawableResource((Context)this.activity, R.drawable.float_button);
        this.floatButton.setImageResource(imgRes);
        this.floatMenu.setEventListener(this.mMenuEventListener);
        this.floatArea.setEventListener(this.mButtonEventListener);
        this.floatArea.moveTo(0, this.boundHeight / 2);
        this.txtDismiss.setText((CharSequence)Res.string((Context)this.activity, R.string.dismiss));
        this.layoutBottom.setY((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen) - 125.0f * this.density);
    }

    public void fadeOut(boolean isAnimated) {
        int buttonSize = this.floatArea.getSizeInPixels();
        int newX = this.boundWidth - buttonSize / 2;
        if (this.layoutFloat.getX() <= (float)(this.boundWidth / 2)) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.floatButtonNtf.getLayoutParams();
            lp.addRule(9, 0);
            lp.addRule(11, -1);
            this.floatButtonNtf.setLayoutParams((ViewGroup.LayoutParams)lp);
            newX = -buttonSize / 2;
        } else {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.floatButtonNtf.getLayoutParams();
            lp.addRule(9, -1);
            lp.addRule(11, 0);
            this.floatButtonNtf.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (isAnimated) {
            this.layoutFloat.animate().setDuration(400L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).x((float)newX);
        } else {
            this.layoutFloat.setX((float)newX);
        }
        this.idleHandler.postDelayed(this.mIdleRunnable2, 2000L);
    }

    public void fadeOut2(boolean isAnimated) {
        if (isAnimated) {
            this.layoutFloat.animate().setDuration(400L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).alpha(0.5f);
        } else {
            this.layoutFloat.setAlpha(0.5f);
        }
    }

    public void fadeIn(boolean isAnimated) {
        this.idleHandler.removeCallbacksAndMessages(null);
        if (isAnimated) {
            this.layoutFloat.animate().setDuration(400L).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).alpha(1.0f);
        } else {
            this.layoutFloat.setAlpha(1.0f);
        }
    }

    public void showMenu() {
        this.fadeIn(true);
        int floatY = this.floatArea.getY() - this.relativePositionOnScreen;
        int x = this.floatArea.getSizeInPixels();
        int y = Math.min(this.boundHeight - this.relativePositionOnScreen, floatY);
        if (this.floatMenu == null) {
            this.floatMenu = new MobGameFloatMenuView(this.activity);
        }
        if (this.floatArea.getX() > this.boundWidth / 2) {
            this.floatMenu.showInReverse(x, y, true);
        } else {
            this.floatMenu.show(x, y, true);
        }
    }

    public void hideMenu() {
        if (this.floatMenu != null) {
            this.floatMenu.hide();
        }
    }

    public void updateMenu() {
        if (this.floatMenu != null) {
            this.floatMenu.updateMenu();
        }
    }

    private boolean isInBottomArea(float left, float top) {
        int dY = (int)((float)this.boundHeight - 150.0f * this.density);
        return top >= (float)dY || this.isInDismissArea(left, top);
    }

    private boolean isInDismissArea(float left, float top) {
        double maxDistance;
        int dX = this.boundWidth / 2;
        int dY = (int)((float)this.boundHeight - 100.0f * this.density);
        double distance = Math.sqrt(Math.pow(left - (float)dX, 2.0) + Math.pow(top - (float)dY, 2.0));
        return distance <= (maxDistance = (double)Math.min(120.0f * this.density, (float)(this.boundWidth / 5))) || top >= (float)dY && (double)left >= (double)dX - maxDistance && (double)left <= (double)dX + maxDistance;
    }

    private void showLayoutBottom() {
        this.layoutBottom.setVisibility(0);
        this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen) - 125.0f * this.density);
    }

    private void hideLayoutBottom() {
        this.layoutBottom.animate().setDuration(200L).y((float)(this.boundHeight + this.statusBarHeight - this.relativePositionOnScreen));
    }

    public void showConfirmDialog() {
        try {
            this.dialog = new MobGameFloatConfirmDialog(this.activity, new MobGameFloatConfirmDialog.EventListener(){

                @Override
                public void onConfirmClick(View v) {
                    Preference.save((Context)MobGameOverlayView.this.activity, "shared_pref_float_button_show_dialog", MobGameOverlayView.this.isShowDialogAgain);
                    MobGameOverlayView.this.layoutFloat.setVisibility(8);
                    MobGameOverlayView.this.floatArea.hide();
                    MobGameOverlayView.this.hideMenu();
                    MobGameOverlayView.this.hideConfirmDialog();
                }

                @Override
                public void onCancelClick(View v) {
                    MobGameOverlayView.this.layoutFloat.setVisibility(8);
                    MobGameOverlayView.this.floatArea.hide();
                    MobGameOverlayView.this.hideMenu();
                    MobGameOverlayView.this.hideConfirmDialog();
                }

                @Override
                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MobGameOverlayView.this.isShowDialogAgain = !isChecked;
                }
            });
            this.dialog.show(this.activity.getFragmentManager(), "tag_fragment_confirm");
        }
        catch (Exception e) {
            this.hideConfirmDialog();
        }
    }

    public void hideConfirmDialog() {
        if (this.dialog != null && this.dialog.isAdded()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    public void show() {
        if (Utils.hasNtf((Context)this.activity)) {
            this.floatButtonNtf.setVisibility(0);
        } else {
            this.floatButtonNtf.setVisibility(8);
        }
        this.layoutFloat.setVisibility(0);
        this.layoutBottom.setVisibility(8);
        this.floatArea.show();
        this.hideConfirmDialog();
        this.fadeIn(false);
        this.idleHandler.removeCallbacksAndMessages(null);
        this.idleHandler.postDelayed(this.mIdleRunnable, 6000L);
    }

    public void hide() {
        this.hideMenu();
        this.layoutFloat.setVisibility(8);
        this.layoutBottom.setVisibility(8);
        this.floatArea.hide();
    }

    public void viberate() {
        this.show();
        Animation viberate = AnimationUtils.loadAnimation((Context)this.activity, (int)R.anim.viberate);
        this.floatButton.startAnimation(viberate);
    }

    public boolean isShowing() {
        return this.layoutFloat.getVisibility() == 0;
    }

    public boolean isShowingConfirmDialog() {
        return this.dialog != null && this.dialog.isVisible();
    }

    public void dismiss() {
        try {
            this.rootView.setVisibility(8);
            WindowManager windowManager = (WindowManager)this.activity.getApplicationContext().getSystemService("window");
            windowManager.removeView(this.rootView);
            if (this.floatMenu != null) {
                this.floatMenu.dismiss();
            }
            if (this.floatArea != null) {
                this.floatArea.dismiss();
            }
            this.rootView = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getFloatButtonX() {
        return this.floatArea.getX();
    }

    public int getFloatButtonY() {
        return this.floatArea.getY();
    }
}

