package com.mobgame.api;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import android.content.Context;
import android.os.AsyncTask;

import com.mobgame.MobGameSDK;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.MobMenu;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Constants;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;

public class GetInfoAfterAuthenTask extends AsyncTask<Void, Void, Void> {
	
	private Listener callback;
	
	public GetInfoAfterAuthenTask(Listener callback) {
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		Context c = MobGameSDK.getApplicationContext();
		String sign = EncryptionUtils.getSignedString(c);
		
		RestfulApi api = RestfulApi.getInstance();
		Call<EncodedResponse> call = api.getInfoAfterAuthen(sign);
		call.enqueue(new Callback<EncodedResponse>() {
			
			@Override
			public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
				
				Context c = MobGameSDK.getApplicationContext();
				UserInfo userInfo = null;
				
				String responseBody = response.body().getDecodedData();
				try {
					JSONObject json = new JSONObject(responseBody);
					if (json.has("saveLogin")) {
						String saveLogin = json.getString("saveLogin");
						
						if (saveLogin.equals("true") || saveLogin.equals("1")) {

							if (json.has("userInfo")) {
								String userInfoStr = json.getString("userInfo");
								userInfo = UserInfo.parse(userInfoStr);
							}
							
							if (json.has("ntf")) {
								String ntf = json.getString("ntf");
								JSONArray ntfs = new JSONArray(ntf);
								for (int i = 0; i < ntfs.length(); i++) {
									JSONObject ntfObj = ntfs.getJSONObject(i);
									if (ntfObj.has("id") && ntfObj.has("noti") 
									&& 	ntfObj.getBoolean("noti")) {
										Utils.addNtf(c, ntfObj.getInt("id"));
										GameConfigManager.getInstance().setHasUnreadNotifications(true);
									}
								}
							} else {
								GameConfigManager.getInstance().setHasUnreadNotifications(false);
							}
							
							if (json.has("menu")) {
								String menu = json.getString("menu");
								MobMenu mobMenu = MobMenu.parse(menu);
								GameConfigManager.getInstance().setMobMenu(mobMenu);
							} else {
								GameConfigManager.getInstance().clearMobMenu();
							}

							if (json.has("enable_dashboard")) {
								boolean value = json.getBoolean("enable_dashboard");
								Preference.save(c, 
										Constants.SHARED_PREF_DB_ENABLED, 
										value);
							} else {
								Preference.remove(c, Constants.SHARED_PREF_DB_ENABLED);
							}
							
							if (json.has("show_ads")) {
								boolean showAds = (json.getInt("show_ads") != 0);
								Preference.save(c, 
										Constants.SHARED_PREF_SHOW_ADS, 
										showAds);
							} else {
								Preference.remove(c, Constants.SHARED_PREF_SHOW_ADS);
							}

						} 
					}
				} catch (JSONException e) {
					if (callback != null) {
						callback.onFailure(e);
					}
				}
				
				if (callback != null) {
					callback.onSuccess(userInfo);
				}
			}
			
			@Override
			public void onFailure(Call<EncodedResponse> call, Throwable t) {
				if (callback != null) {
					callback.onFailure(t);
				}
			}
		});
		return null;
	}
	
	public interface Listener {
		public void onSuccess(UserInfo userInfo);
		public void onFailure(Throwable t);
	}
	
}