/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.forcelogout;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.annotation.NonNull;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.forcelogout.GameObj;
import com.game.sdk.ui.other.ForceLogoutActivity;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;

public class ForceLogout {
    private static String TAG = ForceLogout.class.getSimpleName();
    private Activity mActivity;
    private FirebaseDatabase mFirebaseDatabase;
    private DatabaseReference mDatabaseReference;
    private static ForceLogout instance;
    private ForceLogoutActivity mForceLogoutActivity;

    public static ForceLogout getInstance() {
        if (instance == null) {
            instance = new ForceLogout();
        }
        return instance;
    }

    public void init(Activity activity) {
        if (activity != null) {
            this.mActivity = activity;
        }
        this.mFirebaseDatabase = FirebaseDatabase.getInstance();
    }

    public void initFRB() {
        if (GameConfigs.getInstance().isLogin() && this.mActivity != null) {
            this.mDatabaseReference = this.mFirebaseDatabase.getReference("ForceLogout");
            this.mDatabaseReference.child(GameConfigs.getInstance().getAppKey()).addValueEventListener(new ValueEventListener(){

                public void onDataChange(@NonNull DataSnapshot snapshot) {
                    GameObj gameObj = (GameObj)snapshot.getValue(GameObj.class);
                    if (gameObj != null) {
                        Log.d((String)TAG, (String)("isForce: " + gameObj.getIsForce()));
                        ForceLogout.this.forceOut(gameObj);
                    }
                }

                public void onCancelled(@NonNull DatabaseError error) {
                    try {
                        Log.d((String)TAG, (String)("error code" + error.getCode()));
                        Log.d((String)TAG, (String)("error message" + error.getMessage()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void disconnectFRB() {
        if (this.mDatabaseReference != null && this.mFirebaseDatabase != null) {
            this.mDatabaseReference.onDisconnect();
            this.mFirebaseDatabase.goOffline();
        }
    }

    void forceOut(GameObj gameObj) {
        if (gameObj.getIsForce()) {
            if (this.mForceLogoutActivity == null) {
                this.mForceLogoutActivity = new ForceLogoutActivity();
            }
            this.mActivity.startActivity(new Intent((Context)this.mActivity, ((Object)((Object)this.mForceLogoutActivity)).getClass()));
        } else {
            this.mActivity.sendBroadcast(new Intent("cancel_force_logout"));
        }
    }

    public void exitGame() {
        try {
            this.disconnectFRB();
            this.mActivity.finish();
            System.gc();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

