package com.game.sdk.ui.other;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.forcelogout.ForceLogout;
import com.game.sdk.comon.utils.DialogUtils;
import com.mobgame.R;

public class ForceLogoutActivity extends AppCompatActivity {

    private BroadcastReceiver mReceiver;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_force_logout);


        mReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals(Constants.FORCE_RECIEVER)) {
                    DialogUtils.closeDialog();
                    finish();
                }
            }
        };
        registerReceiver(mReceiver, new IntentFilter(Constants.FORCE_RECIEVER));


        DialogUtils.showForceLogoutDialog(ForceLogoutActivity.this, new DialogUtils.DlgCloseListener() {
            @Override
            public void onClose() {
                ForceLogout.getInstance().exitGame();
            }
        });
    }

    @Override
    public void onBackPressed() {

    }
}