/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.game.sdk.comon.game.GameSdk;
import com.mobgame.MobGameSDK;
import com.mobgame.R;

public class DialogUtils {
    public static AlertDialog cf;

    public static void showExpireDialog(final Activity activity) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(false);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)activity.getString(R.string.err_title_dialog));
        builder1.setMessage((CharSequence)activity.getString(R.string.title_force_logout));
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MobGameSDK.getInstance().logout();
                GameSdk.getInstance().logOut(activity);
                System.gc();
                System.exit(0);
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showRetryDialog(Activity activity, String mess, final Listener listener) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(false);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)activity.getString(R.string.err_title_dialog));
        builder1.setMessage((CharSequence)mess);
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.lbl_retry), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
                if (listener != null) {
                    listener.onRetry();
                }
            }
        });
        builder1.setNeutralButton((CharSequence)activity.getString(R.string.exit), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                System.gc();
                System.exit(0);
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showRetryDialogWithLogOut(final Activity activity, String mess, final Listener listener) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(false);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)activity.getString(R.string.err_title_dialog));
        builder1.setMessage((CharSequence)mess);
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.lbl_retry), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
                if (listener != null) {
                    listener.onRetry();
                }
            }
        });
        builder1.setNeutralButton((CharSequence)activity.getString(R.string.lbl_log_out), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                GameSdk.getInstance().logOut(activity);
                dialog.dismiss();
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showInfoDialog(Activity activity, String title, String mess, final DlgListener listener) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(true);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)title);
        builder1.setMessage((CharSequence)mess);
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onOK();
                }
                cf.dismiss();
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showInfoDialog(Activity activity, String title, String mess) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(true);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)title);
        builder1.setMessage((CharSequence)mess);
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showErrorDialog(Activity activity, String mess) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(true);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)activity.getString(R.string.err_title_dialog));
        builder1.setMessage((CharSequence)mess);
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showErrorDialog(Activity activity, String mess, final DlgCloseListener listener) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(true);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)activity.getString(R.string.err_title_dialog));
        builder1.setMessage((CharSequence)mess);
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
                if (listener != null) {
                    listener.onClose();
                }
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showErrorInputDialog(Activity activity, String mess, final DlgCloseListener listener, final DlgCloseListener onDismiss) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(true);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)activity.getString(R.string.err_title_dialog));
        builder1.setMessage((CharSequence)mess);
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.lbl_play_now), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
                if (listener != null) {
                    listener.onClose();
                }
            }
        });
        builder1.setNegativeButton((CharSequence)activity.getString(R.string.close), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
                if (onDismiss != null) {
                    onDismiss.onClose();
                }
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showPaymentRetryDialog(Activity activity, String mess, final Listener listener) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(false);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)activity.getString(R.string.err_title_dialog));
        builder1.setMessage((CharSequence)mess);
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.lbl_retry), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
                if (listener != null) {
                    listener.onRetry();
                }
            }
        });
        builder1.setNeutralButton((CharSequence)activity.getString(R.string.cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void showForceLogoutDialog(Activity activity, final DlgCloseListener listener) {
        AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)activity);
        builder1.setCancelable(false);
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
        builder1.setTitle((CharSequence)activity.getString(R.string.warning));
        builder1.setMessage((CharSequence)activity.getResources().getString(R.string.txt_content_force_logout));
        builder1.setPositiveButton((CharSequence)activity.getString(R.string.ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                cf.dismiss();
                if (listener != null) {
                    listener.onClose();
                }
            }
        });
        cf = builder1.create();
        cf.show();
    }

    public static void closeDialog() {
        if (cf != null && cf.isShowing()) {
            cf.dismiss();
        }
    }

    public static interface DlgCloseListener {
        public void onClose();
    }

    public static interface DlgListener {
        public void onOK();
    }

    public static interface Listener {
        public void onRetry();
    }
}

