package com.game.sdk.ui.payment;


import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.MyCallback;
import com.game.sdk.comon.api.request.PaymentRequest;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.err.GetListPurchaseErrObj;
import com.game.sdk.comon.object.err.InitialPurchaseErrObj;
import com.game.sdk.comon.object.err.RetryPaymentErrObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.InitalizePuchaseRequestObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.InitialPurchaseResponseObj;
import com.game.sdk.comon.object.response.ItemPayResponseObj;
import com.game.sdk.comon.object.response.RetryPaymentResponseObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.InteractorCallback;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.Utils;

import retrofit2.Call;
import retrofit2.Response;

public class PaymentInteractorImpl implements IPaymentInteractor {
    private static final String TAG = PaymentInteractorImpl.class.getName();

    private InteractorCallback mCallback;

    Call<VerifyPurchaseResponseObj> mVerifyPurchaseResponseObj;
    Call<RetryPaymentResponseObj> mRetryPaymentResponseObj;
    Call<ItemPayResponseObj> itemPayResponseObjCall;
    Call<InitialPurchaseResponseObj> initialPurchaseResponseObjCall;

    public PaymentInteractorImpl(InteractorCallback mCallback) {
        this.mCallback = mCallback;
    }


    @Override
    public void verifyPurchase(VerifyPurchaseRequestObj obj) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        mVerifyPurchaseResponseObj = request.verifyPurchase(obj.getOrder_no(), obj);

        LogUtils.d("RECEIPT", obj.getReceipt().toString());
        mVerifyPurchaseResponseObj.enqueue(callbackVerifyPurchase);
    }

    @Override
    public void retryPurchase(String appKey, String userId, String characterId, String areaId, String packageName, String purchaseToken, String productId) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        String appVer = Utils.getGameVersion(GameSdk.getInstance().getApplication());
        mRetryPaymentResponseObj = request.retryPayment(appKey, appVer, userId, characterId, areaId, packageName, purchaseToken, productId);
        mRetryPaymentResponseObj.enqueue(callbackRetryPayment);
    }

    @Override
    public void getItemList() {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        String method = "2"; //GG PLAY
        String appVer = Utils.getGameVersion(GameSdk.getInstance().getApplication());
        String app_key = PrefManager.getAppKey(GameSdk.getInstance().getApplication());
        String sdkVersion = Utils.stringNormalize(Utils.getSDKVersion(GameSdk.getInstance().getApplication()));
        itemPayResponseObjCall = request.getListItem(method, app_key, appVer, sdkVersion);
        itemPayResponseObjCall.enqueue(new MyCallback<ItemPayResponseObj>() {
            @Override
            public void onSuccess(Call<ItemPayResponseObj> call, Response<ItemPayResponseObj> response) {
                if (response.isSuccessful()) {
                    mCallback.success(response.body());
                }
            }

            @Override
            public void onError(Call<ItemPayResponseObj> call, Object object) {
                BaseObj obj = (BaseObj) object;
                GetListPurchaseErrObj err = new GetListPurchaseErrObj();
                err.setMessage(obj.getMessage());
                err.setStatus(obj.getStatus());
                mCallback.error(err);
            }
        });
    }

    @Override
    public void initialPurchase(InitalizePuchaseRequestObj initalizePuchaseRequestObj) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        initialPurchaseResponseObjCall = request.initialPurchase(initalizePuchaseRequestObj);
        initialPurchaseResponseObjCall.enqueue(new MyCallback<InitialPurchaseResponseObj>() {
            @Override
            public void onSuccess(Call<InitialPurchaseResponseObj> call, Response<InitialPurchaseResponseObj> response) {
                if (response.isSuccessful()) {
                    mCallback.success(response.body());
                }
            }

            @Override
            public void onError(Call<InitialPurchaseResponseObj> call, Object object) {
                BaseObj obj = (BaseObj) object;
                InitialPurchaseErrObj err = new InitialPurchaseErrObj();
                err.setMessage(obj.getMessage());
                err.setStatus(obj.getStatus());
                mCallback.error(err);
            }
        });
    }


    @Override
    public void cancelRequest(String... tags) {
        if (mVerifyPurchaseResponseObj != null)
            mVerifyPurchaseResponseObj.cancel();
        if (mRetryPaymentResponseObj != null)
            mRetryPaymentResponseObj.cancel();
    }

    private MyCallback<VerifyPurchaseResponseObj> callbackVerifyPurchase = new MyCallback<VerifyPurchaseResponseObj>() {
        @Override
        public void onSuccess(Call<VerifyPurchaseResponseObj> call, Response<VerifyPurchaseResponseObj> response) {
            if (response.isSuccessful()) {
                mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<VerifyPurchaseResponseObj> call, Object object) {
            BaseObj obj = (BaseObj) object;
            VerifyPurchaseErrObj err = new VerifyPurchaseErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            mCallback.error(err);
        }
    };

    private MyCallback<RetryPaymentResponseObj> callbackRetryPayment = new MyCallback<RetryPaymentResponseObj>() {
        @Override
        public void onSuccess(Call<RetryPaymentResponseObj> call, Response<RetryPaymentResponseObj> response) {
            if (response.isSuccessful()) {
                mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<RetryPaymentResponseObj> call, Object object) {
            BaseObj obj = (BaseObj) object;
            RetryPaymentErrObj err = new RetryPaymentErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            mCallback.error(err);
        }
    };
}
