package com.game.sdk.comon.forcelogout;

import android.app.Activity;
import android.content.Intent;
import android.util.Log;

import androidx.annotation.NonNull;

import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.constants.Constants;
import com.game.sdk.ui.other.ForceLogoutActivity;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;

/*
 *   Create by Chuyennt
 * */

public class ForceLogout {

    private static String TAG = ForceLogout.class.getSimpleName();

    private Activity mActivity;

    private FirebaseDatabase mFirebaseDatabase;

    private DatabaseReference mDatabaseReference;

    private static ForceLogout instance;

    private ForceLogoutActivity mForceLogoutActivity;


    public static ForceLogout getInstance() {
        if (instance == null)
            instance = new ForceLogout();
        return instance;
    }

    public void init(Activity activity) {
        if (activity != null)
            this.mActivity = activity;
        mFirebaseDatabase = FirebaseDatabase.getInstance();
    }


    public void initFRB() {
        if (GameConfigs.getInstance().isLogin() && mActivity != null) {
            mDatabaseReference = mFirebaseDatabase.getReference(Constants.TABLE_NAME);
            mDatabaseReference.child(GameConfigs.getInstance().getAppKey()).addValueEventListener(new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot snapshot) {
                    GameObj gameObj = snapshot.getValue(GameObj.class);
                    if (gameObj != null) {
                        Log.d(TAG, "isForce: " + gameObj.getIsForce());
                        forceOut(gameObj);
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {
                    try {
                        Log.d(TAG, "error code" + error.getCode());
                        Log.d(TAG, "error message" + error.getMessage());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void disconnectFRB() {
        if (mDatabaseReference != null && mFirebaseDatabase != null) {
            mDatabaseReference.onDisconnect();
            mFirebaseDatabase.goOffline();
        }
    }

    void forceOut(GameObj gameObj) {
        if (gameObj.getIsForce()) {
            if (mForceLogoutActivity == null)
                mForceLogoutActivity = new ForceLogoutActivity();
            mActivity.startActivity(new Intent(mActivity, mForceLogoutActivity.getClass()));
        } else {
            mActivity.sendBroadcast(new Intent(Constants.FORCE_RECIEVER));
        }
    }


    public void exitGame() {
        try {
            disconnectFRB();
            mActivity.finish();
            System.gc();
            System.exit(0);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
