/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.ui.ads;

import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.MyCallback;
import com.game.sdk.comon.api.request.AdsRequest;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.err.SaveAiiErrObj;
import com.game.sdk.comon.object.response.SaveAIIResponseObj;
import com.game.sdk.comon.presenter.InteractorCallback;
import com.game.sdk.ui.ads.IAdsInteractor;
import retrofit2.Call;
import retrofit2.Response;

public class AdsInteractorImpl
implements IAdsInteractor {
    private static final String TAG = AdsInteractorImpl.class.getName();
    private InteractorCallback mCallback;
    Call<SaveAIIResponseObj> mSaveAiiRequest;
    private MyCallback<SaveAIIResponseObj> callback = new MyCallback<SaveAIIResponseObj>(){

        @Override
        public void onSuccess(Call<SaveAIIResponseObj> call, Response<SaveAIIResponseObj> response) {
            if (response.isSuccessful()) {
                AdsInteractorImpl.this.mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<SaveAIIResponseObj> call, Object object) {
            BaseObj obj = (BaseObj)object;
            SaveAiiErrObj err = new SaveAiiErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            AdsInteractorImpl.this.mCallback.error(err);
        }
    };

    public AdsInteractorImpl(InteractorCallback mCallback) {
        this.mCallback = mCallback;
    }

    @Override
    public void saveAii(String appInstantId) {
        AdsRequest request = ApiUtils.getAdsRequest();
        this.mSaveAiiRequest = request.saveAii(appInstantId);
        this.mSaveAiiRequest.enqueue(this.callback);
    }

    @Override
    public void cancelRequest(String ... tags) {
        if (this.mSaveAiiRequest != null) {
            this.mSaveAiiRequest.cancel();
        }
    }
}

