package com.game.sdk.ui.payment;

import com.game.sdk.comon.object.request.InitalizePuchaseRequestObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.presenter.InteractorCallback;

public class PaymentPresenterImpl implements IPaymentPresenter {

    private final IPaymentInteractor mInteractor;
    private final BaseView mBaseView;

    public PaymentPresenterImpl(BaseView mBaseView) {
        this.mBaseView = mBaseView;
        InteractorCallback<Object> mCallback = new InteractorCallback<Object>() {
            @Override
            public void success(Object x) {
                if (mBaseView != null) {
                    mBaseView.hideProgress();
                    mBaseView.success(x);
                }
            }

            @Override
            public void error(Object o) {
                if (mBaseView != null) {
                    mBaseView.hideProgress();
                    mBaseView.error(o);
                }
            }
        };
        mInteractor = new PaymentInteractorImpl(mCallback);
    }

    @Override
    public void cancelRequest(String... tags) {
        mInteractor.cancelRequest();
    }


    @Override
    public void verifyPurchase(VerifyPurchaseRequestObj obj) {
        mInteractor.cancelRequest();
        mInteractor.verifyPurchase(obj);
        if (mBaseView != null) {
            mBaseView.showProgress("");
        }
    }

    @Override
    public void retryPurchase(String appKey, String userId, String characterId, String areaId, String packageName, String purchaseToken, String productId) {
        mInteractor.cancelRequest();
        mInteractor.retryPurchase(appKey, userId, characterId, areaId, packageName, purchaseToken, productId);
    }

    @Override
    public void getItemList() {
        mInteractor.cancelRequest();
        mInteractor.getItemList();
        if (mBaseView != null) {
            mBaseView.showProgress("");
        }
    }

    @Override
    public void initialPurchase(InitalizePuchaseRequestObj initalizePuchaseRequestObj) {
        mInteractor.cancelRequest();
        mInteractor.initialPurchase(initalizePuchaseRequestObj);
        if (mBaseView != null) {
            mBaseView.showProgress("");
        }
    }


}
