/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.tracking;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.game.sdk.comon.object.err.SaveAiiErrObj;
import com.game.sdk.comon.object.response.SaveAIIResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.ui.ads.AdsPresenterImpl;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Firebase {
    public static final String TAG = Firebase.class.getSimpleName();
    private Context context;
    private FirebaseAnalytics mFirebaseAnalytics;
    private static Firebase firebase;

    public static Firebase newInstance(Application context) {
        if (firebase == null) {
            firebase = new Firebase(context);
        }
        return firebase;
    }

    public static Firebase getInstant() {
        return firebase;
    }

    private Firebase(Application context) {
        this.context = context;
        if (this.mFirebaseAnalytics == null) {
            this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)context);
        }
    }

    public void firebaseEventTrack(String labelEvent, HashMap<String, Object> params) {
        Bundle bundle = new Bundle();
        if (params != null) {
            Set<Map.Entry<String, Object>> mapSet = params.entrySet();
            for (Map.Entry<String, Object> mapEntry : mapSet) {
                String key = mapEntry.getKey() + "";
                String value = mapEntry.getValue() + "";
                LogUtils.d(TAG, "key : " + key + " , value:" + value);
                bundle.putString(key, value);
            }
            this.mFirebaseAnalytics.logEvent(labelEvent, bundle);
        } else {
            this.mFirebaseAnalytics.logEvent(labelEvent, null);
        }
    }

    public void saveAppInstantId(final Context context) {
        if (!PrefManager.getBoolean(context, "SAVE_APP_INSTANT_ID", false)) {
            this.mFirebaseAnalytics.getAppInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<String>(){

                public void onSuccess(String s) {
                    LogUtils.d(TAG, "-- " + s);
                    AdsPresenterImpl adsPresenter = new AdsPresenterImpl(new BaseView(){

                        @Override
                        public void showProgress(String message) {
                        }

                        @Override
                        public void hideProgress() {
                        }

                        public void success(Object x) {
                            if (x instanceof SaveAIIResponseObj) {
                                SaveAIIResponseObj responseObj = (SaveAIIResponseObj)x;
                                LogUtils.d(TAG, "Message : " + responseObj.getMessage());
                                PrefManager.saveBoolean(context, "SAVE_APP_INSTANT_ID", true);
                            }
                        }

                        public void error(Object o) {
                            if (o instanceof SaveAiiErrObj) {
                                try {
                                    SaveAiiErrObj err = (SaveAiiErrObj)o;
                                    LogUtils.d(TAG, "" + err.getMessage());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                    if (s != null && !TextUtils.isEmpty((CharSequence)s)) {
                        adsPresenter.saveAii(s);
                    }
                }
            });
        }
    }
}

