package com.game.sdk.comon.tracking;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;

import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.object.err.SaveAiiErrObj;
import com.game.sdk.comon.object.response.SaveAIIResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.ui.ads.AdsPresenterImpl;
import com.game.sdk.ui.ads.IAdsPresenter;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.iid.FirebaseInstanceId;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Firebase {
    public static final String TAG = Firebase.class.getSimpleName();
    private Context context;
    private FirebaseAnalytics mFirebaseAnalytics;
    private static Firebase firebase;

    public static Firebase newInstance(Application context) {
        if (firebase == null)
            firebase = new Firebase(context);
        return firebase;
    }

    public static Firebase getInstant() {
        return firebase;
    }

    private Firebase(Application context) {
        this.context = context;
        if (mFirebaseAnalytics == null) {
            mFirebaseAnalytics = FirebaseAnalytics.getInstance(context);
            //getAppInstantId();
        }
    }

    public void firebaseEventTrack(String labelEvent, HashMap<String, Object> params) {
        Bundle bundle = new Bundle();

        if (params != null) {
            Set mapSet = (Set) params.entrySet();
            Iterator mapIterator = mapSet.iterator();
            while (mapIterator.hasNext()) {
                Map.Entry mapEntry = (Map.Entry) mapIterator.next();
                String key = (String) (mapEntry.getKey() + "");
                String value = (String) (mapEntry.getValue() + "");
                LogUtils.d(TAG, "key : " + key + " , value:" + value);
                bundle.putString(key, value);
            }

            mFirebaseAnalytics.logEvent(labelEvent, bundle);
        } else {
            mFirebaseAnalytics.logEvent(labelEvent, null);
        }

    }

    public void saveAppInstantId(Context context) {
        if (!PrefManager.getBoolean(context, Constants.SAVE_AII, false))
            mFirebaseAnalytics.getAppInstanceId().addOnSuccessListener(new OnSuccessListener<String>() {
                @Override
                public void onSuccess(String s) {
                    LogUtils.d(TAG, "-- " + s);
                    IAdsPresenter adsPresenter = new AdsPresenterImpl(new BaseView() {
                        @Override
                        public void showProgress(String message) {

                        }

                        @Override
                        public void hideProgress() {

                        }

                        @Override
                        public void success(Object x) {
                            if (x instanceof SaveAIIResponseObj) {
                                SaveAIIResponseObj responseObj = (SaveAIIResponseObj) x;
                                LogUtils.d(TAG, "Message : " + responseObj.getMessage());
                                PrefManager.saveBoolean(context, Constants.SAVE_AII, true);
                            }
                        }

                        @Override
                        public void error(Object o) {
                            if (o instanceof SaveAiiErrObj) {
                                try {
                                    SaveAiiErrObj err = (SaveAiiErrObj) o;
                                    LogUtils.d(TAG, "" + err.getMessage());
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                        }
                    });
                    if (s != null && !TextUtils.isEmpty(s))
                        adsPresenter.saveAii(s);
                }
            });
    }

}
