package com.game.sdk.comon.game;

import android.app.Activity;
import android.app.Application;
import android.app.DialogFragment;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.graphics.Bitmap;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;

import com.appsflyer.AppsFlyerLib;
import com.game.ads.AdsPlayFun;
import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.RetrofitClient;
import com.game.sdk.comon.cmd.CmdPaymentV3;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.listener.ILoginListener;
import com.game.sdk.comon.listener.ILogoutListener;
import com.game.sdk.comon.listener.IMesssageListener;
import com.game.sdk.comon.listener.IPaymentListener;
import com.game.sdk.comon.listener.ISaveCharactorListener;
import com.game.sdk.comon.login.FacebookManager;
import com.game.sdk.comon.login.GoogleManager;
import com.game.sdk.comon.object.AuthenConfigObj;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.MessInGameObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.object.response.AuthenConfigResponseObj;
import com.game.sdk.comon.object.response.MessInGameResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.Firebase;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.ToastUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.login.AccountFragment;
import com.game.sdk.ui.login.ILoginPresenter;
import com.game.sdk.ui.login.LoginPresenterImpl;
import com.game.sdk.ui.notification.MobFirebaseMessagingService;
import com.game.sdk.ui.other.GamePresenterImpl;
import com.game.sdk.ui.other.IGamePresenter;
import com.game.sdk.ui.payment.PaymentFragment;
import com.game.sdk.ui.payment.PaymentNativeFragment;
import com.game.sdk.ui.payment.PaymentUtil;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Timer;

import playfun.ads.android.sdk.component.UserInfo;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.util.Preference;

import static com.facebook.login.widget.ProfilePictureView.TAG;
import static com.game.sdk.comon.constants.Constants.AREA_ID;
import static com.game.sdk.comon.constants.Constants.ROLE_ID;
import static com.game.sdk.comon.constants.Constants.SAVE_FCM_NON_TOKEN;

public class GameSdk implements IMobSdk {
    private static Application sApp;
    private static GameSdk gameSdk;
    private static MobGameSDK mobGameSDK;
    Handler mHandler;
    Runnable mRunable;
    private String mKeyAds;
    private RequestAdsFun requestAdsFun;
    private Timer timerAsync;
    private String mUserID;
    private AdsPlayFun adsPlayFun;


    public Application getApplication() {
        return sApp;
    }

    public static GameSdk getInstance() {
        if (gameSdk == null) {
            gameSdk = new GameSdk();
            mobGameSDK = MobGameSDK.getInstance();
        }
        return gameSdk;
    }

    public void initSdk(Activity activity, String adsKey) {
        mobGameSDK.init(activity);
        try {
            PackageInfo pInfo = getApplication().getPackageManager().getPackageInfo(getApplication().getPackageName(), 0);
            DeviceUtils.initAdvertising(activity, new DeviceUtils.Listener() {
                @Override
                public void onGetAds() {
                }
            });

            /**
             * init ads
             */
            Log.d(TAG, "Go here 1");
            String appVersionName = Utils.getGameVersion(GameSdk.getInstance().getApplication());
            String appVersionCode = Utils.getGameVersionCode(GameSdk.getInstance().getApplication());
            String advertising_id = DeviceUtils.getAdvertisingID(GameSdk.getInstance().getApplication());
            adsPlayFun = new AdsPlayFun(adsKey, activity, Objects.requireNonNull(pInfo).toString(), appVersionName, appVersionCode, advertising_id);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void init(@NonNull Application application, String appkey, String facebookId) {
        sApp = application;

        //New SDK init
        TrackingUtil.getInstance().init(sApp);
        TrackingUtil.getInstance().trackAppLaunch();
        TrackingUtil.getInstance().trackLastSession(sApp);

        //init GameConfig
        GameConfigs.getInstance().setAppKey(appkey);
        GameConfigs.getInstance().initFacebook(facebookId);
        mHandler = new Handler();

        timerAsync = new Timer();
    }

    public void loginNative(Activity activity, ILoginListener listener) {
        //check authen config , if not exit , will not show login dialog
        if (GameConfigs.getInstance().isLogin()) {
            String mess = sApp.getResources().getString(R.string.lbl_already_login);
            ToastUtils.showErrToast(activity, mess);
            return;
        }
        ILoginPresenter pr = new LoginPresenterImpl(new BaseView() {
            @Override
            public void showProgress(String message) {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        Utils.showLoading(activity, true);
                    }
                });

            }

            @Override
            public void hideProgress() {
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        Utils.showLoading(activity, false);
                    }
                });

            }

            @Override
            public void success(Object x) {
                if (x instanceof AuthenConfigResponseObj) {
                    AuthenConfigObj obj = ((AuthenConfigResponseObj) x).getData();
                    AuthenConfigs.getInstance().setAuthenConfigObj(obj);
                }
                showLoginForm(activity, new ILoginListener() {
                    @Override
                    public void onLoginSuccess() {
                        AppsFlyerLib.getInstance().setCustomerUserId(GameConfigs.getInstance().getUser().getId() + "");
                        saveFCM(activity);
                        if (listener != null)
                            listener.onLoginSuccess();

                        Log.d(TAG, "userId : " + GameConfigs.getInstance().getUser().getId());
                        UserInfo.getInstance().setUserId(String.valueOf(GameConfigs.getInstance().getUser().getId()), activity);

                    }

                    @Override
                    public void onRegisterSuccess(String param) {

                    }
                });
            }

            @Override
            public void error(Object o) {
                showLoginForm(activity, listener);
            }
        });
        pr.getAuthenConfig();
    }

    public void showLoginForm(Activity activity, ILoginListener listener) {
        if (mHandler != null && mRunable != null) {
            mHandler.removeCallbacks(mRunable);
        }
        mRunable = new Runnable() {
            @Override
            public void run() {
                try {
                    DialogFragment newFragment = (DialogFragment) activity.getFragmentManager().findFragmentByTag(AccountFragment.class.getSimpleName());
                    if (newFragment == null)
                        newFragment = AccountFragment.newInstance(listener);
                    newFragment.setCancelable(false);
                    if (newFragment.getDialog() != null && newFragment.getDialog().isShowing())
                        return;
                    newFragment.show(activity.getFragmentManager(), AccountFragment.class.getSimpleName());
                } catch (IllegalStateException ex) {
                    DialogFragment newFragment = AccountFragment.newInstance(listener);
                    newFragment.setCancelable(false);
                    newFragment.show(activity.getFragmentManager(), AccountFragment.class.getSimpleName() + System.currentTimeMillis());
                }
            }
        };
        mHandler.postDelayed(mRunable, 200);

    }

    public void logOut(Activity activity) {
        mobGameSDK.logout();
        if (GameConfigs.getInstance().getUser() != null || GameConfigs.getInstance().isLogin()) {
            if (GameConfigs.getInstance().getUser() != null)
                TrackingUtil.getInstance().trackLogoutSuccess(GameConfigs.getInstance().getUser().getId());
            RetrofitClient.clearInstant();
            GameConfigs.clearInstance();
            GoogleManager.getInstance(sApp).logout();
            FacebookManager.getInstance(sApp).logout();
            PrefManager.saveBoolean(sApp, SAVE_FCM_NON_TOKEN + AuthenConfigs.getInstance().getAccessToken(), false);
            PrefManager.saveBoolean(sApp, Constants.SAVE_AII, false);
            PrefManager.saveSetting(sApp, ROLE_ID, "");
            PrefManager.saveSetting(sApp, AREA_ID, "");
            PrefManager.saveAccessToken(sApp, "");
            AppsFlyerLib.getInstance().setCustomerUserId("");
            MobGameHelper.hideNotiFloatButton();
            MobGameSDK.getInstance().logout();
            String mess = sApp.getResources().getString(R.string.lbl_log_out_success);
            ToastUtils.showHello(activity, 3000, mess);
        } else {
            String mess = sApp.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showErrToast(activity, mess);
        }
    }

    public void logOut(Activity activity, ILogoutListener logoutListener) {
        logOut(activity);
        if (logoutListener != null)
            logoutListener.onLogoutSuccess();
    }

    public void onLoginSuccess(Activity activity, String tab) {
        if (GameConfigs.getInstance().getUser() != null && GameConfigs.getInstance().getUser().getName() != null) {
            String name = GameConfigs.getInstance().getUser().getName();
            name = TextUtils.isEmpty(name) ? "" : (", " + name);
            String mess = sApp.getResources().getString(R.string.hello) + name;
            ToastUtils.showHello(activity, 3000, mess);
            Firebase.getInstant().saveAppInstantId(activity);
        }
        if (GameConfigs.getInstance().getSdkConfig() != null) {
            MobGameHelper.showNotiFloatButton(GameConfigs.getInstance().getSdkConfig().getEx());
        }
    }

    public void getMessInGame(Activity activity, IMesssageListener messsageListener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = sApp.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showErrToast(activity, mess);
            return;
        }
        IGamePresenter gamePresenter = new GamePresenterImpl(new BaseView() {
            @Override
            public void showProgress(String mess) {
                Utils.showLoading(activity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(activity, false);
            }

            @Override
            public void success(Object x) {
                if (x instanceof MessInGameResponseObj && messsageListener != null) {
                    ArrayList<MessInGameObj> obj = ((MessInGameResponseObj) x).getData();
                    if (obj != null && obj.size() > 0)
                        messsageListener.onSuccess(obj);
                }

            }

            @Override
            public void error(Object o) {
                BaseObj baseObj = (BaseObj) o;
                ToastUtils.showErrToast(activity, baseObj.getMessage());
            }
        });
        gamePresenter.getMessInGame();
    }


    @Override
    public void saveCharactor(Activity activity, String roleId, String areaId, ISaveCharactorListener listener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = sApp.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showErrToast(activity, mess);
            return;
        }
        PrefManager.saveSetting(activity, Constants.ROLE_ID, roleId);
        PrefManager.saveSetting(activity, Constants.AREA_ID, areaId);
        LogUtils.d(TAG, "setUserConfig :" + "roleId: " + roleId + "areaId: " + areaId);
        Log.d("SaveCharactor ", "roleID: " + roleId + " \t " + "areaID: " + areaId);

        if (!ToastUtils.isShowHello(activity)) {
            AdsPlayFun.getInstance().showAds(activity, "save_character", "", DeviceUtils.getAdvertisingID(activity) == null ? "" : DeviceUtils.getAdvertisingID(activity), "");
        }
        //TODO will start period ads .
        String jsonGetListInventory = Preference.getString(activity, "LIST_INVENTORY");
        if (jsonGetListInventory != null) {
            if (!ToastUtils.isShowHello(activity)) {
                AdsPlayFun.getInstance().showAds(activity, "period",
                        "", DeviceUtils.getAdvertisingID(activity) == null ? "" : DeviceUtils.getAdvertisingID(activity), "");
            }
        }

        IGamePresenter gamePresenter = new GamePresenterImpl(new BaseView() {
            @Override
            public void showProgress(String mess) {
                Utils.showLoading(activity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(activity, false);
            }

            @Override
            public void success(Object x) {
                if (x instanceof BaseObj && listener != null) {
                    TrackingUtil.getInstance().trackCharactorCreatedSuccess(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
                    SdkConfigObj.Pop pop = GameConfigs.getInstance().getMobPopup();
                    if (pop != null && !TextUtils.isEmpty(pop.getUrl())) {
                        MobGameSDK.getInstance().getQueuePopups().add(MobGameSDK.POPUP_LINK);
                        MobGameSDK.getInstance().showPopup();
                    }
                    listener.onSuccess();
                    Log.d("SaveCharactor_Success ", "roleID: " + roleId + " \t " + "areaID: " + areaId);
                }
            }

            @Override
            public void error(Object o) {
                BaseObj baseObj = (BaseObj) o;
                ToastUtils.showErrToast(activity, baseObj.getMessage());
                TrackingUtil.getInstance().trackCharactorCreatedFailed(GameConfigs.getInstance().getUser().getId(), roleId, areaId);
            }
        });
        TrackingUtil.getInstance().trackCharactorCreated(activity, GameConfigs.getInstance().getUser().getId(), roleId, areaId);
        try {
            gamePresenter.saveCharactor(roleId, areaId);
        } catch (Exception e) {
            LogUtils.d(TAG, e.getMessage());
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (mobGameSDK != null)
            mobGameSDK.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onDestroy() {
        if (mobGameSDK != null) {
            timerAsync.cancel();
            mobGameSDK.onDestroySDK();
        }
        AdsPlayFun.getInstance().onDestroy();
    }

    @Override
    public void shareImageFacebook(Activity activity, Bitmap image) {
        if (mobGameSDK != null)
            mobGameSDK.shareImageFacebook(activity, image);
    }

    @Override
    public void dashboardNew() {
        if (mobGameSDK != null)
            mobGameSDK.dashboardNew();
    }

    @Override
    public void showTextScroll(ArrayList<MessInGameObj> listNoti) {
        if (mobGameSDK != null)
            mobGameSDK.showTextScroll(listNoti);
    }

    @Override
    public void onRequestPermissionsResult(Activity gameActivity, int requestCode, String[] permissions, int[] grantResults) {
        if (mobGameSDK != null)
            mobGameSDK.onRequestPermissionsResult(gameActivity, requestCode, permissions, grantResults);
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        if (mobGameSDK != null)
            mobGameSDK.onWindowFocusChanged(hasFocus);
    }

    @Override
    public void onBackPressed() {
        mobGameSDK.onBackPressed();
    }


    DialogFragment paymentFragment;

    @Override
    public void payment(Activity activity, String state, IPaymentListener listener) {

        if (mHandler != null && mRunable != null) {
            mHandler.removeCallbacks(mRunable);
        }
        mRunable = new Runnable() {
            @Override
            public void run() {
                try {
                    Log.i(TAG, "payment:" + state);

                    if (!GameConfigs.getInstance().isLogin()) {
                        String mess = activity.getResources().getString(R.string.lbl_not_login);
                        ToastUtils.showErrToast(activity, mess);
                    } else {
                        String role_id = PrefManager.getString(activity, Constants.ROLE_ID, "");
                        String area_id = PrefManager.getString(activity, Constants.AREA_ID, "");
                        if (TextUtils.isEmpty(role_id) || TextUtils.isEmpty(area_id)) {
                            ToastUtils.showErrToast(activity, activity.getString(R.string.err_empty_charactor));
                            return;
                        }
                        paymentFragment = (DialogFragment) activity.getFragmentManager().findFragmentByTag(PaymentFragment.class.getSimpleName());

                        if (paymentFragment == null)
                            paymentFragment = PaymentFragment.newInstance(ApiUtils.getUrlWvPayment(activity, state), new PaymentFragment.PaymentGGSuccess() {
                                @Override
                                public void onPaymentGGSuccess(PurchaseHistoryObj obj) {
                                    CmdPaymentV3.getInstance().verifyPayment(activity, obj, listener);
                                }
                            });
                        if (paymentFragment.getDialog() != null && paymentFragment.getDialog().isShowing())
                            return;
                        paymentFragment.show(activity.getFragmentManager(), PaymentFragment.class.getSimpleName());

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        mHandler.postDelayed(mRunable, 200);


    }

    @Override
    public void paymentNative(Activity activity, String productId, String itemNo, String state, IPaymentListener listener) {
        if (!GameConfigs.getInstance().isLogin()) {
            String mess = activity.getResources().getString(R.string.lbl_not_login);
            ToastUtils.showErrToast(activity, mess);
        }else {
            String role_id = PrefManager.getString(activity, Constants.ROLE_ID, "");
            String area_id = PrefManager.getString(activity, Constants.AREA_ID, "");
            if (TextUtils.isEmpty(role_id) || TextUtils.isEmpty(area_id)) {
                ToastUtils.showErrToast(activity, activity.getString(R.string.err_empty_charactor));
                return;
            }
            if (TextUtils.isEmpty(productId) || TextUtils.isEmpty(itemNo)) {
                ToastUtils.showWarmToast(activity, activity.getString(R.string.check_purchase_information));
                return;
            }
            PaymentUtil.getInstance().initialPayment(activity, productId, itemNo, state, new PaymentUtil.PaymentResponse() {
                @Override
                public void onPaymentSuccess(String productId, PurchaseHistoryObj obj) {
                    CmdPaymentV3.getInstance().verifyPaymentNative(activity, productId, obj, listener);
                }
            });
        }

    }

    public void saveFCM(Activity activity) {
        if (GameConfigs.getInstance().isLogin() && !PrefManager.getBoolean(sApp, SAVE_FCM_NON_TOKEN + AuthenConfigs.getInstance().getAccessToken(), false)) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener(new OnSuccessListener<InstanceIdResult>() {
                @Override
                public void onSuccess(InstanceIdResult instanceIdResult) {
                    String firebaseToken = instanceIdResult.getToken();
                    LogUtils.d(TAG, "Firebase Token/regId: " + firebaseToken);

                    if (GameConfigs.getInstance().getAppKey() != null && GameConfigs.getInstance().getUser() != null) {
                        int userId = GameConfigs.getInstance().getUser().getId();
                        MobFirebaseMessagingService.getInstance().sendRegistrationToServer(activity, String.valueOf(userId), firebaseToken);
                    }
                }
            });
        } else if (!PrefManager.getBoolean(sApp, SAVE_FCM_NON_TOKEN, false)) {
            FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener(new OnSuccessListener<InstanceIdResult>() {
                @Override
                public void onSuccess(InstanceIdResult instanceIdResult) {
                    String firebaseToken = instanceIdResult.getToken();
                    LogUtils.d(TAG, "Firebase Token/regId: " + firebaseToken);
                    if (GameConfigs.getInstance().getAppKey() != null) {
                        MobFirebaseMessagingService.getInstance().sendRegistrationToServer(activity, "", firebaseToken);
                    }
                }
            });

        }
    }


}
