package com.game.sdk.ui.ads;

import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.presenter.InteractorCallback;
import com.game.sdk.ui.payment.IPaymentInteractor;
import com.game.sdk.ui.payment.PaymentInteractorImpl;

public class AdsPresenterImpl implements IAdsPresenter {

    private IAdsInteractor mInteractor;
    private BaseView mBaseView;

    public AdsPresenterImpl(BaseView mBaseView) {
        this.mBaseView = mBaseView;
        mInteractor = new AdsInteractorImpl(mCallback);
    }

    private final InteractorCallback<Object> mCallback = new InteractorCallback<Object>() {
        @Override
        public void success(Object x) {
            if (mBaseView != null) {
                mBaseView.hideProgress();
                mBaseView.success(x);
            }
        }

        @Override
        public void error(Object o) {
            if (mBaseView != null) {
                mBaseView.hideProgress();
                mBaseView.error(o);
            }
        }
    };

    @Override
    public void cancelRequest(String... tags) {
        mInteractor.cancelRequest();
    }

    @Override
    public void saveAii(String appInstantId) {
        mInteractor.cancelRequest();
        mInteractor.saveAii(appInstantId);
    }
}
