/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import com.facebook.AccessToken;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.StringUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FacebookAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.GoogleAuthProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Firebase {
    public static final String TAG = Firebase.class.getSimpleName();
    private static Firebase firebase;
    private Context context;
    private FirebaseAnalytics mFirebaseAnalytics;
    private FirebaseAuth mAuth;

    public static Firebase newInstance(Application context) {
        return new Firebase((Context)context);
    }

    public static Firebase getInstance(Context context) {
        if (firebase == null) {
            firebase = new Firebase(context);
        }
        return firebase;
    }

    private Firebase(Context context) {
        this.context = context;
        if (this.mFirebaseAnalytics == null) {
            this.mFirebaseAnalytics = FirebaseAnalytics.getInstance((Context)context);
        }
        this.mAuth = FirebaseAuth.getInstance();
    }

    public void firebaseEventTrack(String labelEvent, HashMap<String, Object> params) {
        Bundle bundle = new Bundle();
        if (params != null) {
            Set<Map.Entry<String, Object>> mapSet = params.entrySet();
            for (Map.Entry<String, Object> mapEntry : mapSet) {
                String key = mapEntry.getKey() + "";
                String value = mapEntry.getValue() + "";
                LogUtils.d(TAG, "key : " + key + " , value:" + value);
                bundle.putString(key, value);
            }
            this.mFirebaseAnalytics.logEvent(labelEvent, bundle);
        } else {
            this.mFirebaseAnalytics.logEvent(labelEvent, null);
        }
    }

    public void firebaseAuthWithGoogle(Activity ac, String idToken) {
        try {
            AuthCredential credential = GoogleAuthProvider.getCredential((String)idToken, null);
            this.mAuth.signInWithCredential(credential).addOnCompleteListener(ac, (OnCompleteListener)new OnCompleteListener<AuthResult>(){

                public void onComplete(@NonNull Task<AuthResult> task) {
                    if (task.isSuccessful()) {
                        FirebaseUser user = Firebase.this.mAuth.getCurrentUser();
                        Log.d((String)TAG, (String)("signInWithCredential: UID : " + user.getUid()));
                        user.getIdToken(true).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<GetTokenResult>(){

                            public void onComplete(@NonNull Task<GetTokenResult> task) {
                                if (task.isSuccessful()) {
                                    String idToken = ((GetTokenResult)task.getResult()).getToken();
                                    Log.d((String)TAG, (String)("signInWithCredential:success : " + idToken));
                                } else {
                                    Log.w((String)TAG, (String)"signInWithCredential:failure", (Throwable)task.getException());
                                }
                            }
                        });
                    } else {
                        Log.w((String)TAG, (String)"signInWithCredential:failure", (Throwable)task.getException());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void firebaseAuthWithFacebook(Activity ac, AccessToken token) {
        AuthCredential credential = FacebookAuthProvider.getCredential((String)token.getToken());
        this.mAuth.signInWithCredential(credential).addOnCompleteListener(ac, (OnCompleteListener)new OnCompleteListener<AuthResult>(){

            public void onComplete(@NonNull Task<AuthResult> task) {
                if (task.isSuccessful()) {
                    FirebaseUser user = Firebase.this.mAuth.getCurrentUser();
                    Log.d((String)TAG, (String)("signInWithCredential: UID : " + user.getUid()));
                    user.getIdToken(true).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<GetTokenResult>(){

                        public void onComplete(@NonNull Task<GetTokenResult> task) {
                            if (task.isSuccessful()) {
                                String idToken = ((GetTokenResult)task.getResult()).getToken();
                                Log.d((String)TAG, (String)("signInWithCredential:success : " + idToken));
                            } else {
                                Log.w((String)TAG, (String)"signInWithCredential:failure", (Throwable)task.getException());
                            }
                        }
                    });
                } else {
                    Log.w((String)TAG, (String)"signInWithCredential:failure", (Throwable)task.getException());
                }
            }
        });
    }

    public void signinFirebase(final Activity ac) {
        String token = PrefManager.getString((Context)ac, "FIREBASE_TOKEN", "");
        if (StringUtils.isEmpty(token)) {
            this.firebaseSignInAnonymously(ac);
        } else {
            Log.d((String)TAG, (String)("automatic sign in anonymously: uid: " + this.mAuth.getCurrentUser().getUid()));
            this.mAuth.getCurrentUser().getIdToken(true).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<GetTokenResult>(){

                public void onComplete(@NonNull Task<GetTokenResult> task) {
                    if (task.isSuccessful()) {
                        String idToken = ((GetTokenResult)task.getResult()).getToken();
                        Log.d((String)TAG, (String)("automatic sign in anonymously:success : " + idToken));
                        PrefManager.saveString((Context)ac, "FIREBASE_TOKEN", idToken);
                    } else {
                        Log.w((String)TAG, (String)"automatic sign in anonymously: failure", (Throwable)task.getException());
                    }
                }
            });
        }
    }

    public void firebaseSignInAnonymously(final Activity ac) {
        this.mAuth.signInAnonymously().addOnCompleteListener(ac, (OnCompleteListener)new OnCompleteListener<AuthResult>(){

            public void onComplete(@NonNull Task<AuthResult> task) {
                if (task.isSuccessful()) {
                    FirebaseUser user = Firebase.this.mAuth.getCurrentUser();
                    Log.d((String)TAG, (String)("sign in anonymously: UID : " + user.getUid()));
                    Firebase.this.mAuth.getAccessToken(true).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<GetTokenResult>(){

                        public void onComplete(@NonNull Task<GetTokenResult> task) {
                            if (task.isSuccessful()) {
                                String idToken = ((GetTokenResult)task.getResult()).getToken();
                                Log.d((String)TAG, (String)("get FireBase Authen :success : " + idToken));
                            } else {
                                Log.w((String)TAG, (String)"get FireBase Authen:failure", (Throwable)task.getException());
                            }
                        }
                    });
                    user.getIdToken(true).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<GetTokenResult>(){

                        public void onComplete(@NonNull Task<GetTokenResult> task) {
                            if (task.isSuccessful()) {
                                String idToken = ((GetTokenResult)task.getResult()).getToken();
                                Log.d((String)TAG, (String)("sign in anonymously:success : " + idToken));
                                PrefManager.saveString((Context)ac, "FIREBASE_TOKEN", idToken);
                            } else {
                                Log.w((String)TAG, (String)"sign in anonymously: failure", (Throwable)task.getException());
                            }
                        }
                    });
                } else {
                    Log.w((String)TAG, (String)"signInWithCredential:failure", (Throwable)task.getException());
                }
            }
        });
    }
}

