/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adjust.sdk.Adjust;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEventFailure;
import com.adjust.sdk.AdjustEventSuccess;
import com.adjust.sdk.AdjustSessionFailure;
import com.adjust.sdk.AdjustSessionSuccess;
import com.adjust.sdk.LogLevel;
import com.adjust.sdk.OnAttributionChangedListener;
import com.adjust.sdk.OnDeeplinkResponseListener;
import com.adjust.sdk.OnEventTrackingFailedListener;
import com.adjust.sdk.OnEventTrackingSucceededListener;
import com.adjust.sdk.OnSessionTrackingFailedListener;
import com.adjust.sdk.OnSessionTrackingSucceededListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;

public class AdjustUtil {
    public static String TAG = AdjustUtil.class.getName();

    public static void init(final Application context, String app_token, String environment) {
        AdjustConfig config = new AdjustConfig((Context)context, app_token, environment);
        config.setLogLevel(LogLevel.VERBOSE);
        config.setOnAttributionChangedListener(new OnAttributionChangedListener(){

            public void onAttributionChanged(AdjustAttribution attribution) {
                Log.d((String)"*****trackingAdjust", (String)("Attribution: " + attribution.toString()));
            }
        });
        config.setOnEventTrackingSucceededListener(new OnEventTrackingSucceededListener(){

            public void onFinishedEventTrackingSucceeded(AdjustEventSuccess eventSuccessResponseData) {
                Log.d((String)"*****trackingAdjust", (String)("Event success data: " + eventSuccessResponseData.toString()));
            }
        });
        config.setOnEventTrackingFailedListener(new OnEventTrackingFailedListener(){

            public void onFinishedEventTrackingFailed(AdjustEventFailure eventFailureResponseData) {
                Log.d((String)"*****trackingAdjust", (String)("Event failure data: " + eventFailureResponseData.toString()));
            }
        });
        config.setOnSessionTrackingSucceededListener(new OnSessionTrackingSucceededListener(){

            public void onFinishedSessionTrackingSucceeded(AdjustSessionSuccess sessionSuccessResponseData) {
                Log.d((String)"*****trackingAdjust", (String)("Session success data: " + sessionSuccessResponseData.toString()));
            }
        });
        config.setOnSessionTrackingFailedListener(new OnSessionTrackingFailedListener(){

            public void onFinishedSessionTrackingFailed(AdjustSessionFailure sessionFailureResponseData) {
                Log.d((String)"*****trackingAdjust", (String)("Session failure data: " + sessionFailureResponseData.toString()));
            }
        });
        config.setOnDeeplinkResponseListener(new OnDeeplinkResponseListener(){

            public boolean launchReceivedDeeplink(Uri deeplink) {
                Log.d((String)"*****trackingAdjust", (String)("Deep link URL: " + deeplink));
                return true;
            }
        });
        FirebaseInstanceId.getInstance().getInstanceId().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<InstanceIdResult>(){

            public void onSuccess(InstanceIdResult instanceIdResult) {
                String firebaseToken = instanceIdResult.getToken();
                Adjust.setPushToken((String)firebaseToken, (Context)context);
            }
        });
        Adjust.onCreate((AdjustConfig)config);
        context.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new AdjustLifecycleCallbacks());
    }

    private static final class AdjustLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private AdjustLifecycleCallbacks() {
        }

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
            Adjust.onResume();
        }

        public void onActivityPaused(@NonNull Activity activity) {
            Adjust.onPause();
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }
    }
}

