package com.game.sdk.ui.payment;


import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.MyCallback;
import com.game.sdk.comon.api.request.NotificationRequest;
import com.game.sdk.comon.api.request.PaymentRequest;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.err.RetryPaymentErrObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.SaveFcmRequestObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.RetryPaymentResponseObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.InteractorCallback;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.Utils;

import retrofit2.Call;
import retrofit2.Response;

public class PaymentInteractorImpl implements IPaymentInteractor {
    private static final String TAG = PaymentInteractorImpl.class.getName();

    private InteractorCallback mCallback;

    Call<VerifyPurchaseResponseObj> mVerifyPurchaseResponseObj;
    Call<RetryPaymentResponseObj> mRetryPaymentResponseObj;

    public PaymentInteractorImpl(InteractorCallback mCallback) {
        this.mCallback = mCallback;
    }


    @Override
    public void verifyPurchase(VerifyPurchaseRequestObj obj) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        mVerifyPurchaseResponseObj = request.verifyPurchase(obj.getOrder_no(), obj);

        LogUtils.d("RECEIPT", obj.getReceipt().toString());
        mVerifyPurchaseResponseObj.enqueue(callbackVerifyPurchase);
    }

    @Override
    public void retryPurchase(String appKey, String userId, String characterId, String areaId, String packageName, String purchaseToken, String productId) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        String appVer = Utils.getGameVersion(GameSdk.getInstance().getApplication());
        mRetryPaymentResponseObj = request.retryPayment(appKey, appVer, userId, characterId, areaId, packageName, purchaseToken, productId);
        mRetryPaymentResponseObj.enqueue(callbackRetryPayment);
    }


    @Override
    public void cancelRequest(String... tags) {
        if (mVerifyPurchaseResponseObj != null)
            mVerifyPurchaseResponseObj.cancel();
        if (mRetryPaymentResponseObj != null)
            mRetryPaymentResponseObj.cancel();
    }

    private MyCallback<VerifyPurchaseResponseObj> callbackVerifyPurchase = new MyCallback<VerifyPurchaseResponseObj>() {
        @Override
        public void onSuccess(Call<VerifyPurchaseResponseObj> call, Response<VerifyPurchaseResponseObj> response) {
            if (response.isSuccessful()) {
                mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<VerifyPurchaseResponseObj> call, Object object) {
            BaseObj obj = (BaseObj) object;
            VerifyPurchaseErrObj err = new VerifyPurchaseErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            mCallback.error(err);
        }
    };

    private MyCallback<RetryPaymentResponseObj> callbackRetryPayment = new MyCallback<RetryPaymentResponseObj>() {
        @Override
        public void onSuccess(Call<RetryPaymentResponseObj> call, Response<RetryPaymentResponseObj> response) {
            if (response.isSuccessful()) {
                mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<RetryPaymentResponseObj> call, Object object) {
            BaseObj obj = (BaseObj) object;
            RetryPaymentErrObj err = new RetryPaymentErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            mCallback.error(err);
        }
    };
}
