/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.ui.payment;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.game.sdk.comon.cmd.CmdPaymentV3;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.BaseDialogWebFragment;
import com.game.sdk.comon.js.JsBase;
import com.game.sdk.comon.js.JsPayment;
import com.game.sdk.comon.listener.IWebViewClientListener;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.ListPurchaseHistoryObj;
import com.game.sdk.comon.object.ProductObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.err.RetryPaymentErrObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.RetryPaymentResponseObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.AdjustTracking;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.PurchaseUtils;
import com.game.sdk.comon.utils.ToastUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.payment.IPaymentPresenter;
import com.game.sdk.ui.payment.PaymentPresenterImpl;
import com.mobgame.R;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PaymentFragment
extends BaseDialogWebFragment {
    public static String TAG = PaymentFragment.class.getSimpleName();
    String account_id;
    int current;
    PurchaseHistoryObj currentPurchase;
    PaymentGGSuccess paymentGGSuccess;
    boolean sendHistory;
    ArrayList<IPaymentPresenter> listPresenter;
    List<SkuDetails> skuDetails;
    ProductObj productObj;
    Purchase purchase;
    private SkuDetailsResponseListener skuDetailsResponseListener = new SkuDetailsResponseListener(){

        public void onSkuDetailsResponse(@NonNull BillingResult billingResult, @Nullable List<SkuDetails> list) {
            int responseCode = billingResult.getResponseCode();
            String debugMessage = billingResult.getDebugMessage();
            switch (responseCode) {
                case 0: {
                    Log.d((String)TAG, (String)("onSkuDetailsResponse: " + responseCode));
                    if (list != null && list.size() > 0) {
                        PaymentFragment.this.skuDetails = list;
                        CmdPaymentV3.getInstance().launchBillingFlow(PaymentFragment.this.getActivity(), PaymentFragment.this.skuDetails.get(PaymentFragment.this.skuDetails.size() - 1));
                        break;
                    }
                    Toast.makeText((Context)PaymentFragment.this.mActivity, (int)R.string.error_transaction, (int)0).show();
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Log.e((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                    break;
                }
                default: {
                    Log.wtf((String)TAG, (String)("onSkuDetailsResponse: " + responseCode + " " + debugMessage));
                }
            }
        }
    };

    public static PaymentFragment newInstance(String url, PaymentGGSuccess paymentGGSuccess) {
        PaymentFragment frag = new PaymentFragment();
        Bundle args = new Bundle();
        args.putString(URL_WEBVIEW, url);
        LogUtils.d(TAG, url);
        frag.setArguments(args);
        frag.setPaymentGGSuccess(paymentGGSuccess);
        return frag;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CmdPaymentV3.getInstance().initIABv3((Context)this.getActivity(), new BillingClientStateListener(){

            public void onBillingSetupFinished(@NonNull BillingResult billingResult) {
                int responseCode = billingResult.getResponseCode();
                String debugMessage = billingResult.getDebugMessage();
                Log.d((String)TAG, (String)("onBillingSetupFinished: " + responseCode + " " + debugMessage));
                CmdPaymentV3.getInstance().queryHistory(new PurchaseHistoryResponseListener(){

                    public void onPurchaseHistoryResponse(@NonNull BillingResult billingResult, @Nullable List<PurchaseHistoryRecord> list) {
                        Log.d((String)TAG, (String)("onQueryHistory: " + list.size()));
                        if (list.size() == 0) {
                            Log.d((String)TAG, (String)"Item empty ");
                        } else if (list.size() == 1) {
                            PaymentFragment.this.retryGooglePayment(list.get(0));
                            Log.d((String)TAG, (String)("Item  : " + list.get(0).getPurchaseTime()));
                        } else {
                            Log.d((String)TAG, (String)("Item 1 : " + list.get(0).getPurchaseTime()));
                            Log.d((String)TAG, (String)("Item 2 : " + list.get(1).getPurchaseTime()));
                            if (list.get(0).getPurchaseTime() > list.get(1).getPurchaseTime()) {
                                PaymentFragment.this.retryGooglePayment(list.get(0));
                                Log.d((String)TAG, (String)"Purchase Item 1  ");
                            } else {
                                PaymentFragment.this.retryGooglePayment(list.get(1));
                                Log.d((String)TAG, (String)"Purchase Item 2 ");
                            }
                        }
                    }
                });
            }

            public void onBillingServiceDisconnected() {
                Log.d((String)TAG, (String)"onBillingServiceDisconnected: ");
            }
        }, new PurchasesUpdatedListener(){

            public void onPurchasesUpdated(@NonNull BillingResult billingResult, @Nullable List<Purchase> list) {
                int responseCode = billingResult.getResponseCode();
                String debugMessage = billingResult.getDebugMessage();
                Log.d((String)TAG, (String)("onPurchasesUpdated:  " + responseCode + " " + debugMessage));
                switch (responseCode) {
                    case 0: {
                        PaymentFragment.this.processPurchases(list);
                        break;
                    }
                    case 1: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: User canceled the purchase");
                        PaymentFragment.this.skuDetails.clear();
                        break;
                    }
                    case 4: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: This item is unavailable");
                        break;
                    }
                    case 7: {
                        Log.i((String)TAG, (String)"onPurchasesUpdated: The user already owns this item");
                        break;
                    }
                    case 5: {
                        Log.e((String)TAG, (String)"onPurchasesUpdated: Developer error means that Google Play does not recognize the configuration. If you are just getting started, make sure you have configured the application correctly in the Google Play Console. The SKU product ID must match and the APK you are using must be signed with release keys.");
                        break;
                    }
                    default: {
                        Log.i((String)TAG, (String)("onPurchasesUpdated: " + debugMessage));
                    }
                }
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            TrackingUtil.getInstance().trackPaymentScreenOpened();
            AdjustTracking.getInstance().trackPaymentScreenOpened();
            this.account_id = GameConfigs.getInstance().getUser().getAccount().getAccountId();
            this.listPresenter = new ArrayList();
            this.skuDetails = new ArrayList<SkuDetails>();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.current = -1;
        this.sendHistory = false;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.sendHistory) {
            this.sendHistory = true;
            this.checkPurchaseHistory();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        CmdPaymentV3.getInstance().billingEndConnection();
    }

    public void sendHistory(final PurchaseHistoryObj obj) {
        PaymentPresenterImpl presenter = new PaymentPresenterImpl(new BaseView(){

            @Override
            public void showProgress(String message) {
            }

            @Override
            public void hideProgress() {
            }

            public void success(Object x) {
                if (x instanceof VerifyPurchaseResponseObj) {
                    VerifyPurchaseResponseObj responseObj = (VerifyPurchaseResponseObj)x;
                    int status = responseObj.getData().getStatus();
                    if (status == 3 || status == 2 || status == 17) {
                        TrackingUtil.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                        AdjustTracking.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                    } else {
                        TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(status), responseObj.getData().getDescription());
                        AdjustTracking.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(status), responseObj.getData().getDescription());
                    }
                    obj.setAccount_id(PaymentFragment.this.account_id);
                    PurchaseUtils.removeSuccessPurchase(obj, PaymentFragment.this.mActivity);
                    --PaymentFragment.this.current;
                    PaymentFragment.this.checkPurchaseHistory();
                    LogUtils.e(TAG, "Verify Success - " + obj.getOrder_no());
                }
            }

            public void error(Object o) {
                BaseObj err;
                if (o instanceof VerifyPurchaseErrObj) {
                    err = (VerifyPurchaseErrObj)o;
                    LogUtils.e(TAG, "Verify failed - " + obj.getOrder_no() + " :" + err.getMessage());
                    PaymentFragment.this.checkPurchaseHistory();
                }
                if (o instanceof BaseObj) {
                    err = (BaseObj)o;
                    TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(err.getStatus()), err.getMessage());
                    AdjustTracking.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(err.getStatus()), err.getMessage());
                }
            }
        });
        TrackingUtil.getInstance().trackPaymentBeforVerify(obj.getOrder_no());
        AdjustTracking.getInstance().trackPaymentBeforVerify(obj.getOrder_no());
        this.listPresenter.add(presenter);
        this.onVerifyPurchase(presenter, obj.getReceipt(), obj.getOrder_no());
    }

    public void checkPurchaseHistory() {
        ++this.current;
        ListPurchaseHistoryObj listPurchaseHistoryObj = PrefManager.getHistoryPurchase((Context)this.mActivity, this.account_id);
        if (listPurchaseHistoryObj.getData() == null || listPurchaseHistoryObj.getData().size() == 0 || listPurchaseHistoryObj.getData().size() <= this.current && this.current >= 0) {
            return;
        }
        PurchaseHistoryObj obj = listPurchaseHistoryObj.getData().get(this.current);
        this.sendHistory(obj);
    }

    public void onVerifyPurchase(IPaymentPresenter presenter, VerifyPurchaseRequestObj.Receipt receipt, String order_no) {
        VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setOrder_no(order_no);
        obj.setMethod("2");
        obj.setReceipt(receipt);
        obj.setApp_version(Utils.getGameVersion((Context)this.mActivity));
        obj.setSdk_version(Utils.getSDKVersion((Context)this.mActivity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setResolution(DeviceUtils.getResolution((Context)this.mActivity));
        obj.setNetwork(Utils.getNetwork((Context)this.mActivity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID((Context)this.mActivity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID((Context)this.mActivity));
        obj.setLocale(GameConfigs.getInstance().getLang());
        if (presenter != null) {
            presenter.verifyPurchase(obj);
        }
    }

    @Override
    protected JsBase getJsHandler() {
        return new JsPayment(new JsPayment.Listener(){

            @Override
            public void onPaymentStartIAPV3(String params) {
                Log.d((String)TAG, (String)("onPaymentStartIAPV3: " + params));
                PaymentFragment.this.productObj = new ProductObj(params);
                String noOrder = PaymentFragment.this.productObj.getOrder_no();
                String productId = PaymentFragment.this.productObj.getProduct_id();
                if (TextUtils.isEmpty((CharSequence)noOrder)) {
                    DialogUtils.showErrorDialog(PaymentFragment.this.mActivity, PaymentFragment.this.mActivity.getString(R.string.err_and_try_again_late));
                    return;
                }
                CmdPaymentV3.getInstance().querySkuDetails(productId, PaymentFragment.this.skuDetailsResponseListener);
            }

            @Override
            public void onCloseWindow() {
                PaymentFragment.this.dismiss();
            }

            @Override
            public void onOpenWindow() {
            }

            @Override
            public void onBackToWindowns() {
                PaymentFragment.this.goBack();
            }
        });
    }

    private void processPurchases(List<Purchase> purchasesList) {
        if (purchasesList != null) {
            Log.d((String)TAG, (String)("processPurchases: " + purchasesList.size() + " purchase(s)"));
            for (Purchase purchase : purchasesList) {
                this.handlePurchase(purchase);
            }
        } else {
            Log.d((String)TAG, (String)"processPurchases: with no purchases");
            Log.d((String)TAG, (String)"onPurchasesUpdated: null purchase list");
        }
    }

    private void handlePurchase(final Purchase purchase) {
        Log.i((String)TAG, (String)("handlePurchase: " + purchase.getPurchaseState()));
        if (purchase.getPurchaseState() == 1) {
            Log.i((String)TAG, (String)"PURCHASE IS PURCHASED ");
            this.purchase = purchase;
            CmdPaymentV3.getInstance().consumeAsyncPurchase(purchase, new ConsumeResponseListener(){

                public void onConsumeResponse(@NonNull BillingResult billingResult, @NonNull String s) {
                    PaymentFragment.this.skuDetails.clear();
                    if (billingResult.getResponseCode() == 0) {
                        PaymentFragment.this.currentPurchase = new PurchaseHistoryObj();
                        String character_id = PrefManager.getString((Context)PaymentFragment.this.mActivity, "MOB_ROLE_ID", "");
                        String area_id = PrefManager.getString((Context)PaymentFragment.this.mActivity, "MOB_AREA_ID", "");
                        PaymentFragment.this.currentPurchase.setArea_id(area_id);
                        PaymentFragment.this.currentPurchase.setCharactor_id(character_id);
                        PaymentFragment.this.currentPurchase.setOrder_no(PaymentFragment.this.productObj.getOrder_no());
                        Log.i((String)TAG, (String)("currentPurchase: " + PaymentFragment.this.currentPurchase.getOrder_no()));
                        try {
                            JSONObject joReceipt = new JSONObject(purchase.getOriginalJson());
                            VerifyPurchaseRequestObj.Receipt rec = new VerifyPurchaseRequestObj.Receipt();
                            rec.setData(joReceipt.toString());
                            rec.setItemType("inapp");
                            rec.setSignature(purchase.getSignature());
                            PaymentFragment.this.currentPurchase.setReceipt(rec);
                        }
                        catch (Exception e) {
                            LogUtils.e("Err Purchase", e.getMessage());
                        }
                        PaymentFragment.this.currentPurchase.setIs_send(false);
                        PaymentFragment.this.currentPurchase.setAccount_id(PaymentFragment.this.account_id);
                        LogUtils.d("RECEIPT 1", purchase.getOriginalJson());
                        for (IPaymentPresenter p : PaymentFragment.this.listPresenter) {
                            if (p == null) continue;
                            p.cancelRequest(new String[0]);
                        }
                        PurchaseUtils.saveLastPurchaseGGSuccess(PaymentFragment.this.mActivity, PaymentFragment.this.account_id, purchase.getPurchaseToken());
                        PrefManager.saveUsePurchaseHistory((Context)PaymentFragment.this.mActivity, PaymentFragment.this.account_id, PaymentFragment.this.currentPurchase);
                        Log.i((String)TAG, (String)("currentPurchase: " + PaymentFragment.this.currentPurchase.getOrder_no()));
                        if (PaymentFragment.this.paymentGGSuccess != null) {
                            PaymentFragment.this.dismiss();
                            PaymentFragment.this.paymentGGSuccess.onPaymentGGSuccess(PaymentFragment.this.currentPurchase);
                        }
                    }
                }
            });
        } else if (purchase.getPurchaseState() == 2) {
            Log.i((String)TAG, (String)"PURCHASE IS PENDING ");
        }
    }

    @Override
    protected IWebViewClientListener getWebListener() {
        return new IWebViewClientListener(){

            @Override
            public void shouldOverrideUrlLoading(WebView view, String url) {
            }

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
            }

            @Override
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                TrackingUtil.getInstance().trackPaymentLoadScreenFail(String.valueOf(errorCode), description);
                AdjustTracking.getInstance().trackPaymentLoadScreenFail(String.valueOf(errorCode), description);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                TrackingUtil.getInstance().trackPaymentLoadScreenSuccess();
                AdjustTracking.getInstance().trackPaymentLoadScreenSuccess();
            }
        };
    }

    public void retryGooglePayment(final PurchaseHistoryRecord pr) {
        if (PurchaseUtils.isPurchaseTokenRequested(this.mActivity, pr.getPurchaseToken())) {
            LogUtils.d(TAG, "check History : t\u1ea5t c\u1ea3 giao d\u1ecbch \u0111\u00e3 \u0111\u01b0\u1ee3c x\u1eed l\u00fd");
        } else {
            LogUtils.d(TAG, "getPurchaseToken " + pr.getPurchaseToken());
            PaymentPresenterImpl presenter = new PaymentPresenterImpl(new BaseView(){

                @Override
                public void showProgress(String message) {
                }

                @Override
                public void hideProgress() {
                }

                public void success(Object x) {
                    if (x instanceof RetryPaymentResponseObj) {
                        RetryPaymentResponseObj o = (RetryPaymentResponseObj)x;
                        LogUtils.d(TAG, "Retry Success" + o.getMessage());
                        ToastUtils.showLengthInfoToast((Context)PaymentFragment.this.mActivity, o.getMessage());
                        PurchaseUtils.markPurchaseToken(PaymentFragment.this.mActivity, pr.getPurchaseToken(), true);
                        if (o.getStatus() == 1 || o.getStatus() == 2028 || o.getStatus() == 2027) {
                            TrackingUtil.getInstance().trackRetryPurchaseFail(String.valueOf(o.getStatus()), o.getMessage());
                        }
                    }
                }

                public void error(Object o) {
                    if (o instanceof RetryPaymentErrObj) {
                        RetryPaymentErrObj err = (RetryPaymentErrObj)o;
                        LogUtils.e(TAG, "Retry failed " + err.getMessage());
                        if (err.getStatus() == 1 || err.getStatus() == 2028 || err.getStatus() == 2027) {
                            PurchaseUtils.markPurchaseToken(PaymentFragment.this.mActivity, pr.getPurchaseToken(), true);
                        }
                        TrackingUtil.getInstance().trackRetryPurchaseFail(String.valueOf(err.getStatus()), err.getMessage());
                    }
                }
            });
            String appKey = GameConfigs.getInstance().getAppKey();
            int userId = GameConfigs.getInstance().getUser().getId();
            String role_id = PrefManager.getString((Context)this.mActivity, "MOB_ROLE_ID", "");
            String area_id = PrefManager.getString((Context)this.mActivity, "MOB_AREA_ID", "");
            presenter.retryPurchase(appKey, String.valueOf(userId), role_id, area_id, this.mActivity.getPackageName(), pr.getPurchaseToken(), pr.getSku());
        }
    }

    public void setPaymentGGSuccess(PaymentGGSuccess paymentGGSuccess) {
        this.paymentGGSuccess = paymentGGSuccess;
    }

    public static interface PaymentGGSuccess {
        public void onPaymentGGSuccess(PurchaseHistoryObj var1);
    }
}

