/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.view.View;
import com.adjust.sdk.Adjust;
import com.adjust.sdk.AdjustEvent;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.VerifyPurchaseObj;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.AdjustUtil;
import com.game.sdk.comon.tracking.Firebase;
import com.game.sdk.comon.utils.LogUtils;
import com.mobgame.R;
import java.util.HashMap;

public class AdjustTracking {
    public static String TAG = AdjustTracking.class.getName();
    private Context context;
    private String app_token = "h6lq7hw6ul8g";
    private String environment = "production";
    private AdjustEvent event;
    private Firebase firebase;
    private long beginTime;
    private static AdjustTracking trackingUtil;
    private long timeOpenDashBoard;

    public void init(Application application) {
        this.context = application;
        this.firebase = Firebase.newInstance(application);
        AdjustUtil.init(application, this.app_token, this.environment);
    }

    public static AdjustTracking getInstance() {
        if (trackingUtil == null) {
            trackingUtil = new AdjustTracking();
        }
        return trackingUtil;
    }

    public void trackEvent(String event1, String track) {
        LogUtils.d(TAG, track);
        AdjustEvent event = new AdjustEvent(event1);
        event.setCallbackId(track);
        Adjust.trackEvent((AdjustEvent)event);
    }

    public void trackFirstLaunch() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_first_launched));
        this.beginTime = System.currentTimeMillis();
        this.event.addCallbackParameter("time_first_launcher", String.valueOf(this.beginTime));
        LogUtils.d(TAG, "ft_first_launched");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackAppLaunch() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_app_launched));
        this.beginTime = System.currentTimeMillis();
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLogoutSuccess(int userId) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_logout_success));
        this.event.addCallbackParameter("ft_user_id", String.valueOf(userId));
        LogUtils.d(TAG, "ft_logout_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackAppClose() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_app_close));
        LogUtils.d(TAG, "ft_app_close");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackPurchaseLog() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_purchase_log));
        LogUtils.d(TAG, "ft_purchase_log");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackPaymentScreenOpened() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_payment_screen_opened));
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.event.addCallbackParameter("ft_user_id", user_id);
        this.event.addCallbackParameter("ft_role_id", character_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        LogUtils.d(TAG, "ft_payment_screen_opened");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackPaymentLoadScreenSuccess() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_payment_screen_load_success));
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.event.addCallbackParameter("ft_user_id", user_id);
        this.event.addCallbackParameter("ft_role_id", character_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        LogUtils.d(TAG, "ft_payment_screen_load_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackPaymentLoadScreenFail(String error_code, String error_message) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_payment_screen_load_fail));
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.event.addCallbackParameter("ft_user_id", user_id);
        this.event.addCallbackParameter("ft_role_id", character_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        this.event.addCallbackParameter("error_code", error_code);
        this.event.addCallbackParameter("error_message", error_message);
        LogUtils.d(TAG, "ft_payment_screen_load_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackPaymentBeforVerify(String order_no) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_payment_before_verify));
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        long currentTime = System.currentTimeMillis();
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.event.addCallbackParameter("ft_user_id", user_id);
        this.event.addCallbackParameter("ft_role_id", character_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        this.event.addCallbackParameter("order_no", order_no);
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        LogUtils.d(TAG, "ft_payment_before_verify");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackPaymentVerifySuccess(VerifyPurchaseObj obj) {
        this.event = new AdjustEvent(this.context.getString(R.string.af_purchase));
        try {
            String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
            String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
            String user_id = "";
            long currentTime = System.currentTimeMillis();
            long startCall = PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_payment_before_verify", currentTime);
            long deta_call = currentTime - startCall;
            try {
                user_id = user_id + GameConfigs.getInstance().getUser().getId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.event.addCallbackParameter("ft_user_id", user_id);
            this.event.addCallbackParameter("ft_role_id", character_id);
            this.event.addCallbackParameter("ft_area_id", area_id);
            this.event.addCallbackParameter("order_no", obj.getOrder_no());
            this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
            this.event.addCallbackParameter("delta_call", String.valueOf(deta_call));
            double price = 0.01 * (double)obj.getPlatform_price();
            this.event.addCallbackParameter("ft_revenue", String.valueOf(price));
            this.event.addCallbackParameter("content_type", "category_rev");
            this.event.addCallbackParameter("content_id", "123456");
            this.event.setRevenue(price, "USD");
            LogUtils.d(TAG, "af_purchase");
            Adjust.trackEvent((AdjustEvent)this.event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentVerifyFail(String order_no, String type_error, String err_code, String err_mesage) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_payment_screen_load_fail));
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        long currentTime = System.currentTimeMillis();
        long startCall = PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_payment_before_verify", currentTime);
        long deta_call = currentTime - startCall;
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.event.addCallbackParameter("ft_user_id", user_id);
        this.event.addCallbackParameter("ft_role_id", character_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        this.event.addCallbackParameter("order_no", order_no);
        this.event.addCallbackParameter("type_error", type_error);
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(deta_call));
        this.event.addCallbackParameter("error_code", err_code);
        this.event.addCallbackParameter("error_message", err_mesage);
        LogUtils.d(TAG, "ft_payment_screen_load_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackStartExtractData(Activity activity) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_extract_started));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        LogUtils.d(TAG, "ft_extract_started");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackFinishExtractData() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_extract_finished));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("delta_extract", String.valueOf(PrefManager.getLong(this.context, "BEGIN_ACTION_TIME", currentTime)));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_TIME", 0L);
        LogUtils.d(TAG, "ft_extract_finished");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackDownloadResourceStarted() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_resource_started));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_TIME", currentTime);
        LogUtils.d(TAG, "ft_resource_started");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackDownloadResourceFinished() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_resource_finished));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("delta_extract", String.valueOf(PrefManager.getLong(this.context, "BEGIN_ACTION_TIME", currentTime)));
        PrefManager.saveSetting((Context)GameSdk.getInstance().getApplication(), "ft_resource_finished", currentTime);
        LogUtils.d(TAG, "ft_resource_finished");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackExtractCDNFinished(Activity activity) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_extract_cdn_finished));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        long delta_resource = currentTime - PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_resource_finished", currentTime);
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("delta_resource", String.valueOf(delta_resource));
        this.event.setCallbackId("ft_extract_cdn_finished");
        LogUtils.d(TAG, "ft_extract_cdn_finished");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackSession() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_session));
        long endTime = System.currentTimeMillis();
        long deltaTime = endTime - this.beginTime;
        this.event.addCallbackParameter("ft_start_time", String.valueOf(this.beginTime));
        this.event.addCallbackParameter("ft_end_time ", String.valueOf(endTime));
        this.event.addCallbackParameter("ft_length_second", String.valueOf(deltaTime));
        LogUtils.d(TAG, "ft_session");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLastSession(Context ct) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_session));
        int minute = PrefManager.getInt(ct, "SESSION_OUT_TIME", 10);
        long milisecond = minute * 60 * 1000;
        long begin = PrefManager.getLong(ct, "LAST_SESSION_START", 0L);
        long endTime = PrefManager.getLong(ct, "LAST_SESSION_END", 0L);
        long deltaTime = PrefManager.getLong(ct, "LAST_SESSION_DETAl", 0L);
        if (begin == 0L || endTime == 0L) {
            return;
        }
        if (deltaTime < milisecond) {
            return;
        }
        if (this.beginTime - endTime < milisecond) {
            this.beginTime = begin;
            return;
        }
        LogUtils.d(TAG, "Begin: " + begin + " - End : " + endTime + " - Detal : " + deltaTime);
        HashMap hashMap = new HashMap();
        this.event.addCallbackParameter("ft_start_time", String.valueOf(begin));
        this.event.addCallbackParameter("ft_end_time ", String.valueOf(endTime));
        this.event.addCallbackParameter("ft_length_second", String.valueOf(deltaTime));
        LogUtils.d(TAG, "ft_session");
        Adjust.trackEvent((AdjustEvent)this.event);
        this.clearSession(ct);
    }

    public void saveSession(Context ct) {
        long endTime = System.currentTimeMillis();
        long deltaTime = endTime - this.beginTime;
        PrefManager.saveSetting(ct, "LAST_SESSION_START", this.beginTime);
        PrefManager.saveSetting(ct, "LAST_SESSION_END", endTime);
        PrefManager.saveSetting(ct, "LAST_SESSION_DETAl", deltaTime);
    }

    public void clearSession(Context ct) {
        PrefManager.saveSetting(ct, "LAST_SESSION_START", 0);
        PrefManager.saveSetting(ct, "LAST_SESSION_END", 0);
        PrefManager.saveSetting(ct, "LAST_SESSION_DETAl", 0);
    }

    public void trackLoginSuccess(int userId, String type, String loginOrRegisterType) {
        this.event = new AdjustEvent(this.context.getString(R.string.af_login));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        long start_open_login = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", currentTime);
        long deta_login = currentTime - start_open_login;
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("delta_login", String.valueOf(deta_login));
        this.event.addCallbackParameter("ft_user_id", String.valueOf(userId));
        this.event.addCallbackParameter("ft_type", type);
        this.event.addCallbackParameter("ft_login_or_register_type", loginOrRegisterType);
        LogUtils.d(TAG, "af_login");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackClickBtnEnterGame(int serverId) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_enter_game_btn_clicked));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("ft_server_id", String.valueOf(serverId));
        this.event.addCallbackParameter("ft_server_id", String.valueOf(serverId));
        LogUtils.d(TAG, "ft_enter_game_btn_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackCharactorCreated(Activity activity, int user_id, String role_id, String area_id) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_character_created));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        this.event.addCallbackParameter("ft_role_id", role_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        LogUtils.d(TAG, "ft_character_created");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackCharactorCreatedSuccess(int user_id, String role_id, String area_id) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_character_created_call_api_success));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        this.event.addCallbackParameter("ft_role_id", role_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        LogUtils.d(TAG, "ft_character_created_call_api_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackCharactorCreatedFailed(int user_id, String role_id, String area_id) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_character_created_call_api_fail));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        this.event.addCallbackParameter("delta", String.valueOf(delta));
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        this.event.addCallbackParameter("ft_role_id", role_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        LogUtils.d(TAG, "ft_character_created_call_api_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackTutorialCompletion(int user_id, String role_id, String area_id) {
        this.event = new AdjustEvent(this.context.getString(R.string.af_tutorial_completion));
        this.event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        this.event.addCallbackParameter("ft_role_id", role_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        LogUtils.d(TAG, "af_tutorial_completion");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLevelAchieved(Activity activity, int user_id, String role_id, String area_id, String af_level) {
        this.event = new AdjustEvent(this.context.getString(R.string.af_level_achieved));
        this.event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        this.event.addCallbackParameter("ft_role_id", role_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        this.event.addCallbackParameter("af_level ", af_level);
        LogUtils.d(TAG, "af_level_achieved");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackVipAchieved(int user_id, String role_id, String area_id, String ft_vip) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_vip_achieved));
        this.event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        this.event.addCallbackParameter("ft_role_id", role_id);
        this.event.addCallbackParameter("ft_area_id", area_id);
        this.event.addCallbackParameter("ft_vip", ft_vip);
        LogUtils.d(TAG, "ft_vip_achieved");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginScreenOpen() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_login_screen_opened));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        this.event = new AdjustEvent(this.context.getString(R.string.ft_login_screen_opened));
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        LogUtils.d(TAG, "ft_login_screen_opened");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackClickLoginButton(String btnTitle) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_btn_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("ft_button_title", btnTitle);
        LogUtils.d(TAG, "ft_ls_login_btn_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackClickLoginEmailButton() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_email_btn_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_email_btn_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginEmailInputError(int errCode, String errMessage) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_email_input_error));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("error_code", String.valueOf(errCode));
        this.event.addCallbackParameter("error_message", errMessage);
        LogUtils.d(TAG, "ft_ls_login_email_input_error");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginEmailCallApi() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_email_api_call));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_email_api_call");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginEmailCallApiSuccess() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_email_api_call_success));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, this.context.getString(R.string.BEGIN_ACTION_LOGIN_TIME), current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        LogUtils.d(TAG, "ft_ls_login_email_api_call_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginEmailCallApiFail(int errCode, String mess) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_email_api_call_fail));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        this.event.addCallbackParameter("error_code", String.valueOf(errCode));
        this.event.addCallbackParameter("error_message", mess);
        LogUtils.d(TAG, "ft_ls_login_email_api_call_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackClickLoginFacebookButton() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_facebook_btn_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_facebook_btn_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackCancelLoginFacebook() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_facebook_user_canceled));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_facebook_user_canceled");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginFacebookSdkErr(String mess) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_facebook_have_error));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("error_message", mess);
        LogUtils.d(TAG, "ft_ls_login_facebook_have_error");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginFacebookCallApi() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_facebook_api_call));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_facebook_api_call");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginFacebookCallApiSuccess() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_facebook_api_call_success));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        LogUtils.d(TAG, "ft_ls_login_facebook_api_call_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginFacebookCallApiFail(int errCode, String mess) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_facebook_api_call_fail));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        this.event.addCallbackParameter("error_code", String.valueOf(errCode));
        this.event.addCallbackParameter("error_message", mess);
        LogUtils.d(TAG, "ft_ls_login_facebook_api_call_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackClickLoginGoogleButton() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_google_btn_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_google_btn_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackCancelLoginGoogle() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_google_user_canceled));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_google_user_canceled");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginGoogleSdkErr(int errCode, String mess) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_google_have_error));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("error_code", String.valueOf(errCode));
        this.event.addCallbackParameter("error_message", mess);
        LogUtils.d(TAG, "ft_ls_login_google_have_error");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginGoogleCallApi() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_google_api_call));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_google_api_call");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginGoogleCallApiSuccess() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_google_api_call_success));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        LogUtils.d(TAG, "ft_ls_login_google_api_call_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginGoogleCallApiFail(int errCode, String mess) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_google_api_call_fail));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        this.event.addCallbackParameter("error_code", String.valueOf(errCode));
        this.event.addCallbackParameter("error_message", mess);
        LogUtils.d(TAG, "ft_ls_login_google_api_call_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginPlayNowCallApi() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_playnow_btn_clicked));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_login_playnow_btn_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginPlayNowCallApiSuccess() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_playnow_api_call_success));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        LogUtils.d(TAG, "ft_ls_login_playnow_api_call_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginPlayNowCallApiFail(int errCode, String mess) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_login_playnow_api_call_fail));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        this.event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        this.event.addCallbackParameter("error_code", String.valueOf(errCode));
        this.event.addCallbackParameter("error_message", mess);
        LogUtils.d(TAG, "ft_ls_login_playnow_api_call_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackGetSdkConfigSuccess() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_game_config_call_api_success));
        long current = System.currentTimeMillis();
        long start_time = PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_ls_game_config_call_api_success", System.currentTimeMillis());
        long deltaTime = current - start_time;
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        LogUtils.d(TAG, "ft_ls_game_config_call_api_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackGetSdkConfigFailed(int code) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_game_config_call_api_fail));
        long current = System.currentTimeMillis();
        long start_time = PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_ls_game_config_call_api_success", System.currentTimeMillis());
        long deltaTime = current - start_time;
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        LogUtils.d(TAG, "ft_ls_game_config_call_api_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackClickBtnRegister() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_register_btn_clicked));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_register_btn_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackRegisterLoadSuccess() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_register_form_load_success));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_register_form_load_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackRegisterSubmitForm() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_register_form_submited));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delra_login", String.valueOf(current - startTime));
        LogUtils.d(TAG, "ft_ls_register_form_submited");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackLoginScreenClose(View form, View text, View button) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_close_btn_clicked));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long delta_login = current - PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        this.event.addCallbackParameter("delta_login", String.valueOf(delta_login));
        LogUtils.d(TAG, "ft_ls_close_btn_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackCallAuthenConfigSuccess() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_get_authen_api_call_success));
        long current = System.currentTimeMillis();
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        LogUtils.d(TAG, "ft_ls_get_authen_api_call_success");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackMaintainScreenOpened() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_maintain_screen_opened));
        long current = System.currentTimeMillis();
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        LogUtils.d(TAG, "ft_maintain_screen_opened");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackCallAuthenConfigFailed() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_get_authen_api_call_fail));
        long current = System.currentTimeMillis();
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        LogUtils.d(TAG, "ft_ls_get_authen_api_call_fail");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackForgotPassword() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_ls_forgot_password_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        this.event.addCallbackParameter("timestamp", String.valueOf(current));
        this.event.addCallbackParameter("delta", String.valueOf(deltaTime));
        LogUtils.d(TAG, "ft_ls_forgot_password_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackDashboardScreenOpened() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_dashboard_screen_opened));
        this.timeOpenDashBoard = System.currentTimeMillis();
        this.event.addCallbackParameter("timestamp", String.valueOf(this.timeOpenDashBoard));
        LogUtils.d(TAG, "ft_dashboard_screen_opened");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackDashboardScreenLeftMenuCLicked(String buttonName) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_dashboard_screen_left_menu_button_clicked));
        long currentTime = System.currentTimeMillis();
        long delta_time_dashboard = currentTime - this.timeOpenDashBoard;
        HashMap hashMap = new HashMap();
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("delta_dashboard", String.valueOf(delta_time_dashboard));
        this.event.addCallbackParameter("button_name", String.valueOf(buttonName));
        LogUtils.d(TAG, "ft_dashboard_screen_left_menu_button_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackDashboardScreenTopMenuCLicked(String buttonName) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_dashboard_screen_top_menu_button_clicked));
        long currentTime = System.currentTimeMillis();
        long delta_time_dashboard = currentTime - this.timeOpenDashBoard;
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("delta_dashboard", String.valueOf(delta_time_dashboard));
        this.event.addCallbackParameter("button_name", String.valueOf(buttonName));
        LogUtils.d(TAG, "ft_dashboard_screen_top_menu_button_clicked");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackDashboardScreenClosed() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_dashboard_screen_closed));
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        this.event.addCallbackParameter("time_close", String.valueOf(current - deltaTime));
        LogUtils.d(TAG, "ft_dashboard_screen_closed");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackDashboardSubScreenOpened(String subScreenName) {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_dashboard_screen_sub_screen_opened));
        long currentTime = System.currentTimeMillis();
        long delta_time_dashboard = currentTime - this.timeOpenDashBoard;
        this.event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        this.event.addCallbackParameter("delta_dashboard", String.valueOf(delta_time_dashboard));
        this.event.addCallbackParameter("sub_screen_name", String.valueOf(subScreenName));
        LogUtils.d(TAG, "ft_dashboard_screen_sub_screen_opened");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackClickOverlayPermission() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_overlay_click_permission));
        LogUtils.d(TAG, "ft_overlay_click_permission");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackStartPermisison() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_start_permisison));
        LogUtils.d(TAG, "ft_start_permisison");
        Adjust.trackEvent((AdjustEvent)this.event);
    }

    public void trackEndPermisison() {
        this.event = new AdjustEvent(this.context.getString(R.string.ft_end_permission));
        LogUtils.d(TAG, "ft_end_permission");
        Adjust.trackEvent((AdjustEvent)this.event);
    }
}

