package com.game.sdk.comon.api;


import android.content.Context;
import android.text.TextUtils;

import com.game.sdk.comon.api.request.GameRequest;
import com.game.sdk.comon.api.request.LoginRequest;
import com.game.sdk.comon.api.request.NotificationRequest;
import com.game.sdk.comon.api.request.PaymentRequest;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.constants.ConstantApi;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.Utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import retrofit2.Retrofit;

/**
 * Created by dungnv
 */

public class ApiUtils {

    public static LoginRequest getLoginRequest() {
        if (RetrofitClient.getInstance() == null)
            return null;
        return RetrofitClient.getInstance().create(LoginRequest.class);
    }

    public static GameRequest getGameRequest() {
        if (RetrofitClient.getInstance() == null)
            return null;
        return RetrofitClient.getInstance().create(GameRequest.class);
    }

    public static NotificationRequest getNotificationRequest() {
        Retrofit rft = RetrofitClient.getInteractIntance(ConstantApi.URL_BASE_INTERACT);
        if (rft == null)
            return null;
        return rft.create(NotificationRequest.class);
    }

    public static PaymentRequest getPaymentRequest() {
        Retrofit rft = RetrofitClient.getPaymentIntance(ConstantApi.URL_BASE_PAYTECH);
        if (rft == null)
            return null;
        return rft.create(PaymentRequest.class);
    }

    public static String getUrlWvRegister(Context ct) {
        String appKey = PrefManager.getAppKey(ct);
        String appVersion = Utils.getGameVersion(ct);
        String url = PrefManager.getString(ct, ConstantApi.APP_UR, ConstantApi.BASE_URL) + ConstantApi.URL_WEBVIEW_REGISTER;
        return url.replace("{app_key}", appKey).replace("{app_version}", appVersion);
    }

    public static String getUrlWvPayment(Context ct, String state) {
        VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setMethod("2");

        HashMap<String, String> params = new HashMap<String, String>();
        Set<Map.Entry<String, String>> set = params.entrySet();

        params.put("x_request", GameConfigs.getInstance().getAppKey());
        params.put("device_id", DeviceUtils.getUniqueDeviceID(ct));
        params.put("method", "2");
        params.put("character_id", PrefManager.getString(ct, com.game.sdk.comon.constants.Constants.ROLE_ID, ""));
        params.put("area_id", PrefManager.getString(ct, com.game.sdk.comon.constants.Constants.AREA_ID, ""));
        params.put("app_version", Utils.getGameVersion(ct));
        params.put("sdk_version", Utils.getSDKVersion(ct));
        params.put("device_name", DeviceUtils.getDevice());
        params.put("device_os", DeviceUtils.getOSInfo());
        params.put("resolution", DeviceUtils.getResolution(ct));
        params.put("network", Utils.getNetwork(ct));
        params.put("advertising_id", DeviceUtils.getAdvertisingID(ct));
        params.put("appsflyer_id", DeviceUtils.getAppsflyerUID(ct));
        params.put("locale", GameConfigs.getInstance().getLang());
        params.put("access_token", AuthenConfigs.getInstance().getAccessToken());

        String url = ConstantApi.URL_BASE_PAYTECH + ConstantApi.URL_PURCHASE_PRODUCTS;
        if (!TextUtils.isEmpty(state)) {
            url += "?payload=" + state;
        } else {
            url += "?hl=en";
        }
        for (Map.Entry<String, String> param : set) {
            if (!TextUtils.isEmpty(param.getValue())) {
                url += "&" + param.getKey() + "=" + param.getValue();
            }
        }
        return url.replace(" ","%20");
    }
    public static String getPathUrlWvDashboardNews(Context ct) {
        String appKey = PrefManager.getAppKey(ct);
        String appVersion = Utils.getGameVersion(ct);
        String url = PrefManager.getString(ct, ConstantApi.APP_UR, ConstantApi.BASE_URL) + ConstantApi.URL_WEBVIEW_DASHBOARD_NEWS;
        return url.replace("{app_key}", appKey).replace("{app_version}", appVersion);
    }
    public static String getPathUrlWvDashboardEvents(Context ct) {
        String appKey = PrefManager.getAppKey(ct);
        String appVersion = Utils.getGameVersion(ct);
        String url = PrefManager.getString(ct, ConstantApi.APP_UR, ConstantApi.BASE_URL) + ConstantApi.URL_WEBVIEW_DASHBOARD_EVENTS;
        return url.replace("{app_key}", appKey).replace("{app_version}", appVersion);
    }
    public static String getPathUrlWvDashboardMenu(Context ct) {
        String appKey = PrefManager.getAppKey(ct);
        String appVersion = Utils.getGameVersion(ct);
        String url = PrefManager.getString(ct, ConstantApi.APP_UR, ConstantApi.BASE_URL) + ConstantApi.URL_WEBVIEW_DASHBOARD_MENU;
        return url.replace("{app_key}", appKey).replace("{app_version}", appVersion);
    }
    public static String getPathUrlWvDashboardReports(Context ct) {
        String appKey = PrefManager.getAppKey(ct);
        String appVersion = Utils.getGameVersion(ct);
        String url = PrefManager.getString(ct, ConstantApi.APP_UR, ConstantApi.ISSUE_URL) + ConstantApi.URL_WEBVIEW_DASHBOARD_REPORTS;
        return url.replace("{app_key}", appKey).replace("{app_version}", appVersion);
    }
    public static String getUrlTerm(Context ct) {
        String appKey = PrefManager.getAppKey(ct);
        String appVersion = Utils.getGameVersion(ct);
        String url = PrefManager.getString(ct, ConstantApi.APP_UR, ConstantApi.BASE_URL) + ConstantApi.URL_WEBVIEW_TERM;
        return url.replace("{app_key}", appKey).replace("{app_version}", appVersion);
    }


}
