/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import com.appsflyer.AppsFlyerLib;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.Utils;
import com.mobgame.MobGameSDK;
import com.mobgame.utils.Preference;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashSet;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class RestfulApi {
    private static final String API_BASE_URL = "https://a.smobgame.com";
    private static RestfulApi INSTANCE;
    private static Retrofit retrofit;

    public static RestfulApi getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestfulApi();
        }
        return INSTANCE;
    }

    private RestfulApi() {
        try {
            OkHttpClient httpClient = RestfulApi.getCommonClient();
            retrofit = new Retrofit.Builder().baseUrl(API_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(httpClient).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static OkHttpClient getCommonClient() {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Activity activity = MobGameSDK.activity;
                Context context = MobGameSDK.getApplicationContext();
                Request.Builder builder = chain.request().newBuilder().addHeader("mobgame-device", DeviceUtils.getDevice()).addHeader("mobgame-os", DeviceUtils.getOSInfo()).addHeader("mobgame-resolution", Objects.requireNonNull(DeviceUtils.getResolution(context))).addHeader("mobgame-sdk-version", Utils.getSDKVersion(context)).addHeader("mobgame-appkey", GameConfigs.getInstance().getAppKey()).addHeader("mobgame-app-version", Utils.getGameVersion(context)).addHeader("mobgame-app-version-code", Utils.getGameVersionCode(context)).addHeader("mobgame-network", Utils.getNetwork(context)).addHeader("mobgame-orientation", DeviceUtils.getScreenOrientation(context) + "").addHeader("mobgame-distributor", Utils.getReferrer(context)).addHeader("mobgame_lang", DeviceUtils.getLanguage()).addHeader("mobgame-advertising-id", DeviceUtils.getAdvertisingID(context)).addHeader("mobgame-appsflyer-id", DeviceUtils.getAppsflyerUID(context));
                if (AuthenConfigs.getInstance().getAccessToken() != null) {
                    builder.addHeader("mobgame-token", AuthenConfigs.getInstance().getAccessToken());
                }
                if (AppsFlyerLib.getInstance().getAppsFlyerUID(context) != null) {
                    builder.addHeader("mobgame-appsflyer-id", AppsFlyerLib.getInstance().getAppsFlyerUID(context));
                }
                Request request = builder.build();
                return chain.proceed(request);
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Context c = MobGameSDK.getApplicationContext();
                Request.Builder builder = chain.request().newBuilder();
                HashSet preferences = (HashSet)Preference.getStringSet(c, "game_shared_pref_cookies", new HashSet<String>());
                for (String cookie : preferences) {
                    builder.addHeader("Cookie", cookie);
                }
                return chain.proceed(builder.build());
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                if (!originalResponse.headers("Set-Cookie").isEmpty()) {
                    Context c = MobGameSDK.getApplicationContext();
                    HashSet<String> cookies = new HashSet<String>();
                    for (String header : originalResponse.headers("Set-Cookie")) {
                        cookies.add(header);
                    }
                    Preference.save(c, "game_shared_pref_cookies", cookies);
                }
                return originalResponse;
            }
        }).build();
        return httpClient;
    }

    private static interface PlfRestService {
    }
}

