/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.js.JsHandler;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.comon.utils.WvUtil;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.component.FirebaseAnalyticsManager;
import com.mobgame.gui.MobGameWebView;
import com.mobgame.gui.view.MobSwipRefreshLayout;
import com.mobgame.model.MUrl;
import com.mobgame.utils.Preference;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.concurrent.ExecutionException;

@SuppressLint(value={"NewApi"})
public class MobGameWebFragment
extends Fragment {
    private static final String KEY_URL = "url";
    private static final String KEY_POST_PARAMS = "post_params";
    private static final String KEY_WEBVIEW_TAG = "fragment_web";
    private static final String KEY_ID = "id";
    public static final String HIDE_SWIPE = "hideSwipe";
    private final String TAG = MobGameWebFragment.class.getSimpleName();
    private int ntfId = 0;
    private MobGameWebView webView;
    private EventListener eventListener;
    private Bundle args = new Bundle();
    private String js = "";
    private MobSwipRefreshLayout mSwipeRefreshLayout;
    private JsHandler jsHandler;
    private Stack<String> historyBackstack = new Stack();
    private static HashMap<String, MUrl> cachedUrls;
    private String urlToLoad = "";
    private boolean isHideSwipe = false;
    private String urlLoadFail = "";
    BroadcastReceiver broadcastReceiver;

    public MobGameWebFragment() {
        cachedUrls = new HashMap();
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Log.i((String)MobGameWebFragment.this.TAG, (String)"reloadFromIntent");
                String category = intent.getStringExtra("category_from_bug");
                if ("refresh_from_bug".equals(category)) {
                    MobGameWebFragment.this.reload();
                }
            }
        };
    }

    @SuppressLint(value={"ValidFragment"})
    public MobGameWebFragment(String url) {
        cachedUrls = new HashMap();
        this.broadcastReceiver = new /* invalid duplicate definition of identical inner class */;
        this.loadUrlWithMobHeaders(url);
    }

    @SuppressLint(value={"ValidFragment"})
    public MobGameWebFragment(String url, int id2) {
        cachedUrls = new HashMap();
        this.broadcastReceiver = new /* invalid duplicate definition of identical inner class */;
        this.loadUrlWithMobHeaders(url);
        this.ntfId = id2;
    }

    @SuppressLint(value={"ValidFragment"})
    public MobGameWebFragment(String url, boolean loadUrlLater, int id2) {
        cachedUrls = new HashMap();
        this.broadcastReceiver = new /* invalid duplicate definition of identical inner class */;
        if (loadUrlLater) {
            this.urlToLoad = url;
        } else {
            this.loadUrlWithMobHeaders(url);
        }
        this.ntfId = id2;
    }

    public static MobGameWebFragment newInstance(String url) {
        Bundle args = new Bundle();
        MobGameWebFragment fragment = new MobGameWebFragment(url);
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_web, container, false);
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            this.mSwipeRefreshLayout = (MobSwipRefreshLayout)view.findViewById(R.id.activity_main_swipe_refresh_layout);
            this.mSwipeRefreshLayout.setColorSchemeResources(new int[]{R.color.green});
            this.getActivity().getWindow().setSoftInputMode(2);
            this.webView = (MobGameWebView)view.findViewById(R.id.webview);
            this.initWebView();
            if (!this.isHideSwipe) {
                this.mSwipeRefreshLayout.setEnabled(true);
                this.mSwipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                    public void onRefresh() {
                        MobGameWebFragment.this.reload();
                        Log.d((String)MobGameWebFragment.this.TAG, (String)("onRefresh: ntf id=" + MobGameWebFragment.this.ntfId));
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", "swipe_refresh");
                        intent.putExtra(MobGameWebFragment.KEY_ID, String.valueOf(MobGameWebFragment.this.ntfId));
                        LocalBroadcastManager.getInstance((Context)MobGameWebFragment.this.getActivity().getApplicationContext()).sendBroadcast(intent);
                    }
                });
            } else {
                this.mSwipeRefreshLayout.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    private void loadUrl(String url) {
        try {
            if (this.isAdded()) {
                this.webView.stopLoading();
                MobGameWebFragment.setCookieToURLWebview(this.webView.getContext(), url);
                this.webView.loadUrl(url);
            } else {
                this.args.putString(KEY_URL, url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadUrlWithMobHeaders(String url) {
        try {
            if (!this.isAdded()) {
                this.args.putString(KEY_URL, url);
                return;
            }
            if (Utils.isPlfUrl(url)) {
                Context context = this.getActivity().getApplicationContext();
                Uri uri = Uri.parse((String)url);
                MobGameWebFragment.setCookieToURLWebview(this.webView.getContext(), url);
                HashMap<String, String> extraHeaders = new HashMap<String, String>();
                String token = AuthenConfigs.getInstance().getAccessToken();
                if (token != null && !TextUtils.isEmpty((CharSequence)token)) {
                    extraHeaders.put("Authorization", "Bearer " + token);
                }
                this.webView.stopLoading();
                this.webView.loadUrl(uri.toString(), extraHeaders);
            } else {
                this.loadUrl(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void postUrl(MUrl url) {
        this.postUrl(url.getPath());
    }

    private void postUrl(String url) {
        try {
            this.webView.postUrl(url, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postUrlWithMobHeaders(String url, HashMap<String, String> postParams) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        this.postUrlWithMobHeaders(url, postParams, null);
    }

    public void postUrlWithMobHeaders(String url, HashMap<String, String> postParams, PostTask.Callback callback) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        MUrl mUrl = cachedUrls.get(url);
        if (mUrl == null) {
            mUrl = new MUrl(url);
        }
        this.postUrlWithMobHeaders(mUrl, postParams, callback);
    }

    public void postUrlWithMobHeaders(MUrl url, HashMap<String, String> postParams) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        this.postUrlWithMobHeaders(url, postParams, null);
    }

    public void postUrlWithMobHeaders(MUrl url, HashMap<String, String> postParams, PostTask.Callback callback) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        if (!this.isAdded()) {
            this.args.putParcelable(KEY_URL, (Parcelable)url);
            this.args.putSerializable(KEY_POST_PARAMS, postParams);
            return;
        }
        if (Utils.isPlfUrl(url)) {
            Uri uri = url.toUri();
            String postUrl = uri.toString();
            String postData = "hl=en";
            for (String key : postParams.keySet()) {
                postData = postData + "&" + key + "=" + URLEncoder.encode(postParams.get(key), "UTF-8");
            }
            MobGameWebFragment.setCookieToURLWebview(this.webView.getContext(), postUrl);
            this.webView.postUrl(postUrl, postData.getBytes());
        } else {
            this.postUrl(url);
        }
    }

    public void reload() {
        try {
            if (this.webView != null) {
                if (this.webView.getUrl() != null) {
                    Log.d((String)this.TAG, (String)("reload: url=" + this.webView.getUrl()));
                    if (this.webView.getUrl().equalsIgnoreCase("data:text/html;charset=utf-8;base64,")) {
                        this.loadUrlWithMobHeaders(this.urlLoadFail);
                    } else {
                        this.webView.reload();
                    }
                } else {
                    Log.d((String)this.TAG, (String)"reload: webview url null, cannot reload!");
                }
            } else {
                Log.d((String)this.TAG, (String)"reload: webview null, cannot reload!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void invokeJavascript(String script) {
        this.webView.loadUrl("javascript:" + script);
    }

    public void stopLoading() {
        this.webView.stopLoading();
    }

    public void goBack() {
        try {
            this.historyBackstack.pop();
            String url = this.historyBackstack.peek();
            if (url.contains("PaymentWallets/showPaymentWallet")) {
                this.historyBackstack.pop();
                url = this.historyBackstack.peek();
            }
            this.loadUrlWithMobHeaders(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean canGoBack() {
        return this.historyBackstack.size() > 1;
    }

    public String getTitle() {
        if (this.webView != null) {
            return this.webView.getTitle();
        }
        return "_";
    }

    public String getUrl() {
        if (this.webView != null) {
            return this.webView.getUrl();
        }
        return "_";
    }

    public WebView getWebView() {
        return this.webView;
    }

    public void setWebViewTag(String tag) {
        try {
            if (this.isAdded()) {
                this.webView.setTag(tag);
            }
            this.args.putString(KEY_WEBVIEW_TAG, tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getWebViewTag() {
        try {
            return this.args.getString(KEY_WEBVIEW_TAG);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "_";
        }
    }

    public int getScrollX() {
        if (this.webView != null) {
            return this.webView.getScrollX();
        }
        Log.d((String)this.TAG, (String)"webview is null");
        return 0;
    }

    public int getScrollY() {
        if (this.webView != null) {
            return this.webView.getScrollY();
        }
        Log.d((String)this.TAG, (String)"webview is null");
        return 0;
    }

    public int computeVerticalScrollRange() {
        return this.webView.computeVerticalScrollRange();
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "JavascriptInterface", "ClickableViewAccessibility"})
    private void initWebView() {
        try {
            this.webView.clearCache(true);
            this.webView.setInitialScale((int)DeviceUtils.getDensity((Context)this.getActivity()));
            this.webView.setBackgroundColor(Color.parseColor((String)"#000000"));
            this.webView.requestFocus(130);
            WebSettings webSettings = this.webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setBuiltInZoomControls(false);
            webSettings.setAllowFileAccess(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setCacheMode(-1);
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
            this.webView.setScrollBarStyle(0);
            webSettings.setDomStorageEnabled(true);
            webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
            webSettings.setUseWideViewPort(true);
            webSettings.setSaveFormData(true);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setLoadsImagesAutomatically(true);
            this.webView.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(WebView view, int progress) {
                    if (MobGameWebFragment.this.eventListener != null) {
                        MobGameWebFragment.this.eventListener.onProgressChanged(view, progress);
                    }
                }
            });
            this.webView.setWebViewClient(new WebViewClient(){

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if (Utils.isPlfUrl(url)) {
                        MobGameWebFragment.this.loadUrlWithMobHeaders(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    String resultCompareUrl;
                    MobGameWebFragment.this.addToBackstack(url);
                    Log.d((String)MobGameWebFragment.this.TAG, (String)("TROI OI : " + url));
                    switch (resultCompareUrl = Utils.getResultCompareUrl(url)) {
                        case "EMAIL_LOGIN": {
                            Log.d((String)MobGameWebFragment.this.TAG, (String)"event name : Login Email");
                            break;
                        }
                    }
                    if (!MobGameWebFragment.this.isHideSwipe) {
                        MobGameWebFragment.this.mSwipeRefreshLayout.setRefreshing(false);
                    }
                    if (MobGameWebFragment.this.eventListener != null) {
                        MobGameWebFragment.this.eventListener.onPageStarted(view, url, favicon);
                    }
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    MobGameWebFragment.this.urlLoadFail = failingUrl;
                    WvUtil.showErrorPage(MobGameWebFragment.this.getContext(), view, failingUrl);
                    if (!MobGameWebFragment.this.isHideSwipe) {
                        MobGameWebFragment.this.mSwipeRefreshLayout.setRefreshing(false);
                    }
                }

                public void onPageFinished(WebView view, String url) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("TITLE_WEBVIEW", view.getTitle() + "");
                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack((Context)MobGameWebFragment.this.getActivity(), "TITLE_WEBVIEW", map);
                    if (MobGameWebFragment.this.eventListener != null) {
                        MobGameWebFragment.this.eventListener.onPageFinished(view, url);
                    }
                }
            });
            this.webView.setOnScrollChangedListener(new MobGameWebView.OnPropertyChangedListener(){

                @Override
                public void onScroll(int l, int t, int oldl, int oldt) {
                    if (MobGameWebFragment.this.eventListener != null) {
                        MobGameWebFragment.this.eventListener.onScrollChanged(MobGameWebFragment.this.webView, l, t, oldl, oldt);
                    }
                }

                @Override
                public void onSizeChanged(int w, int h, int ow, int oh) {
                    if (MobGameWebFragment.this.eventListener != null) {
                        MobGameWebFragment.this.eventListener.onSizeChanged(MobGameWebFragment.this.webView, w, h, ow, oh);
                    }
                }
            });
            this.jsHandler = new JsHandler(this.getActivity(), this);
            this.webView.addJavascriptInterface(this.jsHandler, "JsHandler");
            this.jsHandler.mobAppSDKexecute("mobGetError", "");
            String url = this.args.getString(KEY_URL);
            int id2 = 0;
            id2 = this.args.getInt(KEY_ID);
            HashMap postParams = (HashMap)this.args.getSerializable(KEY_POST_PARAMS);
            String webViewTag = this.args.getString(KEY_WEBVIEW_TAG);
            if (url != null) {
                if (postParams != null) {
                    try {
                        this.postUrlWithMobHeaders(url, (HashMap<String, String>)postParams);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.loadUrlWithMobHeaders(url);
                }
            }
            this.webView.setTag(webViewTag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addToBackstack(String url) {
        try {
            if (url.equalsIgnoreCase("about:blank")) {
                return;
            }
            if (this.historyBackstack.isEmpty()) {
                if (url != null) {
                    this.historyBackstack.push(url);
                }
            } else {
                Uri lastUri = Uri.parse((String)this.historyBackstack.peek());
                Uri uri = Uri.parse((String)url);
                if (lastUri.getPath() == null) {
                    this.historyBackstack.pop();
                    this.addToBackstack(url);
                } else if (!lastUri.getPath().equalsIgnoreCase(uri.getPath()) && url != null) {
                    if (this.isRedirectUrl(url)) {
                        this.historyBackstack.pop();
                    }
                    this.historyBackstack.push(url);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isRedirectUrl(String url) {
        return url.contains("isRedirect=true") || url.contains("isRedirect=1");
    }

    public static void setCookieToURLWebview(Context context, String url) {
        try {
            HashSet cookies = (HashSet)Preference.getStringSet(context, "game_shared_pref_cookies", new HashSet<String>());
            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)context);
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            for (String cookie : cookies) {
                cookieManager.setCookie(url, cookie);
            }
            cookieSyncManager.sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadUrlToLoadIfHave() {
        try {
            if (!this.urlToLoad.isEmpty()) {
                this.loadUrlWithMobHeaders(this.urlToLoad);
                this.urlToLoad = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        super.onPause();
        try {
            Log.d((String)this.TAG, (String)"onPause");
            LocalBroadcastManager.getInstance((Context)this.getActivity()).unregisterReceiver(this.broadcastReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume() {
        super.onResume();
        try {
            Log.d((String)this.TAG, (String)"onResume");
            LocalBroadcastManager.getInstance((Context)this.getActivity()).registerReceiver(this.broadcastReceiver, new IntentFilter("com.mobgame.broadcast"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void onDetach() {
        super.onDestroy();
    }

    public static interface EventListener {
        public void onProgressChanged(WebView var1, int var2);

        public void onPageStarted(WebView var1, String var2, Bitmap var3);

        public void onPageFinished(WebView var1, String var2);

        public void onScrollChanged(WebView var1, int var2, int var3, int var4, int var5);

        public void onSizeChanged(WebView var1, int var2, int var3, int var4, int var5);
    }
}

