package com.game.ads;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;

import com.game.sdk.comon.config.GameConfigs;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mobgame.MobGameHelper;
import com.mobgame.utils.Preference;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.callback.GetListInventoryListener;
import playfun.ads.android.sdk.component.factory.AttachViewService;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.factory.RequestListInventoryId;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.model.networkmodel.DataInventory;

public class AdsPlayFun {

    private static AdsPlayFun INSTANCE;

    public static synchronized AdsPlayFun getInstance() {
        if (INSTANCE == null)
            INSTANCE = new AdsPlayFun();
        return INSTANCE;
    }

    public AdsPlayFun() {

    }

    private static String TAG = AdsPlayFun.class.getSimpleName();

    private RequestListInventoryId getListInventoryId;

    private Context mContext;
    private String mPackageName;
    private String mUserID;
    private String mVersionName;
    private String mVersionCode;
    private String mKeyAds;
    private String mAdvertisingID;
    private Timer timerAsync;
    private RequestAdsFun requestAdsFun;


    public AdsPlayFun(String keyAds, Context context, String mPackageName, String mVersionName, String mVersionCode, String advertisingID) {
        this.mKeyAds = keyAds;
        Preference.save(context , "adskey" , this.mKeyAds);
        this.mContext = context;
        this.mPackageName = mPackageName;
//        this.mUserID = mUserID;
        this.mVersionName = mVersionName;
        this.mVersionCode = mVersionCode;
        this.mAdvertisingID = advertisingID;
        timerAsync = new Timer();

        initAds(mKeyAds);

    }

    GetListInventoryListener listInventoryListener = new GetListInventoryListener() {

        @Override
        public void getListInventoryIdSuccess(List<DataInventory> listDataInventory) {

            Gson gson = new Gson();
            Type listType = new TypeToken<List<DataInventory>>() {
            }.getType();
            String json = gson.toJson(listDataInventory, listType);
            Preference.save(mContext, "LIST_INVENTORY", json);
            Log.d("Tag", "json " + json);
        }

        @Override
        public void getListInventoryIdError(int errorCode, String message) {

        }

        @Override
        public void getListInventoryIdFail() {

        }
    };

    public void initAds(String adsKey) {
        Log.d(TAG, "Go here initAds: " + adsKey);
        getListInventoryId = new RequestListInventoryId.RequestListInventoryIdBuilder()
                .addAdsKey(adsKey)
                .addListener(listInventoryListener)
                .addPackageName(mPackageName)
                .addAdvertisingId(mAdvertisingID)
                .addVersionCode(mVersionCode)
                .addVersionName(mVersionName)
                .build();
        getListInventoryId.getListInventoryId();
    }

    public void showAds(Context mContext , String conditionsType, String conditionsValue, String advertisingID, String isVip) {
        Log.d(TAG , "Goo here");
        String jsonGetListInventory = Preference.getString(mContext, "LIST_INVENTORY");
        showAds(mContext, jsonGetListInventory, conditionsType, conditionsValue, mPackageName, advertisingID, mVersionCode, mVersionName, isVip);

    }

    public void showAds(Context mContext , String jsonGetListInventory, String conditions, String conditionsValue,
                        String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        Gson gson = new Gson();
        Type listType = new TypeToken<List<DataInventory>>() {
        }.getType();
        List<DataInventory> dataInventories = gson.fromJson(jsonGetListInventory, listType);
        for (DataInventory dataInventory : dataInventories) {
            if (dataInventory.getConditions() != null) {
                for (int i = 0; i < dataInventory.getConditions().size(); i++) {
                    if (conditions.equals(dataInventory.getConditions().get(i).getType())) {
                        switch (conditions) {
                            case "level_up":
                                showAdsByLevelupCond(mContext, dataInventory, dataInventory.getConditions().get(i).getValue(),
                                        conditionsValue,
                                        packageName, advertisingID, versionCode, versionName, isVip
                                );
                                break;
                            case "extract_data":
                                if (Boolean.parseBoolean(dataInventory.getConditions().get(i).getValue()))
                                    showAdsByExtractData(
                                            mContext, dataInventory,
                                            packageName, advertisingID, versionCode, versionName, isVip
                                    );
                                break;

                            case "save_character":
                                if (Boolean.parseBoolean(dataInventory.getConditions().get(i).getValue()))
                                    showAdsBySaveCharactor(
                                            mContext, dataInventory,
                                            packageName, advertisingID, versionCode, versionName, isVip
                                    );
                                break;
                            case "period":
                                try {
                                    final int index = i;
                                    new Handler().postDelayed(new Runnable() {
                                        @Override
                                        public void run() {
                                            TimerTask timerTaskAsync = new TimerTask() {
                                                @Override
                                                public void run() {
                                                    showAdsPeriod(mContext,
                                                            dataInventory,
                                                            packageName, advertisingID, versionCode, versionName, isVip
                                                    );
                                                }
                                            };
                                            if(timerAsync != null){

                                            }else {
                                                timerAsync = new Timer();
                                            }
                                            timerAsync.schedule(timerTaskAsync, 0, 1000 * 60 * Integer.parseInt(dataInventory.getConditions().get(index).getValue()));
                                        }
                                    } , 1000 * 60 * Integer.parseInt(dataInventory.getConditions().get(i).getValue()));
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break;
                        }

                    }
                }
            }
        }
    }

    private void showAdsByLevelupCond(Context mContext ,DataInventory dataInventory, String configLevel, String conditionsValue,
                                      String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        try {
            if (configLevel != null && conditionsValue != null) {
                String[] arrLevel = configLevel.split(",");
                for (int j = 0; j < arrLevel.length; j++) {
                    try {
                        String anLevel = arrLevel[j];
                        if (anLevel.equals(conditionsValue)) {
                            showAdsBase(mContext ,dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
                            break;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showAdsByExtractData(Context mContext ,DataInventory dataInventory,
                                      String packageName, String advertisingID, String versionCode, String versionName, String isVip) {

        showAdsBase(mContext ,dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
    }

    private void showAdsBySaveCharactor(Context mContext ,DataInventory dataInventory,
                                      String packageName, String advertisingID, String versionCode, String versionName, String isVip) {

        showAdsBase(mContext ,dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
    }

    private void showAdsPeriod(Context mContext ,DataInventory dataInventory,
                               String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        showAdsBase(mContext ,dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
    }

    public boolean canShowAds = true;
    private void showAdsBase(Context mContext ,DataInventory dataInventory,
                             String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        try {
            AdsFunListener funListener = new AdsFunListener() {
                @Override
                public void reQuestAdsSuccess(Data data, int code) {
                    Log.d("TAG", "reQuestAdsSuccess");
                    //                                                requestAdsFun.showAds();
                    if (data != null) {
                        if (data.getCountdown() != null) {
                            requestAdsFun.showAdsAfterCountdown(data.getCountdown().getValue());
                        } else {
                            AttachViewService attachViewService = new AttachViewService() {
                                @Override
                                public void adShowing() {
                                    canShowAds = false;
                                }

                                @Override
                                public void closeAds() {
                                    canShowAds = true;
                                }
                            };
                            if(canShowAds){
                                requestAdsFun.showAds(data, attachViewService, dataInventory.getCode(), dataInventory.getId());
                            }
                        }
                    }
                }

                @Override
                public void requestAdsNativeSuccess(Data data) {
                    Log.d(TAG, "requestAdsNativeSuccess: ");
                }

                @Override
                public void isShowAds(boolean isShow) {
                    MobGameHelper.hideNotiFloatButton();
                }

                @Override
                public void isCloseAds(boolean isClose) {
                    if (GameConfigs.getInstance().getSdkConfig() != null) MobGameHelper.showNotiFloatButton(GameConfigs.getInstance().getSdkConfig().getEx());
                }

                @Override
                public void isLoadAdsError() {
                    Log.d(TAG, "isLoadAdsError");
                }
            };
            requestAdsFun = new RequestAdsFun.RequestAdsBuilder()
                    .adsCode(dataInventory.getCode())
                    .adsId(dataInventory.getId())
                    .adsKey(Preference.getString(mContext , "adskey"))
                    .of(mContext)
                    .addListener(funListener)
                    .addPakageName(packageName)
                    .addAdsVertisingId(advertisingID)
                    .addVersionCode(1)
                    .addVersionName("1.1.1")
                    .isVip("isVip")
                    .build();

            requestAdsFun.requestAds();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public void onDestroy(){
        Log.d(TAG , "onDestroy FunAds");
        if(timerAsync != null)
            timerAsync.cancel();
    }

}
