/*
 * Decompiled with CFR 0.152.
 */
package com.game.ads;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.game.sdk.comon.config.GameConfigs;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mobgame.MobGameHelper;
import com.mobgame.utils.Preference;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.callback.GetListInventoryListener;
import playfun.ads.android.sdk.component.factory.AttachViewService;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.factory.RequestListInventoryId;
import playfun.ads.android.sdk.component.model.networkmodel.Conditions;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.model.networkmodel.DataInventory;

public class AdsPlayFun {
    private static AdsPlayFun INSTANCE;
    private static String TAG;
    private RequestListInventoryId getListInventoryId;
    private Context mContext;
    private String mPackageName;
    private String mUserID;
    private String mVersionName;
    private String mVersionCode;
    private String mKeyAds;
    private String mAdvertisingID;
    private Timer timerAsync;
    private RequestAdsFun requestAdsFun;
    GetListInventoryListener listInventoryListener = new GetListInventoryListener(){

        public void getListInventoryIdSuccess(List<DataInventory> listDataInventory) {
            Gson gson = new Gson();
            Type listType = new TypeToken<List<DataInventory>>(){}.getType();
            String json = gson.toJson(listDataInventory, listType);
            Preference.save(AdsPlayFun.this.mContext, "LIST_INVENTORY", json);
            Log.d((String)"Tag", (String)("json " + json));
        }

        public void getListInventoryIdError(int errorCode, String message) {
        }

        public void getListInventoryIdFail() {
        }
    };
    public boolean canShowAds = true;

    public static synchronized AdsPlayFun getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AdsPlayFun();
        }
        return INSTANCE;
    }

    public AdsPlayFun() {
    }

    public AdsPlayFun(String keyAds, Context context, String mPackageName, String mVersionName, String mVersionCode, String advertisingID) {
        this.mKeyAds = keyAds;
        Preference.save(context, "adskey", this.mKeyAds);
        this.mContext = context;
        this.mPackageName = mPackageName;
        this.mVersionName = mVersionName;
        this.mVersionCode = mVersionCode;
        this.mAdvertisingID = advertisingID;
        this.timerAsync = new Timer();
        this.initAds(this.mKeyAds);
    }

    public void initAds(String adsKey) {
        Log.d((String)TAG, (String)("Go here initAds: " + adsKey));
        this.getListInventoryId = new RequestListInventoryId.RequestListInventoryIdBuilder().addAdsKey(adsKey).addListener(this.listInventoryListener).addPackageName(this.mPackageName).addAdvertisingId(this.mAdvertisingID).addVersionCode(this.mVersionCode).addVersionName(this.mVersionName).build();
        this.getListInventoryId.getListInventoryId();
    }

    public void showAds(Context mContext, String conditionsType, String conditionsValue, String advertisingID, String isVip) {
        Log.d((String)TAG, (String)"Goo here");
        String jsonGetListInventory = Preference.getString(mContext, "LIST_INVENTORY");
        this.showAds(mContext, jsonGetListInventory, conditionsType, conditionsValue, this.mPackageName, advertisingID, this.mVersionCode, this.mVersionName, isVip);
    }

    public void showAds(final Context mContext, String jsonGetListInventory, String conditions, String conditionsValue, final String packageName, final String advertisingID, final String versionCode, final String versionName, final String isVip) {
        Gson gson = new Gson();
        Type listType = new TypeToken<List<DataInventory>>(){}.getType();
        List dataInventories = (List)gson.fromJson(jsonGetListInventory, listType);
        for (final DataInventory dataInventory : dataInventories) {
            if (dataInventory.getConditions() == null) continue;
            block15: for (int i = 0; i < dataInventory.getConditions().size(); ++i) {
                if (!conditions.equals(((Conditions)dataInventory.getConditions().get(i)).getType())) continue;
                switch (conditions) {
                    case "level_up": {
                        this.showAdsByLevelupCond(mContext, dataInventory, ((Conditions)dataInventory.getConditions().get(i)).getValue(), conditionsValue, packageName, advertisingID, versionCode, versionName, isVip);
                        continue block15;
                    }
                    case "extract_data": {
                        if (!Boolean.parseBoolean(((Conditions)dataInventory.getConditions().get(i)).getValue())) continue block15;
                        this.showAdsByExtractData(mContext, dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
                        continue block15;
                    }
                    case "save_character": {
                        if (!Boolean.parseBoolean(((Conditions)dataInventory.getConditions().get(i)).getValue())) continue block15;
                        this.showAdsBySaveCharactor(mContext, dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
                        continue block15;
                    }
                    case "period": {
                        try {
                            final int index = i;
                            new Handler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    TimerTask timerTaskAsync = new TimerTask(){

                                        @Override
                                        public void run() {
                                            AdsPlayFun.this.showAdsPeriod(mContext, dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
                                        }
                                    };
                                    if (AdsPlayFun.this.timerAsync == null) {
                                        AdsPlayFun.this.timerAsync = new Timer();
                                    }
                                    AdsPlayFun.this.timerAsync.schedule(timerTaskAsync, 0L, (long)(60000 * Integer.parseInt(((Conditions)dataInventory.getConditions().get(index)).getValue())));
                                }
                            }, (long)(60000 * Integer.parseInt(((Conditions)dataInventory.getConditions().get(i)).getValue())));
                            continue block15;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private void showAdsByLevelupCond(Context mContext, DataInventory dataInventory, String configLevel, String conditionsValue, String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        block5: {
            try {
                if (configLevel == null || conditionsValue == null) break block5;
                String[] arrLevel = configLevel.split(",");
                for (int j = 0; j < arrLevel.length; ++j) {
                    try {
                        String anLevel = arrLevel[j];
                        if (!anLevel.equals(conditionsValue)) continue;
                        this.showAdsBase(mContext, dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void showAdsByExtractData(Context mContext, DataInventory dataInventory, String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        this.showAdsBase(mContext, dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
    }

    private void showAdsBySaveCharactor(Context mContext, DataInventory dataInventory, String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        this.showAdsBase(mContext, dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
    }

    private void showAdsPeriod(Context mContext, DataInventory dataInventory, String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        this.showAdsBase(mContext, dataInventory, packageName, advertisingID, versionCode, versionName, isVip);
    }

    private void showAdsBase(Context mContext, final DataInventory dataInventory, String packageName, String advertisingID, String versionCode, String versionName, String isVip) {
        try {
            AdsFunListener funListener = new AdsFunListener(){

                public void reQuestAdsSuccess(Data data, int code) {
                    Log.d((String)"TAG", (String)"reQuestAdsSuccess");
                    if (data != null) {
                        if (data.getCountdown() != null) {
                            AdsPlayFun.this.requestAdsFun.showAdsAfterCountdown(data.getCountdown().getValue().intValue());
                        } else {
                            AttachViewService attachViewService = new AttachViewService(){

                                public void adShowing() {
                                    AdsPlayFun.this.canShowAds = false;
                                }

                                public void closeAds() {
                                    AdsPlayFun.this.canShowAds = true;
                                }
                            };
                            if (AdsPlayFun.this.canShowAds) {
                                AdsPlayFun.this.requestAdsFun.showAds(data, attachViewService, dataInventory.getCode(), dataInventory.getId());
                            }
                        }
                    }
                }

                public void requestAdsNativeSuccess(Data data) {
                    Log.d((String)TAG, (String)"requestAdsNativeSuccess: ");
                }

                public void isShowAds(boolean isShow) {
                    MobGameHelper.hideNotiFloatButton();
                }

                public void isCloseAds(boolean isClose) {
                    if (GameConfigs.getInstance().getSdkConfig() != null) {
                        MobGameHelper.showNotiFloatButton(GameConfigs.getInstance().getSdkConfig().getEx());
                    }
                }

                public void isLoadAdsError() {
                    Log.d((String)TAG, (String)"isLoadAdsError");
                }
            };
            this.requestAdsFun = new RequestAdsFun.RequestAdsBuilder().adsCode(dataInventory.getCode()).adsId(dataInventory.getId()).adsKey(Preference.getString(mContext, "adskey")).of(mContext).addListener(funListener).addPakageName(packageName).addAdsVertisingId(advertisingID).addVersionCode(1).addVersionName("1.1.1").isVip("isVip").build();
            this.requestAdsFun.requestAds();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDestroy() {
        Log.d((String)TAG, (String)"onDestroy FunAds");
        if (this.timerAsync != null) {
            this.timerAsync.cancel();
        }
    }

    static {
        TAG = AdsPlayFun.class.getSimpleName();
    }
}

