package com.mobgame.api;

import android.app.Activity;
import android.content.Context;

import com.appsflyer.AppsFlyerLib;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.Utils;
import com.mobgame.MobGameSDK;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Preference;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashSet;
import java.util.Objects;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class RestfulApi {

    private static final String API_BASE_URL = "https://a.smobgame.com";

    private static RestfulApi INSTANCE;

    private static Retrofit retrofit;

    public static RestfulApi getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestfulApi();
        }
        return INSTANCE;
    }


    private RestfulApi() {
        try {
            OkHttpClient httpClient;
            httpClient = getCommonClient();


            retrofit = new Retrofit.Builder()
                    .baseUrl(API_BASE_URL)
                    .addConverterFactory(GsonConverterFactory.create())
                    .client(httpClient)
                    .build();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    static OkHttpClient getCommonClient() {

        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);

        OkHttpClient httpClient = new OkHttpClient.Builder()
                .addInterceptor(new Interceptor() {
                    @Override
                    public okhttp3.Response intercept(Chain chain) throws IOException {
                        Activity activity = MobGameSDK.activity;
                        Context context = MobGameSDK.getApplicationContext();
                        Request.Builder builder = chain.request()
                                .newBuilder()
                                .addHeader(Constants.MOBGAME_DEVICE, DeviceUtils.getDevice())
                                .addHeader(Constants.MOBGAME_OS, DeviceUtils.getOSInfo())
                                .addHeader(Constants.MOBGAME_RESOLUTION, Objects.requireNonNull(DeviceUtils.getResolution(context)))
                                .addHeader(Constants.MOBGAME_SDK_VERSION, Utils.getSDKVersion(context))
                                .addHeader(Constants.MOBGAME_APPKEY, GameConfigs.getInstance().getAppKey())
                                .addHeader(Constants.MOBGAME_APP_VERSION, Utils.getGameVersion(context))
                                .addHeader(Constants.MOBGAME_APP_VERSION_CODE, Utils.getGameVersionCode(context))
                                .addHeader(Constants.MOBGAME_NETWORK, Utils.getNetwork(context))
                                .addHeader(Constants.MOBGAME_ORIENTATION, DeviceUtils.getScreenOrientation(context) + "")
                                .addHeader(Constants.MOBGAME_REFERRER, Utils.getReferrer(context))
                                .addHeader(Constants.MOBGAME_LANG, DeviceUtils.getLanguage())
                                .addHeader(Constants.MOBGAME_ADVERTISING_ID, DeviceUtils.getAdvertisingID(context))
                                .addHeader(Constants.MOBGAME_APPSFLYER_UNIQUE_ID, DeviceUtils.getAppsflyerUID(context));

                        if (AuthenConfigs.getInstance().getAccessToken() != null) {
                            builder.addHeader(Constants.MOBGAME_TOKEN, AuthenConfigs.getInstance().getAccessToken());
                        }


                        if (AppsFlyerLib.getInstance().getAppsFlyerUID(context) != null) {
                            builder.addHeader(Constants.MOBGAME_APPSFLYER_ID, AppsFlyerLib.getInstance().getAppsFlyerUID(context));
                        }
                        Request request = builder.build();
                        return chain.proceed(request);
                    }
                })
                .addInterceptor(new Interceptor() {
                    @Override
                    public Response intercept(Chain chain) throws IOException {
                        Context c = MobGameSDK.getApplicationContext();
                        Request.Builder builder = chain.request().newBuilder();
                        HashSet<String> preferences = (HashSet<String>) Preference
                                .getStringSet(c, Constants.SHARED_PREF_COOKIES,
                                        new HashSet<String>());
                        for (String cookie : preferences) {
                            builder.addHeader("Cookie", cookie);
                        }

                        return chain.proceed(builder.build());
                    }
                })
                .addInterceptor(new Interceptor() {
                    @Override
                    public Response intercept(Chain chain) throws IOException {
                        Response originalResponse = chain.proceed(chain.request());

                        if (!originalResponse.headers("Set-Cookie").isEmpty()) {
                            Context c = MobGameSDK.getApplicationContext();
                            HashSet<String> cookies = new HashSet<String>();

                            for (String header : originalResponse.headers("Set-Cookie")) {
                                cookies.add(header);
                            }

                            Preference.save(c, Constants.SHARED_PREF_COOKIES, cookies);
                        }

                        return originalResponse;
                    }
                })
                .build();
        return httpClient;
    }


    private interface PlfRestService {


    }


}
