/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.game;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.appsflyer.AppsFlyerLib;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.UserObj;
import com.game.sdk.comon.object.err.SdkConfigErrObj;
import com.game.sdk.comon.object.err.UserErrObj;
import com.game.sdk.comon.object.response.SdkConfigResponseObj;
import com.game.sdk.comon.object.response.UserResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.AdjustTracking;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.ToastUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.login.ILoginPresenter;
import com.game.sdk.ui.login.LoginPresenterImpl;
import com.mobgame.MobGameSDK;
import com.mobgame.R;

public class LifeCycleActivity
implements BaseView {
    public static LifeCycleActivity mobGameActivity;
    Activity activity;
    boolean isFirstLauch = true;
    ILoginPresenter loginPresenter;

    public static LifeCycleActivity getInstance(Activity activity) {
        if (mobGameActivity == null) {
            mobGameActivity = new LifeCycleActivity(activity);
        }
        return mobGameActivity;
    }

    public LifeCycleActivity(Activity activity) {
        this.activity = activity;
        this.loginPresenter = new LoginPresenterImpl(this);
    }

    public void onCreate() {
        if (GameConfigs.getInstance().getUser() != null && GameConfigs.getInstance().isLogin()) {
            this.loginPresenter.getUser();
        } else {
            this.isFirstLauch = false;
        }
    }

    public void onStart() {
    }

    public void onResume() {
        if (this.isFirstLauch) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)PrefManager.getAccessToken((Context)this.activity))) {
            this.loginPresenter = new LoginPresenterImpl(this);
            this.loginPresenter.getUser();
        }
    }

    public void onPause() {
    }

    public void onStop() {
    }

    public void onDestroy() {
    }

    public void onWindowFocusChanged(boolean hasFocus) {
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    }

    @Override
    public void showProgress(String mess) {
        Utils.showLoading(this.activity, true);
    }

    @Override
    public void hideProgress() {
        Utils.showLoading(this.activity, false);
    }

    public void success(Object x) {
        if (x instanceof UserResponseObj) {
            UserObj obj = ((UserResponseObj)x).getData();
            GameConfigs.getInstance().setUser(obj);
            if (this.isFirstLauch) {
                this.loginPresenter.getSdkConfig();
            }
            LogUtils.d("LifeCycleActivity", "User valid");
        } else if (x instanceof SdkConfigResponseObj) {
            try {
                this.isFirstLauch = false;
                SdkConfigResponseObj obj = (SdkConfigResponseObj)x;
                GameConfigs.getInstance().setSdkConfig(obj.getData());
                if (obj != null && obj.getData() != null && obj.getData().getMaintenance() != null && !TextUtils.isEmpty((CharSequence)obj.getData().getMaintenance().getUrl())) {
                    TrackingUtil.getInstance().trackMaintainScreenOpened();
                    AdjustTracking.getInstance().trackMaintainScreenOpened();
                    MobGameSDK.getInstance().getQueuePopups().add("pop_maintain");
                    MobGameSDK.getInstance().showPopup();
                    return;
                }
                AppsFlyerLib.getInstance().setCustomerUserId(GameConfigs.getInstance().getUser().getId() + "");
                GameSdk.getInstance().onLoginSuccess(this.activity, "login");
                LogUtils.d("LifeCycleActivity", "get game info success");
            }
            catch (Exception e) {
                LogUtils.d("LifeCycleActivity", e.getMessage());
            }
        }
    }

    public void error(Object o) {
        if (o instanceof UserErrObj) {
            UserErrObj obj = (UserErrObj)o;
            if (obj.getStatus() == 401) {
                DialogUtils.showExpireDialog(this.activity);
            } else {
                if (obj.getStatus() == -100) {
                    ToastUtils.showErrToast((Context)this.activity, this.activity.getString(R.string.error_network));
                }
                DialogUtils.showRetryDialog(this.activity, obj.getMessage(), new DialogUtils.Listener(){

                    @Override
                    public void onRetry() {
                        LifeCycleActivity.this.onResume();
                    }
                });
            }
        } else if (o instanceof SdkConfigErrObj) {
            SdkConfigErrObj obj = (SdkConfigErrObj)o;
            if (obj.getStatus() == 401) {
                DialogUtils.showExpireDialog(this.activity);
            } else if (obj.getStatus() == -100) {
                DialogUtils.showRetryDialog(this.activity, this.activity.getString(R.string.error_network), new DialogUtils.Listener(){

                    @Override
                    public void onRetry() {
                        LoginPresenterImpl loginPresenter = new LoginPresenterImpl(LifeCycleActivity.this);
                        loginPresenter.getSdkConfig();
                    }
                });
            } else {
                DialogUtils.showRetryDialogWithLogOut(this.activity, obj.getMessage(), new DialogUtils.Listener(){

                    @Override
                    public void onRetry() {
                        LoginPresenterImpl loginPresenter = new LoginPresenterImpl(LifeCycleActivity.this);
                        loginPresenter.getSdkConfig();
                    }
                });
            }
        }
    }
}

