package com.game.sdk.comon.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;
import android.view.View;

import com.adjust.sdk.Adjust;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustEvent;
import com.appsflyer.AFInAppEventParameterName;
import com.appsflyer.AFInAppEventType;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerTrackingRequestListener;
import com.game.ads.AdsPlayFun;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.constants.ConstantAppsFyer;
import com.game.sdk.comon.constants.ConstantTrackEvent;
import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.VerifyPurchaseObj;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.mobgame.R;

import java.util.HashMap;
import java.util.Map;

import playfun.ads.android.sdk.component.util.Preference;

/**
 * @author dungnv
 */
public class AdjustTracking {
    public static String TAG = AdjustTracking.class.getName();

    private Context context;
    private String  app_token="h6lq7hw6ul8g";
    private String environment= AdjustConfig.ENVIRONMENT_PRODUCTION;
    private AdjustEvent event;
    private Firebase firebase;
    private long beginTime;
    private static AdjustTracking trackingUtil;
    //
    public void init(Application application) {
        context = application;
        firebase = Firebase.newInstance(application);
        AdjustUtil.init(application,app_token,environment);
    }

    public static AdjustTracking getInstance() {
        if (trackingUtil == null) {
            trackingUtil = new AdjustTracking();
        }
        return trackingUtil;
    }
    public void trackEvent(String event1, String track){
        LogUtils.d(TAG, track);
        AdjustEvent event= new AdjustEvent(event1);
        event.setCallbackId(track);
        Adjust.trackEvent(event);
    }

    /**
     * Lần đầu user mở game (mỗi install count 1 lần)
     */
    public void trackFirstLaunch() {
        event= new AdjustEvent(context.getString(R.string.ft_first_launched));
        beginTime = System.currentTimeMillis();
        event.addCallbackParameter("time_first_launcher",String.valueOf(beginTime));
        trackEvent(context.getString(R.string.ft_first_launched),ConstantTrackEvent.TRACK_FIRST_LAUNCH);
    }

    /**
     * User mở game or quay lại game
     */
    public void trackAppLaunch() {
        beginTime = System.currentTimeMillis();
        trackEvent(context.getString(R.string.ft_app_launched),ConstantTrackEvent.STR_EVENT_LAUNCHER);
    }

//    public void trackFromWeb(String label, String value) {
//        HashMap<String, Object> map = new HashMap<>();
//        map.put("TYPE_LOGIN", value);
//        trackEvent(label, map);
//    }

    /**
     * Logout thành công trên SDK
     *
     * @param userId
     */
    public void trackLogoutSuccess(int userId) {
        event= new AdjustEvent(context.getString(R.string.ft_logout_success));
        event.addCallbackParameter("ft_user_id", String.valueOf(userId));
        trackEvent(context.getString(R.string.ft_logout_success),ConstantTrackEvent.TRACK_LOGOUT_SUCCESS);

    }

    /**
     * User kill app
     */
    public void trackAppClose() {
        trackEvent(context.getString(R.string.ft_app_close),ConstantTrackEvent.TRACK_APP_CLOSE);

    }

    /**
     * Log các info liên quan tới in-app purchase (request gói nạp lỗi, pay lỗi ....)
     */
    public void trackPurchaseLog() {
        trackEvent(context.getString(R.string.ft_purchase_log),ConstantTrackEvent.TRACK_PURCHASE_LOG);

    }

    /**
     * Game Khi load màn hình payment thành công
     */
    public void trackPaymentScreenOpened() {
        event= new AdjustEvent(context.getString(R.string.ft_payment_screen_opened));
        String character_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.ROLE_ID, "");
        String area_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.AREA_ID, "");
        String user_id = "";
        try {
            user_id += GameConfigs.getInstance().getUser().getId();
        } catch (Exception e) {
            e.printStackTrace();
        }
        event.addCallbackParameter("ft_user_id",user_id);
        event.addCallbackParameter("ft_role_id",character_id);
        event.addCallbackParameter("ft_area_id",area_id);
        trackEvent(context.getString(R.string.ft_payment_screen_opened),ConstantTrackEvent.TRACK_LOAD_PAYMENT_SCREEN_OPENED);
    }

    /**
     * Game Khi load màn hình payment thành công
     */
    public void trackPaymentLoadScreenSuccess() {
        event= new AdjustEvent(context.getString(R.string.ft_payment_screen_load_success));
        String character_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.ROLE_ID, "");
        String area_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.AREA_ID, "");
        String user_id = "";
        try {
            user_id += GameConfigs.getInstance().getUser().getId();
        } catch (Exception e) {
            e.printStackTrace();
        }
        event.addCallbackParameter("ft_user_id",user_id);
        event.addCallbackParameter("ft_role_id",character_id);
        event.addCallbackParameter("ft_area_id",area_id);
        trackEvent(context.getString(R.string.ft_payment_screen_load_success),ConstantTrackEvent.TRACK_LOAD_PAYMENT_SCREEN_SUCEESS);
    }

    /**
     * Game Khi load màn hình payment Fail
     */
    public void trackPaymentLoadScreenFail(String error_code, String error_message) {
        event= new AdjustEvent(context.getString(R.string.ft_payment_screen_load_fail));
        String character_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.ROLE_ID, "");
        String area_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.AREA_ID, "");
        String user_id = "";
        try {
            user_id += GameConfigs.getInstance().getUser().getId();
        } catch (Exception e) {
            e.printStackTrace();
        }

        event.addCallbackParameter("ft_user_id",user_id);
        event.addCallbackParameter("ft_role_id",character_id);
        event.addCallbackParameter("ft_area_id",area_id);
        event.addCallbackParameter("error_code",error_code);
        event.addCallbackParameter("error_message",error_message);
        trackEvent(context.getString(R.string.ft_payment_screen_load_fail),ConstantTrackEvent.TRACK_LOAD_PAYMENT_SCREEN_FAILED);
    }


    /**
     * Game Khi load màn hình payment thành công
     */
    public void trackPaymentBeforVerify(String order_no) {
        event= new AdjustEvent(context.getString(R.string.ft_payment_before_verify));
        String character_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.ROLE_ID, "");
        String area_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.AREA_ID, "");
        String user_id = "";
        long currentTime = System.currentTimeMillis();
        try {
            user_id += GameConfigs.getInstance().getUser().getId();
        } catch (Exception e) {
            e.printStackTrace();
        }
        event.addCallbackParameter("ft_user_id",user_id);
        event.addCallbackParameter("ft_role_id",character_id);
        event.addCallbackParameter("ft_area_id",area_id);
        event.addCallbackParameter("order_no",order_no);
        event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        trackEvent(context.getString(R.string.ft_payment_before_verify),ConstantTrackEvent.TRACK_PAYMENT_BEFOR_VERIFY);
    }


    /**
     * Game Khi load màn hình payment thành công
     */
    public void trackPaymentVerifySuccess(VerifyPurchaseObj obj) {
            event = new AdjustEvent(context.getString(R.string.af_purchase));
            try {
                HashMap<String, Object> hashMap = new HashMap<>();
                String character_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.ROLE_ID, "");
                String area_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.AREA_ID, "");
                String user_id = "";
                long currentTime = System.currentTimeMillis();
                long startCall = PrefManager.getLong(GameSdk.getInstance().getApplication(), ConstantTrackEvent.TRACK_PAYMENT_BEFOR_VERIFY, currentTime);
                long deta_call = currentTime - startCall;
                try {
                    user_id += GameConfigs.getInstance().getUser().getId();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                event.addCallbackParameter("ft_user_id", user_id);
                event.addCallbackParameter("ft_role_id", character_id);
                event.addCallbackParameter("ft_area_id", area_id);
                event.addCallbackParameter("order_no", obj.getOrder_no());
                event.addCallbackParameter("timestamp", String.valueOf(currentTime));
                event.addCallbackParameter("delta_call", String.valueOf(deta_call));
                double price = 0.01 * obj.getPlatform_price();
                event.addCallbackParameter("revenue", String.valueOf(price));
                event.addCallbackParameter("content_type", "category_rev");
                event.addCallbackParameter("content_id", "123456");
                event.addCallbackParameter("currency", "USD");
                event.addCallbackParameter("order_id", obj.getOrder_no());
                event.setRevenue(price, "USD");
                event.setOrderId(obj.getOrder_no());
                trackEvent(context.getString(R.string.af_purchase), ConstantTrackEvent.TRACK_PURCHASE);
            } catch (Exception e) {
                e.printStackTrace();
            }
    }
    /**
     * Game Khi load màn hình payment thành công
     */
    public void trackPaymentVerifyFail(String order_no, String type_error, String err_code, String err_mesage){
            event= new AdjustEvent(context.getString(R.string.ft_payment_screen_load_fail));
            String character_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.ROLE_ID, "");
            String area_id = PrefManager.getString(GameSdk.getInstance().getApplication(), com.game.sdk.comon.constants.Constants.AREA_ID, "");
            String user_id = "";
            long currentTime = System.currentTimeMillis();
            long startCall = PrefManager.getLong(GameSdk.getInstance().getApplication(), ConstantTrackEvent.TRACK_PAYMENT_BEFOR_VERIFY, currentTime);
            long deta_call = currentTime - startCall;
            try {
                user_id += GameConfigs.getInstance().getUser().getId();
            } catch (Exception e) {
                e.printStackTrace();
            }
            event.addCallbackParameter("ft_user_id",user_id);
            event.addCallbackParameter("ft_role_id",character_id);
            event.addCallbackParameter("ft_area_id",area_id);
            event.addCallbackParameter("order_no",order_no);
            event.addCallbackParameter("type_error",type_error);
            event.addCallbackParameter("timestamp", String.valueOf(currentTime));
            event.addCallbackParameter("delta_call", String.valueOf(deta_call));
            event.addCallbackParameter("error_code", err_code);
            event.addCallbackParameter("error_message", err_mesage);
            trackEvent(context.getString(R.string.ft_payment_screen_load_fail),ConstantTrackEvent.TRACK_LOAD_PAYMENT_SCREEN_FAILED);
    }


    /**
     * Game bắt đầu giải nén resources trong bản build or OBB
     */
    public void trackStartExtractData(Activity activity) {
        event= new AdjustEvent(context.getString(R.string.ft_extract_started));
        Log.d(TAG, "trackStartExtractData: ");
        AdsPlayFun.getInstance().showAds(activity, "extract_data", "" , DeviceUtils.getAdvertisingID(activity) == null ? "" : DeviceUtils.getAdvertisingID(activity), "");


        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        event.addCallbackParameter("delta",String.valueOf(delta));
        event.addCallbackParameter("timestamp",String.valueOf(currentTime));
        trackEvent(context.getString(R.string.ft_extract_started), ConstantTrackEvent.TRACK_EXTRACT_STARTED);

//        //TODO sao đoạn này em lại đặt là level_up ?
    }

    /**
     * Game kết thúc giải nén trong bản build or OBB
     */
    public void trackFinishExtractData() {
        event= new AdjustEvent(context.getString(R.string.ft_extract_finished));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        event.addCallbackParameter("timestamp",String.valueOf(currentTime));
        event.addCallbackParameter("delta",String.valueOf(delta));
        event.addCallbackParameter("delta_extract",String.valueOf(PrefManager.getLong(context,ConstantTrackEvent.START_TIME,currentTime)));
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME, 0);
        trackEvent(context.getString(R.string.ft_extract_finished),ConstantTrackEvent.TRACK_EXTRACT_FINISHED);
    }

    /**
     * Game bắt đầu tải resources từ CDN
     * Chỉ track ở giai đoạn đầu của game (trước khi vào server), còn tải trong lúc đã chơi game thì ko track
     */
    public void trackDownloadResourceStarted() {
        event= new AdjustEvent(context.getString(R.string.ft_resource_started));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        event.addCallbackParameter("delta",String.valueOf(delta));
        event.addCallbackParameter("timestamp",String.valueOf(currentTime));
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME, currentTime);
        trackEvent(context.getString(R.string.ft_resource_started),ConstantTrackEvent.TRACK_DOWNLOAD_RES_STARTED);
    }

    /**
     * Game bắt đầu tải resources từ CDN
     * Chỉ track ở giai đoạn đầu của game (trước khi vào server), còn tải trong lúc đã chơi game thì ko track
     */
    public void trackDownloadResourceFinished() {

        event= new AdjustEvent(context.getString(R.string.ft_resource_finished));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        event.addCallbackParameter("delta", String.valueOf(delta));
        event.addCallbackParameter("delta_extract", String.valueOf(PrefManager.getLong(context, ConstantTrackEvent.START_TIME, currentTime)));
        PrefManager.saveSetting(GameSdk.getInstance().getApplication(), ConstantTrackEvent.TRACK_DOWNLOAD_RES_FINISHED, currentTime);
        trackEvent(context.getString(R.string.ft_resource_finished),ConstantTrackEvent.TRACK_DOWNLOAD_RES_FINISHED);
    }

    /**
     * Game kết giải nén resources tải từ CDN
     */
    public void trackExtractCDNFinished(Activity activity) {
        AdsPlayFun.getInstance().showAds(activity, "extract_data", "" , DeviceUtils.getAdvertisingID(activity) == null ? "" : DeviceUtils.getAdvertisingID(activity), "");

        event= new AdjustEvent(context.getString(R.string.ft_extract_cdn_finished));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        long delta_resource = currentTime - PrefManager.getLong(GameSdk.getInstance().getApplication(), ConstantTrackEvent.TRACK_DOWNLOAD_RES_FINISHED, currentTime);
        event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        event.addCallbackParameter("delta", String.valueOf(delta));
        event.addCallbackParameter("delta_resource", String.valueOf(delta_resource));
        event.setCallbackId("ft_extract_cdn_finished");
        trackEvent(context.getString(R.string.ft_extract_cdn_finished),ConstantTrackEvent.TRACK_EXTRACT_CDN_FINISH);
    }

    /**
     * Track session (time bắt đầu, time kết thúc, kéo dài bao nhiêu)
     */
    public void trackSession() {
        event= new AdjustEvent(context.getString(R.string.ft_session));
        long endTime = System.currentTimeMillis();
        long deltaTime = endTime - beginTime;
        event.addCallbackParameter("ft_start_time", String.valueOf(beginTime));
        event.addCallbackParameter("ft_end_time ", String.valueOf(endTime));
        event.addCallbackParameter("ft_length_second", String.valueOf(deltaTime));
        trackEvent(context.getString(R.string.ft_session),ConstantTrackEvent.TRACK_FT_SESSION);
    }

    public void trackLastSession(Context ct) {
        event= new AdjustEvent(context.getString(R.string.ft_session));
        int minute = PrefManager.getInt(ct, Constants.SESSION_OUT_TIME, 10);
        long milisecond = minute * 60 * 1000;

        long begin = PrefManager.getLong(ct, ConstantTrackEvent.LAST_SESSION_START, 0);
        long endTime = PrefManager.getLong(ct, ConstantTrackEvent.LAST_SESSION_END, 0);
        long deltaTime = PrefManager.getLong(ct, ConstantTrackEvent.LAST_SESSION_DETAl, 0);
        // Validate last sesion data
        if (begin == 0 || endTime == 0)
            return;
        if (deltaTime < milisecond)
            return;
        if ((beginTime - endTime) < milisecond) {
            beginTime = begin;
            return;
        }
        LogUtils.d(TAG, "Begin: " + begin + " - End : " + endTime + " - Detal : " + deltaTime
        );
        HashMap<String, Object> hashMap = new HashMap<>();
        event.addCallbackParameter("ft_start_time", String.valueOf(begin));
        event.addCallbackParameter("ft_end_time ", String.valueOf(endTime));
        event.addCallbackParameter("ft_length_second", String.valueOf(deltaTime));
        trackEvent(context.getString(R.string.ft_session),ConstantTrackEvent.TRACK_FT_SESSION);
        clearSession(ct);
    }

    public void saveSession(Context ct) {
        long endTime = System.currentTimeMillis();
        long deltaTime = endTime - beginTime;
        PrefManager.saveSetting(ct, context.getString(R.string.LAST_SESSION_START), beginTime);
        PrefManager.saveSetting(ct, context.getString(R.string.LAST_SESSION_END), endTime);
        PrefManager.saveSetting(ct, context.getString(R.string.LAST_SESSION_DETAl), deltaTime);
    }

    public void clearSession(Context ct) {
        PrefManager.saveSetting(ct, context.getString(R.string.LAST_SESSION_START), 0);
        PrefManager.saveSetting(ct, context.getString(R.string.LAST_SESSION_END), 0);
        PrefManager.saveSetting(ct, context.getString(R.string.LAST_SESSION_DETAl), 0);
    }

    /**
     * Login/register thành công trên SDK
     *
     * @param userId              user id
     * @param type                login success | register success
     * @param loginOrRegisterType email | playnow | facebook | google | apple ...
     */
    public void trackLoginSuccess(int userId, String type, String
            loginOrRegisterType) {
        event= new AdjustEvent(context.getString(R.string.af_login));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        long start_open_login = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, currentTime);
        long deta_login = currentTime - start_open_login;
        event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        event.addCallbackParameter("delta", String.valueOf(delta));
        event.addCallbackParameter("delta_login", String.valueOf(deta_login));
        event.addCallbackParameter("ft_user_id", String.valueOf(userId));
        event.addCallbackParameter("ft_type", type);
        event.addCallbackParameter("ft_login_or_register_type", loginOrRegisterType);
        trackEvent(context.getString(R.string.af_login),ConstantTrackEvent.TRACK_AF_LOGIN);
    }

    /**
     * trackClickBtnEnterGame (time bắt đầu, time kết thúc, kéo dài bao nhiêu)
     * User click button vào game (tùy từng game mà tên khác nhau) để chuyển sang màn hình game
     *
     * @param serverId Id server that user login
     */
    public void trackClickBtnEnterGame(int serverId) {
        event= new AdjustEvent(context.getString(R.string.ft_enter_game_btn_clicked));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        event.addCallbackParameter("delta", String.valueOf(delta));
        event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        event.addCallbackParameter("ft_server_id", String.valueOf(serverId));
        event.addCallbackParameter("ft_server_id", String.valueOf(serverId));
        trackEvent(context.getString(R.string.ft_enter_game_btn_clicked),ConstantTrackEvent.TRACK_CLICK_BTN_ENTER_GAME);
    }

    /**
     * User tạo nhân vật or chọn nhân vật trong game thành công.
     *
     * @param user_id
     * @param role_id mã nhân vật
     * @param area_id Game save area id (mã server)
     */
    public void trackCharactorCreated(Activity activity, int user_id, String role_id, String area_id) {


        event= new AdjustEvent(context.getString(R.string.ft_character_created));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        event.addCallbackParameter("delta",String.valueOf(delta));
        event.addCallbackParameter("timestamp",String.valueOf(currentTime));
        event.addCallbackParameter("ft_user_id",String.valueOf(user_id));
        event.addCallbackParameter("ft_role_id",role_id);
        event.addCallbackParameter("ft_area_id",area_id);
        trackEvent(context.getString(R.string.ft_character_created),ConstantTrackEvent.TRACK_CHARACTER_CREATED);

    }

    /**
     * SDK save area id & role id lên Funtap server thành công
     *
     * @param user_id
     * @param role_id mã nhân vật
     * @param area_id Game save area id (mã server)
     */
    public void trackCharactorCreatedSuccess(int user_id, String role_id, String area_id) {
        event= new AdjustEvent(context.getString(R.string.ft_character_created_call_api_success));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        event.addCallbackParameter("delta", String.valueOf(delta));
        event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        event.addCallbackParameter("ft_role_id", role_id);
        event.addCallbackParameter("ft_area_id", area_id);
        trackEvent(context.getString(R.string.ft_character_created_call_api_success),ConstantTrackEvent.TRACK_CHARACTER_CREATED_SUCCESS);
    }

    /**
     * SDK save area id & role id lên Funtap server thất bại
     *
     * @param user_id
     * @param role_id mã nhân vật
     * @param area_id Game save area id (mã server)
     */
    public void trackCharactorCreatedFailed(int user_id, String role_id, String area_id) {
        event= new AdjustEvent(context.getString(R.string.ft_character_created_call_api_fail));
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - beginTime;
        event.addCallbackParameter("delta", String.valueOf(delta));
        event.addCallbackParameter("timestamp", String.valueOf(currentTime));
        event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        event.addCallbackParameter("ft_role_id", role_id);
        event.addCallbackParameter("ft_area_id", area_id);
        trackEvent(context.getString(R.string.ft_character_created_call_api_fail),ConstantTrackEvent.TRACK_CHARACTER_CREATED_FAIL);
    }

    /**
     * User hoàn thành hướng dẫn tân thủ.
     * Được quyết định khi user đạt mốc level X. Level X config động với mỗi game và được trả về từ Funtap server
     *
     * @param user_id
     * @param role_id mã nhân vật
     * @param area_id Game save area id (mã server)
     */
    public void trackTutorialCompletion(int user_id, String role_id, String area_id) {
        event= new AdjustEvent(context.getString(R.string.af_tutorial_completion));
        event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        event.addCallbackParameter("ft_role_id", role_id);
        event.addCallbackParameter("ft_area_id", area_id);
        trackEvent(context.getString(R.string.af_tutorial_completion),ConstantTrackEvent.TRACK_TUTORIAL_COMPLETION);
    }

    /**
     * Nhân vật trong game lên level
     *
     * @param user_id
     * @param role_id mã nhân vật
     * @param area_id Game save area id (mã server)
     */
    public void trackLevelAchieved(Activity activity, int user_id, String role_id, String area_id, String af_level) {

        AdsPlayFun.getInstance().showAds(activity, "level_up", af_level, DeviceUtils.getAdvertisingID(activity) == null ? "" : DeviceUtils.getAdvertisingID(activity), "");
        event= new AdjustEvent(context.getString(R.string.af_level_achieved));
        event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        event.addCallbackParameter("ft_role_id", role_id);
        event.addCallbackParameter("ft_area_id", area_id);
        event.addCallbackParameter("af_level ", af_level);
        trackEvent(context.getString(R.string.af_level_achieved),ConstantTrackEvent.TRACK_LEVEL_ACHIEVED);

    }


    /**
     * Nhân vật trong game lên cấp VIP
     *
     * @param user_id
     * @param role_id mã nhân vật
     * @param area_id Game save area id (mã server)
     */
    public void trackVipAchieved(int user_id, String role_id, String area_id, String ft_vip) {
        event= new AdjustEvent(context.getString(R.string.ft_vip_achieved));
        event.addCallbackParameter("ft_user_id", String.valueOf(user_id));
        event.addCallbackParameter("ft_role_id", role_id);
        event.addCallbackParameter("ft_area_id", area_id);
        event.addCallbackParameter("ft_vip", ft_vip);
        trackEvent(context.getString(R.string.ft_vip_achieved),ConstantTrackEvent.TRACK_VIP_ACHIEVED);
    }


    /**
     * Mở màn hình login của SDK
     */
    public void trackLoginScreenOpen() {
        event= new AdjustEvent(context.getString(R.string.ft_login_screen_opened));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        event= new AdjustEvent(context.getString(R.string.ft_login_screen_opened));
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        trackEvent(context.getString(R.string.ft_login_screen_opened),ConstantTrackEvent.TRACK_FORM_LOGIN_OPENED);
    }


    /**
     * user có tác động vào màn hình login (click 1 trong các nút login: email | facebook | google | playnow | apple | ....)
     *
     * @param btnTitle (email, facebook, playnow, google, apple)
     */
    public void trackClickLoginButton(String btnTitle) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_btn_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("ft_button_title", btnTitle);
        trackEvent(context.getString(R.string.ft_ls_login_btn_clicked),ConstantTrackEvent.TRACK_CLICK_BTN_LOGIN);
    }


    /**
     * user tác động vào placeholder login email / phone number / username
     */
    public void trackClickLoginEmailButton() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_email_btn_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_email_btn_clicked),ConstantTrackEvent.TRACK_CLICK_BTN_LOGIN_EMAIL);
    }

    //---------------------------------------------------------------EMAIL----------------------------------------------------------------

    /**
     * user ko pass qua valid form login email của sdk
     *
     * @param errCode    mã lỗi code (1: username, 2: password)
     * @param errMessage nội dung lỗi
     */
    public void trackLoginEmailInputError(int errCode, String
            errMessage) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_email_input_error));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("error_code", String.valueOf(errCode));
        event.addCallbackParameter("error_message", errMessage);
        trackEvent(context.getString(R.string.ft_ls_login_email_input_error),ConstantTrackEvent.TRACK_LOGIN_EMAIL_INPUT_ERR);
    }

    /**
     * sdk call api login email
     */
    public void trackLoginEmailCallApi() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_email_api_call));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_email_api_call),ConstantTrackEvent.TRACK_LS_LOGIN_EMAIL_CALL_API);
    }

    /**
     * sdk call api login email - thành công
     */
    public void trackLoginEmailCallApiSuccess() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_email_api_call_success));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, context.getString(R.string.BEGIN_ACTION_LOGIN_TIME), current);
        long startTimeCallApi = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        trackEvent(context.getString(R.string.ft_ls_login_email_api_call_success),ConstantTrackEvent.TRACK_LS_LOGIN_EMAIL_CALL_API_SUCCESS);
    }


    /**
     * sdk call api login email - Thất bại
     *
     * @param errCode mã lỗi code
     * @param mess    Nội dung lỗi
     */
    public void trackLoginEmailCallApiFail(int errCode, String mess) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_email_api_call_fail));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        long startTimeCallApi = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        event.addCallbackParameter("error_code", String.valueOf(errCode));
        event.addCallbackParameter("error_message", mess);
        trackEvent(context.getString(R.string.ft_ls_login_email_api_call_fail),ConstantTrackEvent.TRACK_LS_LOGIN_EMAIL_CALL_API_FAIL);
    }

    //---------------------------------------------------------------FACEBOOK----------------------------------------------------------------

    /**
     * user click nút login facebook
     */
    public void trackClickLoginFacebookButton() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_facebook_btn_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_facebook_btn_clicked),ConstantTrackEvent.TRACK_LS_CLICK_BTN_LOGIN_FACEBOOK);
    }

    /**
     * user cancel login trên facebook sdk (app, webview của facebook)s
     */
    public void trackCancelLoginFacebook() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_facebook_user_canceled));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_facebook_user_canceled),ConstantTrackEvent.TRACK_LS_LOGIN_FACEBOOK_CANCEL);
    }

    /**
     * user login trên facebook và có thông báo lỗi từ Facebook về SDK
     *
     * @param mess nội dung lỗi
     */
    public void trackLoginFacebookSdkErr(String mess) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_facebook_have_error));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("error_message", mess);
        trackEvent(context.getString(R.string.ft_ls_login_facebook_have_error),ConstantTrackEvent.TRACK_LS_LOGIN_FACEBOOK_ERR);
    }


    /**
     * sdk call api login facebook
     */
    public void trackLoginFacebookCallApi() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_facebook_api_call));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_facebook_api_call),ConstantTrackEvent.TRACK_LS_LOGIN_FACEBOOK_CALL_API);
    }

    /**
     * sdk call api login facebook - thành công
     */
    public void trackLoginFacebookCallApiSuccess() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_facebook_api_call_success));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        long startTimeCallApi = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        trackEvent(context.getString(R.string.ft_ls_login_facebook_api_call_success),ConstantTrackEvent.TRACK_LS_LOGIN_FACEBOOK_CALL_API_SUCCESS);
    }


    /**
     * sdk call api login facebook - Thất bại
     *
     * @param errCode mã lỗi code
     * @param mess    Nội dung lỗi
     */
    public void trackLoginFacebookCallApiFail(int errCode, String mess) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_facebook_api_call_fail));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        long startTimeCallApi = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        event.addCallbackParameter("error_code", String.valueOf(errCode));
        event.addCallbackParameter("error_message", mess);
        trackEvent(context.getString(R.string.ft_ls_login_facebook_api_call_fail),ConstantTrackEvent.TRACK_LS_LOGIN_FACEBOOK_CALL_API_FAIL);
    }

    //---------------------------------------------------------------GOOGLE----------------------------------------------------------------

    /**
     * user click nút login Google
     */
    public void trackClickLoginGoogleButton() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_google_btn_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_google_btn_clicked),ConstantTrackEvent.TRACK_LS_CLICK_BTN_LOGIN_GOOGLE);
    }

    /**
     * user cancel login trên Google sdk (app, webview của facebook)s
     */
    public void trackCancelLoginGoogle() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_google_user_canceled));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_google_user_canceled),ConstantTrackEvent.TRACK_LS_LOGIN_GOOGLE_CANCEL);
    }

    /**
     * user login trên facebook và có thông báo lỗi từ Google về SDK
     *
     * @param mess    nội dung lỗi
     * @param errCode mã lỗi code
     */
    public void trackLoginGoogleSdkErr(int errCode, String mess) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_google_have_error));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("error_code", String.valueOf(errCode));
        event.addCallbackParameter("error_message", mess);
        trackEvent(context.getString(R.string.ft_ls_login_google_have_error),ConstantTrackEvent.TRACK_LS_LOGIN_GOOGLE_ERR);
    }


    /**
     * sdk call api login Google
     */
    public void trackLoginGoogleCallApi() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_google_api_call));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_google_api_call),ConstantTrackEvent.TRACK_LS_LOGIN_GOOGLE_CALL_API);
    }

    /**
     * sdk call api login Google - thành công
     */
    public void trackLoginGoogleCallApiSuccess() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_google_api_call_success));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        long startTimeCallApi = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        trackEvent(context.getString(R.string.ft_ls_login_google_api_call_success),ConstantTrackEvent.TRACK_LS_LOGIN_GOOGLE_CALL_API_SUCCESS);
    }


    /**
     * sdk call api login Google - Thất bại
     *
     * @param errCode mã lỗi code
     * @param mess    Nội dung lỗi
     */
    public void trackLoginGoogleCallApiFail(int errCode, String mess) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_google_api_call_fail));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        long startTimeCallApi = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        event.addCallbackParameter("error_code", String.valueOf(errCode));
        event.addCallbackParameter("error_message", mess);
        trackEvent(context.getString(R.string.ft_ls_login_google_api_call_fail),ConstantTrackEvent.TRACK_LS_LOGIN_GOOGLE_CALL_API_FAIL);
    }


    //---------------------------------------------------------------PLAYNOW----------------------------------------------------------------


    /**
     * sdk call api login PlayNow
     */
    public void trackLoginPlayNowCallApi() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_playnow_btn_clicked));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        trackEvent(context.getString(R.string.ft_ls_login_playnow_btn_clicked),ConstantTrackEvent.TRACK_LS_LOGIN_PLAYNOW_CALL_API);
    }

    /**
     * sdk call api login PlayNow - thành công
     */
    public void trackLoginPlayNowCallApiSuccess() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_playnow_api_call_success));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        long startTimeCallApi = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        trackEvent(context.getString(R.string.ft_ls_login_playnow_api_call_success),ConstantTrackEvent.TRACK_LS_LOGIN_PLAYNOW_CALL_API_SUCCESS);
    }


    /**
     * sdk call api login PlayNow - Thất bại
     *
     * @param errCode mã lỗi code
     * @param mess    Nội dung lỗi
     */
    public void trackLoginPlayNowCallApiFail(int errCode, String mess) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_login_playnow_api_call_fail));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        long startTimeCallApi = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        event.addCallbackParameter("timestamp", String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login", String.valueOf(current - startTime));
        event.addCallbackParameter("delta_call", String.valueOf(current - startTimeCallApi));
        event.addCallbackParameter("error_code", String.valueOf(errCode));
        event.addCallbackParameter("error_message", mess);
        trackEvent(context.getString(R.string.ft_ls_login_playnow_api_call_fail),ConstantTrackEvent.TRACK_LS_LOGIN_PLAYNOW_CALL_API_FAIL);
    }

    /**
     * TRack get sdk-config success
     */
    public void trackGetSdkConfigSuccess() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_game_config_call_api_success));
        long current = System.currentTimeMillis();
        long start_time = PrefManager.getLong(GameSdk.getInstance().getApplication(), ConstantTrackEvent.START_CALL_GET_SDK_CONFIG, System.currentTimeMillis());
        long deltaTime = current - start_time;
        event.addCallbackParameter("timestamp",String.valueOf(current));
        event.addCallbackParameter("delta",String.valueOf(deltaTime));
        trackEvent(context.getString(R.string.ft_ls_game_config_call_api_success),ConstantTrackEvent.START_CALL_GET_SDK_CONFIG);
    }

    /**
     * TRack get sdk-config success
     */
    public void trackGetSdkConfigFailed(int code) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_game_config_call_api_fail));
        long current = System.currentTimeMillis();
        long start_time = PrefManager.getLong(GameSdk.getInstance().getApplication(), ConstantTrackEvent.START_CALL_GET_SDK_CONFIG, System.currentTimeMillis());
        long deltaTime = current - start_time;
        event.addCallbackParameter("timestamp",String.valueOf(current));
        event.addCallbackParameter("delta",String.valueOf(deltaTime));
        trackEvent(context.getString(R.string.ft_ls_game_config_call_api_fail),ConstantTrackEvent.TRACK_LS_GET_SDK_CONFIG_FAILED);
    }


    //------------------------------------------------------------------------------------------------------

    /**
     * user chọn tab register trong màn hình login
     */
    public void trackClickBtnRegister() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_register_btn_clicked));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp",String.valueOf(current));
        event.addCallbackParameter("delta",String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login",String.valueOf(current-startTime));
        trackEvent(context.getString(R.string.ft_ls_register_btn_clicked),ConstantTrackEvent.TRACK_LS_CLICK_BTN_REGISTER);
    }

    /**
     * màn hình register tải thành công
     */
    public void trackRegisterLoadSuccess() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_register_form_load_success));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp",String.valueOf(current));
        event.addCallbackParameter("delta",String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login",String.valueOf(current-startTime));
        trackEvent(context.getString(R.string.ft_ls_register_form_load_success),ConstantTrackEvent.TRACK_LS_REGISTER_LOAD_SUCCESS);
    }

    /**
     * user submit form register
     */
    public void trackRegisterSubmitForm() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_register_form_submited));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        long deltaTime = current - beginTime;
        long startTime = PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp",String.valueOf(current));
        event.addCallbackParameter("delta",String.valueOf(deltaTime));
        event.addCallbackParameter("delra_login",String.valueOf(current-startTime));
        trackEvent(context.getString(R.string.ft_ls_register_form_submited),ConstantTrackEvent.TRACK_LS_REGISTER_SUBMIT_FORM);
    }

    /**
     * Login screen close
     */
    public void trackLoginScreenClose(View form, View text, View button) {
        event= new AdjustEvent(context.getString(R.string.ft_ls_close_btn_clicked));
        long current = System.currentTimeMillis();
        PrefManager.saveLong(context, ConstantTrackEvent.START_TIME_CALL_API, current);
        long deltaTime = current - beginTime;
        long delta_login = current - PrefManager.getLong(context, ConstantTrackEvent.START_TIME_LOGIN, current);
        event.addCallbackParameter("timestamp",String.valueOf(current));
        event.addCallbackParameter("delta",String.valueOf(deltaTime));
        event.addCallbackParameter("delta_login",String.valueOf(delta_login));
        trackEvent(context.getString(R.string.ft_ls_close_btn_clicked),ConstantTrackEvent.TRACK_LOGIN_SCREEN_CLOSE);
    }


    /**
     * track when get authenconfig success
     */
    public void trackCallAuthenConfigSuccess() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_get_authen_api_call_success));
        long current = System.currentTimeMillis();
        event.addCallbackParameter("timestamp", String.valueOf(current));
        trackEvent(context.getString(R.string.ft_ls_get_authen_api_call_success),ConstantTrackEvent.TRACK_LS_AUTHEN_SUCESS);
    }

    /**
     * track when game maintain opened
     */
    public void trackMaintainScreenOpened() {
        event= new AdjustEvent(context.getString(R.string.ft_maintain_screen_opened));
        long current = System.currentTimeMillis();
        event.addCallbackParameter("timestamp", String.valueOf(current));
        trackEvent(context.getString(R.string.ft_maintain_screen_opened),ConstantTrackEvent.TRACK_MAINTAIN_SCREEN_OPENED);
    }

    /**
     * track when get authenconfig failed
     */
    public void trackCallAuthenConfigFailed() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_get_authen_api_call_fail));
        long current = System.currentTimeMillis();
        event.addCallbackParameter("timestamp", String.valueOf(current));
        trackEvent(context.getString(R.string.ft_ls_get_authen_api_call_fail),ConstantTrackEvent.TRACK_LS_AUTHEN_FAILED);
    }

    /**
     * track when get authenconfig failed
     */
    public void trackForgotPassword() {
        event= new AdjustEvent(context.getString(R.string.ft_ls_forgot_password_clicked));
        long current = System.currentTimeMillis();
        long deltaTime = current - beginTime;
        event.addCallbackParameter("timestamp",String.valueOf(current));
        event.addCallbackParameter("delta", String.valueOf(deltaTime));
        trackEvent(context.getString(R.string.ft_ls_forgot_password_btn_clicked),ConstantTrackEvent.TRACK_LS_FORGOT_PASS);
    }


    /**
     * Bắt đầu bấm vào nút xin quyền , show dialog xin quyền
     */
    public void trackClickOverlayPermission() {
        trackEvent(context.getString(R.string.ft_overlay_click_permission),ConstantTrackEvent.TRACK_LICK_OVERLAY_PERMISTION);
    }

    /**
     * Bắt đầu bấm vào nút xin quyền , show dialog xin quyền
     */
    public void trackStartPermisison() {
        trackEvent(context.getString(R.string.ft_start_permisison),ConstantTrackEvent.START_PERMISISON);
    }

    /**
     * Lắng nghe ở result activity sau khi xin quyền xong
     */
    public void trackEndPermisison() {
        trackEvent(context.getString(R.string.ft_end_permission),ConstantTrackEvent.END_PERMISISON);
    }




}
