/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.config;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.login.FacebookManager;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.object.UserObj;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.DeviceUtils;
import com.mobgame.MobGameSDK;
import com.mobgame.utils.Preference;

public class GameConfigs {
    private static GameConfigs gameConfigs;
    private String appKey;
    private SdkConfigObj sdkConfig;
    private boolean show_qc;
    private String FCM_APP_API_KEY = "d5f66e393eaab40f72e6b7d3ca5f32f275db5bd5";
    UserObj user;

    public static GameConfigs getInstance() {
        if (gameConfigs == null) {
            gameConfigs = new GameConfigs();
        }
        return gameConfigs;
    }

    private GameConfigs() {
    }

    public static void clearInstance() {
        GameConfigs.getInstance().setUser(null);
        GameConfigs.getInstance().setSdkConfig(null);
    }

    public String getAppKey() {
        if (this.appKey == null) {
            return PrefManager.getAppKey((Context)GameSdk.getInstance().getApplication());
        }
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
        PrefManager.saveAppKey((Context)GameSdk.getInstance().getApplication(), appKey);
    }

    public UserObj getUser() {
        if (this.user == null) {
            return PrefManager.getUser((Context)GameSdk.getInstance().getApplication());
        }
        return this.user;
    }

    public void setUser(UserObj user) {
        this.user = user;
        PrefManager.saveUser((Context)GameSdk.getInstance().getApplication(), user);
    }

    public SdkConfigObj getSdkConfig() {
        return this.sdkConfig;
    }

    public void setSdkConfig(SdkConfigObj sdkConfig) {
        if (sdkConfig == null) {
            this.sdkConfig = null;
            return;
        }
        this.sdkConfig = sdkConfig;
        if (sdkConfig.getEx() != null && sdkConfig.getEx().isShowLogo()) {
            MobGameSDK.getInstance().requestOverlayPermission(MobGameSDK.activity);
        }
        GameConfigs.getInstance().setShow_qc(true);
        GameConfigs.getInstance().initAds(sdkConfig.getAds());
        PrefManager.saveBoolean((Context)GameSdk.getInstance().getApplication(), "shared_pref_db_enabled", true);
        PrefManager.saveSetting((Context)GameSdk.getInstance().getApplication(), "SESSION_OUT_TIME", sdkConfig.getSessionOutTime());
    }

    public boolean isLogin() {
        return !TextUtils.isEmpty((CharSequence)PrefManager.getAccessToken((Context)GameSdk.getInstance().getApplication()));
    }

    public void initFacebook(String facebookAppId) {
        FacebookManager.getInstance((Context)GameSdk.getInstance().getApplication()).init(facebookAppId);
    }

    public void initAds(SdkConfigObj.Ads config) {
        Activity a = MobGameSDK.activity;
        if (config != null) {
            Preference.save((Context)a, "FunAdsApikey", config.getApiKey());
        }
    }

    public boolean getShow_qc() {
        return this.show_qc;
    }

    public void setShow_qc(boolean show_qc) {
        this.show_qc = show_qc;
    }

    public SdkConfigObj.Pop getMobPopup() {
        if (this.sdkConfig == null || this.sdkConfig.getPop() == null) {
            return new SdkConfigObj.Pop();
        }
        return this.sdkConfig.getPop();
    }

    public String getLang() {
        return DeviceUtils.getLanguage();
    }

    public SdkConfigObj.GoogleIAB getGgIABConfig() {
        return this.sdkConfig == null ? null : new SdkConfigObj.GoogleIAB();
    }

    public String getFcmApiKey() {
        return this.FCM_APP_API_KEY;
    }
}

