package com.game.sdk.ui.other;

import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.object.response.AuthenConfigResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.presenter.InteractorCallback;
import com.game.sdk.ui.login.ILoginInteractor;
import com.game.sdk.ui.login.ILoginPresenter;
import com.game.sdk.ui.login.LoginInteractorImpl;

public class GamePresenterImpl implements IGamePresenter {

    private IGameInteractor mInteractor;
    private BaseView mBaseView;

    public GamePresenterImpl(BaseView mBaseView) {
        this.mBaseView = mBaseView;
        mInteractor = new GameInteractorImpl(mCallback);
    }

    private final InteractorCallback<Object> mCallback = new InteractorCallback<Object>() {
        @Override
        public void success(Object x) {
            if (mBaseView != null) {
                mBaseView.hideProgress();
                mBaseView.success(x);
            }
        }

        @Override
        public void error(Object o) {
            if (mBaseView != null) {
                mBaseView.hideProgress();
                mBaseView.error(o);
            }
        }
    };

    @Override
    public void cancelRequest(String... tags) {
        mInteractor.cancelRequest();
    }


    @Override
    public void getMessInGame() {
        mInteractor.cancelRequest();
        mInteractor.getMessInGame();
    }

    @Override
    public void saveCharactor(String roleId, String areaId) throws Exception {
        mInteractor.cancelRequest();
        mInteractor.saveCharactor(roleId, areaId);
        if (mBaseView != null) {
            mBaseView.showProgress("");
        }
    }

    @Override
    public void saveFCM(String userId, String token) throws Exception {
        mInteractor.cancelRequest();
        mInteractor.saveFCM(userId, token);
        if (mBaseView != null) {
            mBaseView.showProgress("");
        }
    }

    @Override
    public void connectFaceBook(String token) throws Exception {
        mInteractor.cancelRequest();
        mInteractor.connectFaceBook(token);
        if (mBaseView != null) {
            mBaseView.showProgress("");
        }
    }


}
