package com.game.sdk.comon.js.command;

import android.app.Activity;
import android.widget.Toast;

import com.facebook.AccessToken;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.ToastUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.other.GamePresenterImpl;
import com.game.sdk.ui.other.IGamePresenter;
import com.mobgame.R;
import com.mobgame.component.FacebookManager;
import com.mobgame.gui.dialog.MobGameDialogStartWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.utils.Res;

import java.util.HashMap;
import java.util.Set;


public final class CmdLogin {

    private static final String TAG = CmdLogin.class.getSimpleName();
    private static CmdLogin INSTANCE;

    private CmdLogin() {
    }

    public static CmdLogin getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdLogin();
        }
        return INSTANCE;
    }

    public void mobUpgradeFacebook(final Activity activity, final MobGameDialogWebviewFragment webDialogFragment, final MobGameDialogStartWebFragment dialogStartWebFragment, String params) {

        FacebookManager.getInstance().login(activity, new FacebookManager.LoginCallback() {

            @Override
            public void onSuccess(AccessToken accessToken,
                                  Set<String> recentlyGrantedPermissions,
                                  Set<String> recentlyDeniedPermissions) {

                try {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put("fb_token", accessToken.getToken());

                    IGamePresenter iGamePresenter = new GamePresenterImpl(new BaseView() {
                        @Override
                        public void showProgress(String message) {
                            Utils.showLoading(activity, true);
                        }

                        @Override
                        public void hideProgress() {
                            Utils.showLoading(activity, false);
                        }

                        @Override
                        public void success(Object x) {
                            if (x instanceof BaseObj) {
                                DialogUtils.showInfoDialog(activity, "", ((BaseObj) x).getMessage(), new DialogUtils.DlgListener() {
                                    @Override
                                    public void onOK() {
                                        if (webDialogFragment != null)
                                            webDialogFragment.dismiss();
                                        if (dialogStartWebFragment != null)
                                            dialogStartWebFragment.dismiss();
                                    }
                                });
                            }
                        }

                        @Override
                        public void error(Object o) {
                            if (o instanceof BaseObj) {
                                DialogUtils.showErrorDialog(activity, ((BaseObj) o).getMessage());
                            }
                        }
                    });
                    iGamePresenter.connectFaceBook(accessToken.getToken());
                } catch (Exception e) {
                    handleException(activity, Res.string(activity, R.string.something_went_wrong));
                }

            }

            @Override
            public void onCancel() {

            }

            @Override
            public void onError(Throwable t) {
                LogUtils.d("LoginFB", t.getMessage());
                ToastUtils.showErrToast(activity,activity.getString(R.string.err_connect_facebook));
            }

        });
    }


    private void handleException(final Activity activity, final String message) {
        activity.runOnUiThread(new Runnable() {

            @Override
            public void run() {
                Toast.makeText(activity, message, Toast.LENGTH_LONG).show();
            }
        });


    }

}
