package com.game.sdk.comon.game;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;

import com.game.sdk.comon.listener.ILoginListener;
import com.game.sdk.comon.listener.IMesssageListener;
import com.game.sdk.comon.listener.IPaymentListener;
import com.game.sdk.comon.listener.ISaveCharactorListener;
import com.game.sdk.comon.object.MessInGameObj;

import java.util.ArrayList;

public interface IMobSdk {

    Application getApplication();

    void init(@NonNull Application application, String appkey, String facebookId);

    void loginNative(Activity activity, ILoginListener listener);

    void showLoginForm(Activity activity, ILoginListener listener);

    void logOut(Activity activity);

    void onLoginSuccess(Activity activity, String tab);

    void getMessInGame(Activity activity, IMesssageListener messsageListener);

    void payment(Activity activity, String state, IPaymentListener listener);

    void saveCharactor(Activity activity, String roleId, String areaId, ISaveCharactorListener listener);


    void onActivityResult(int requestCode, int resultCode, Intent data);

    void onDestroy();

    void shareImageFacebook(Activity activity, Bitmap image);

    void dashboardNew();

    void  showTextScroll(ArrayList<MessInGameObj> listNoti);

    void onRequestPermissionsResult(Activity gameActivity, int requestCode, String[] permissions, int[] grantResults);

    void onWindowFocusChanged(boolean hasFocus);

    void onBackPressed();

}
