package com.mobgame.js;

import android.app.Activity;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;

import com.game.sdk.comon.api.ErrorCode;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.listener.IPaymentListener;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.PurchaseUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.payment.IPaymentPresenter;
import com.game.sdk.ui.payment.PaymentFragment;
import com.game.sdk.ui.payment.PaymentPresenterImpl;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.utils.Constants;
import com.mobgame.utils.iab.IabHelper;
import com.mobgame.utils.iab.IabHelper.OnConsumeFinishedListener;
import com.mobgame.utils.iab.IabHelper.OnConsumeMultiFinishedListener;
import com.mobgame.utils.iab.IabHelper.OnIabPurchaseFinishedListener;
import com.mobgame.utils.iab.IabHelper.OnIabSetupFinishedListener;
import com.mobgame.utils.iab.IabHelper.QueryInventoryFinishedListener;
import com.mobgame.utils.iab.IabResult;
import com.mobgame.utils.iab.Inventory;
import com.mobgame.utils.iab.Purchase;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CmdPayment {

    private static String TAG = CmdPayment.class.getSimpleName();
    private static CmdPayment INSTANCE;
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_IAB = 1;
    private static final int TYPE_PAYPAL = 2;

    // iab
    private IabHelper mIabHelper;
    private ArrayList<String> listPendingPurchases = new ArrayList<String>();
    private Activity activity;
    boolean mStartIAB = false;
    PaymentFragment.Listener listener;

    private CmdPayment() {
    }

    public static CmdPayment getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CmdPayment();
        }
        return INSTANCE;
    }

    public void verifyPayment(Activity mActivity, PurchaseHistoryObj historyObj, IPaymentListener iPaymentListener) {
        VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setOrder_no(historyObj.getOrder_no());
        obj.setMethod("2");
        obj.setReceipt(historyObj.getReceipt());
        obj.setApp_version(Utils.getGameVersion(mActivity));
        obj.setSdk_version(Utils.getSDKVersion(mActivity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setResolution(DeviceUtils.getResolution(mActivity));
        obj.setNetwork(Utils.getNetwork(mActivity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID(mActivity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID(mActivity));
        obj.setLocale(GameConfigs.getInstance().getLang());
        IPaymentPresenter presenter = new PaymentPresenterImpl(new BaseView() {
            @Override
            public void showProgress(String message) {
                Utils.showLoading(mActivity, true);
            }

            @Override
            public void hideProgress() {
                Utils.showLoading(mActivity, false);
            }

            @Override
            public void success(Object x) {
                if (x instanceof VerifyPurchaseResponseObj) {
                    VerifyPurchaseResponseObj responseObj = (VerifyPurchaseResponseObj) x;
                    if (responseObj.getData().getStatus() == 3 || responseObj.getData().getStatus() == 2 || responseObj.getData().getStatus() == 17) {
                        LogUtils.e(TAG, "Verify Success - " + historyObj.getOrder_no());
                        PurchaseUtils.removeSuccessPurchase(historyObj, mActivity);
                        TrackingUtil.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                        if (iPaymentListener != null)
                            iPaymentListener.onPaymentSuccess(responseObj.getData());
                    } else {
                        TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(responseObj.getData().getStatus()), responseObj.getData().getDescription());
                        DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.err_verify_purchase), new DialogUtils.DlgCloseListener() {
                            @Override
                            public void onClose() {
                            }
                        });
                    }
                }
            }

            @Override
            public void error(Object o) {
                BaseObj apiErrorObj = (BaseObj) o;
                TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(apiErrorObj.getStatus()), apiErrorObj.getMessage());
                if (apiErrorObj.getStatus() == ErrorCode.NO_INTERNET) {
                    DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.error_network));
                    return;
                }
                if (o instanceof VerifyPurchaseErrObj) {
                    VerifyPurchaseErrObj obj = (VerifyPurchaseErrObj) o;
                    if (obj.getStatus() == com.game.sdk.comon.constants.Constants.USER_ERR_CODE.INVALID_TOKEN) {
                        DialogUtils.showExpireDialog(mActivity);
                    } else {
                        int count_time = mActivity.getIntent().getIntExtra("count_time", 0);
                        if (count_time <= 2)
                            DialogUtils.showPaymentRetryDialog(mActivity, obj.getMessage(), new DialogUtils.Listener() {
                                @Override
                                public void onRetry() {
                                    mActivity.getIntent().putExtra("count_time", count_time + 1);
                                    verifyPayment(mActivity, historyObj, iPaymentListener);
                                }
                            });
                        else
                            DialogUtils.showErrorDialog(mActivity, obj.getMessage(), new DialogUtils.DlgCloseListener() {
                                @Override
                                public void onClose() {
                                }
                            });
                    }
                }
            }
        });
        TrackingUtil.getInstance().trackPaymentBeforVerify(historyObj.getOrder_no());
        presenter.verifyPurchase(obj);
    }

    public void handleResult(Activity activity, int requestCode, int resultCode, Intent data) {
        this.activity = activity;
        switch (requestCode) {

            case Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING:
                mIabHelper.handleActivityResult(requestCode, resultCode, data);
                break;


            case Constants.REQUEST_CODE_PAYPAL_FUTURE_PAYMENT:
            case Constants.REQUEST_CODE_PAYPAL_PROFILE_SHARING:
                // Do nothing
                break;

        }
    }


    private void initPaypal(Activity activity) {
        Log.i(TAG, "initPaypal");
        // TODO: 7/4/2020 Add Paypal here
    }

    public void mobPaymentStartIAP(final Activity activity, String params, PaymentFragment.Listener listener) {
        this.listener = listener;
        Log.i(TAG, "paymentStartIAP:" + params);
        this.activity = activity;
        initIAB(activity);
        try {
            JSONObject obj = new JSONObject(params);
            String product_id = obj.getString("product_id");
            //Tracking payment_clicked
            Map<String, Object> eventValue = new HashMap<>();
            eventValue.put("product_id", product_id);

            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put("Value", product_id);

            listPendingPurchases.add(product_id);
            if (mIabHelper != null && mIabHelper.isSetupDone()) {
                Log.i(TAG, "mQueryInventoryFinishedListener 1");
                mIabHelper.queryInventoryAsync(mQueryInventoryFinishedListener);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    ;

    private void initIAB(Activity activity) {
        Log.i(TAG, "initIAB");
        try {
            // init IAB
            if (mIabHelper == null || !mIabHelper.getActivity().equals(activity)) {
                SdkConfigObj.GoogleIAB config = GameConfigs.getInstance().getGgIABConfig();
                mIabHelper = new IabHelper(activity);
                mIabHelper.startSetup(mOnIabSetupFinishedListener);
            }
            Log.i(TAG, "init done");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private OnIabSetupFinishedListener mOnIabSetupFinishedListener = new OnIabSetupFinishedListener() {

        @Override
        public void onIabSetupFinished(IabResult result) {
            try {
                Log.i(TAG, "onIabSetupFinished");
                if (!result.isSuccess()) {
                    Log.i(TAG, "Problem setting up In-app Billing: " + result);
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Problem setting up In-app Billing: " + result);
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    return;
                }
                // Hooray, IAB is fully set up!
                if (mIabHelper != null) {
                    Log.i(TAG, "mQueryInventoryFinishedListener 2");
                    mIabHelper.queryInventoryAsync(mQueryInventoryFinishedListener);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private QueryInventoryFinishedListener mQueryInventoryFinishedListener = new QueryInventoryFinishedListener() {
        //Query purchased Items
        @Override
        public void onQueryInventoryFinished(IabResult result, Inventory inv) {
            try {
                Log.i(TAG, "onQueryInventoryFinished");
                if (!result.isSuccess()) {
                    Log.i(TAG, "Problem setting up In-App-Billing" + result);
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Problem setting up In-app Billing: " + result);
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    return;
                }
                // thanh toan thanh cong
                if (inv.getAllPurchases().size() > 0) {
                    Log.i(TAG, "inv.getAllPurchases().size() " + inv.getAllPurchases().size());
                    mIabHelper.consumeAsync(inv.getAllPurchases(), mOnIabConsumeMultiFinishedListener);
                } else {
                    Log.i(TAG, "listPendingPurchases 11" + listPendingPurchases.size());
                    if (listPendingPurchases.size() > 0) {
                        Log.i(TAG, "listPendingPurchases 2" + listPendingPurchases.size());
                        String sku = listPendingPurchases.get(listPendingPurchases.size() - 1);
                        listPendingPurchases.clear();
                        mIabHelper.launchPurchaseFlowWithRetry(
                                sku, Constants.REQUEST_CODE_GOOGLE_IN_APP_BILLING,
                                mOnIabPurchaseFinishedListener);
                        Log.i(TAG, "listPendingPurchases 3" + listPendingPurchases.size());
                    } else {
                        Log.i(TAG, "MobGameSDK.close() ");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private OnConsumeFinishedListener mOnIabConsumeFinishedListener = new IabHelper.OnConsumeFinishedListener() {

        @Override
        public void onConsumeFinished(Purchase purchase, IabResult result) {

            handleConsume(purchase, result);
        }
    };

    private OnConsumeMultiFinishedListener mOnIabConsumeMultiFinishedListener = new OnConsumeMultiFinishedListener() {

        @Override
        public void onConsumeMultiFinished(List<Purchase> purchases,
                                           List<IabResult> results) {
            try {
                for (int i = 0; i < purchases.size(); i++) {
                    handleConsume(purchases.get(i), results.get(i));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private OnIabPurchaseFinishedListener mOnIabPurchaseFinishedListener = new OnIabPurchaseFinishedListener() {

        @Override
        public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
            try {
                Log.i(TAG, "onIabPurchaseFinished");
                if (result.isFailure()) {
                    if (result.getResponse() != IabHelper.IABHELPER_USER_CANCELLED) {
                        Log.i(TAG, "Error purchasing: " + result);
                        Intent intent = new Intent(Constants.INTENT_FILTER);
                        intent.putExtra("category", "payment");
                        intent.putExtra("status", false);
                        intent.putExtra("message", "Error IAB purchasing: " + result);
                        LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    }

                    return;
                }

                mIabHelper.consumeAsync(purchase, mOnIabConsumeFinishedListener);
            } catch (Exception e) {
                e.printStackTrace();

            }
        }
    };

    private void handleConsume(Purchase purchase, IabResult result) {
        Log.i(TAG, "onConsumeFinished");
        try {
            if (result.isFailure()) {
                if (result.getResponse() != IabHelper.IABHELPER_USER_CANCELLED) {
                    Log.i(TAG, "Error purchasing: " + result);
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "payment");
                    intent.putExtra("status", false);
                    intent.putExtra("message", "Error IAB purchasing: " + result);
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                }
                return;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        Log.i(TAG, "purchase successful .");
        try {
            if (listener != null) {
                listener.onProcessIAB(purchase);
            }
//            new ProcessIABReceiptTask(
//                    purchase.getItemType(),
//                    purchase.getSignature(),
//                    purchase.getOriginalJson(),
//                    new Callback<ResponseBody>() {
//
//                        @Override
//                        public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
//                            HashMap<String, Object> hashMap = new HashMap<>();
//                            hashMap.put("Value", purchase.getSku());
//                            try {
//                                String responseBody = response.body().string();
//                                mobPaymentSuccess(activity, responseBody, TYPE_IAB);
//                            } catch (IOException e) {
//                                // TODO Handle error
//                                e.printStackTrace();
//                            }
//                        }
//
//                        @Override
//                        public void onFailure(Call<ResponseBody> call, Throwable e) {
//                            HashMap<String, Object> hashMap = new HashMap<>();
//                            hashMap.put("Value", purchase.getSku());
//                        }
//                    }
//            ).execute();
            Log.i(TAG, "mQueryInventoryFinishedListener 3");
            MobGameSDK.getInstance().close();
            mIabHelper.queryInventoryAsync(mQueryInventoryFinishedListener);

        } catch (Exception e) {
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "payment");
            intent.putExtra("status", false);
            intent.putExtra("message", e.getMessage());
            LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
        }
    }

    void mobPaymentSuccess(final Activity activity, String params) {
        mobPaymentSuccess(activity, params, TYPE_UNKNOWN);
    }

    void mobPaymentSuccess(final Activity activity, String params, int type) {
        Log.i(TAG, "mobPaymentSuccess");
        // {"order_id":"42711482507","user_id":"774763","status":0,"order_product":"47","platform_price":"47","game_price":47,"details":"","state":"","time":1423447983,"game_role_id":"test_role_id","game_area_id":"test_area_id"}
        try {
            final JSONObject order = new JSONObject(params);
            if (order != null && order.getString("status").equals("0")) {
                String userId = order.getString("user_id");
                String orderId = order.getString("order_id");
                String orderProduct = order.getString("order_product");
                String orderInfo = order.getString("details");
                String orderTime = order.getString("time");
                String platformPrice = order.getString("platform_price");
                String gamePrice = order.getString("game_price");
                String state = "";
                String game_role_id = "";
                String game_area_id = "";
                String is_sandbox = "";
                if (order.has("state")) {
                    state = order.getString("state");
                }
                if (order.has("game_role_id")) {
                    game_role_id = order.getString("game_role_id");
                }
                if (order.has("game_area_id")) {
                    game_area_id = order.getString("game_area_id");
                }
                if (order.has("is_sandbox")) {
                    is_sandbox = order.getString("is_sandbox");
                }

                Intent intent = new Intent(Constants.INTENT_FILTER);
                intent.putExtra("category", "payment");
                intent.putExtra("status", true);
                intent.putExtra("user_id", userId);
                intent.putExtra("order_id", orderId);
                intent.putExtra("order_product", orderProduct);
                intent.putExtra("order_info", orderInfo);
                intent.putExtra("order_time", orderTime);
                intent.putExtra("platform_price", platformPrice);
                intent.putExtra("game_price", gamePrice);
                intent.putExtra("state", state);
                intent.putExtra("game_role_id", game_role_id);
                intent.putExtra("game_area_id", game_area_id);
                intent.putExtra("is_sandbox", is_sandbox);
                LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
            } else {
                Log.i(TAG, "on pay failed");
                Intent intent = new Intent(Constants.INTENT_FILTER);
                intent.putExtra("category", "payment");
                intent.putExtra("status", false);
                intent.putExtra("message", "Error purchasing");
                LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
            }
        } catch (Exception e) {
            Intent intent = new Intent(Constants.INTENT_FILTER);
            intent.putExtra("category", "payment");
            intent.putExtra("status", false);
            intent.putExtra("message", e.getMessage());
            LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
        } finally {
            switch (type) {
                case TYPE_UNKNOWN:
                case TYPE_PAYPAL:
                    MobGameSDK.getInstance().close();
                    break;
                case TYPE_IAB:
                    break;
            }
        }
    }

}