package com.game.sdk.ui.login.term;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ProgressBar;

import com.game.sdk.comon.game.BaseDialogFragment;
import com.game.sdk.comon.game.BaseDialogWebFragment;
import com.game.sdk.comon.js.JsBase;
import com.game.sdk.comon.js.JsTerm;
import com.game.sdk.comon.listener.IWebViewClientListener;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.comon.utils.WvUtil;
import com.mobgame.BuildConfig;
import com.mobgame.R;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.gui.MobGameWebView2;
import com.mobgame.js.JsHandler;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Preference;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import static com.game.sdk.comon.utils.WvUtil.setCookieToURLWebview;

public class TermDialogFragment extends BaseDialogWebFragment {


    public static TermDialogFragment newInstance(String url) {
        TermDialogFragment frag = new TermDialogFragment();
        Bundle args = new Bundle();
        args.putString(URL_WEBVIEW, url);
        frag.setArguments(args);
        return frag;
    }


    @Override
    protected JsBase getJsHandler() {
        return new JsTerm(new JsTerm.Listener() {
            @Override
            public void onCloseWindow() {
                dismiss();
            }

            @Override
            public void onOpenWindow() {

            }

            @Override
            public void onBackToWindowns() {
                goBack();
            }
        });
    }

    @Override
    protected IWebViewClientListener getWebListener() {
        return null;
    }
}
