/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.game.sdk.comon.view.CustomToast;
import com.mobgame.R;

public class ToastUtils {
    static CustomToast toast;
    private static View helloView;
    public static Runnable runnableHideHello;
    public static Handler handler;

    public static void showLongToast(Context context, String mess) {
        Toast.makeText((Context)context, (CharSequence)mess, (int)1).show();
    }

    public static void showShortToast(Context context, String mess) {
        Toast.makeText((Context)context, (CharSequence)mess, (int)0).show();
    }

    public static void showHelloToast(Context context, String message) {
        if (toast != null) {
            toast.cancel();
        }
        toast = new CustomToast(context, 3, message);
        toast.setGravity(55, 0, 0);
        toast.setDuration(0);
        toast.show();
    }

    public static void showErrToast(Context context, String message) {
        if (toast != null) {
            toast.cancel();
        }
        toast = new CustomToast(context, 2, message);
        toast.setGravity(87, 0, 0);
        toast.setDuration(0);
        toast.show();
    }

    public static void showWarmToast(Context context, String message) {
        if (toast != null) {
            toast.cancel();
        }
        toast = new CustomToast(context, 1, message);
        toast.setGravity(87, 0, 0);
        toast.setDuration(0);
        toast.show();
    }

    public static void showBottomInfoToast(Context context, String message) {
        if (toast != null) {
            toast.cancel();
        }
        toast = new CustomToast(context, 0, message);
        toast.setGravity(87, 0, 0);
        toast.setDuration(0);
        toast.show();
    }

    public static void showToDoToast(Context context, String message) {
        if (toast != null) {
            toast.cancel();
        }
        toast = new CustomToast(context, 4, message);
        toast.setGravity(87, 0, 0);
        toast.setDuration(0);
        toast.show();
    }

    public static void showHello(final @NonNull Activity activity, long duration, final String mess) {
        if (activity == null) {
            return;
        }
        final ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
        if (helloView != null) {
            helloView.clearAnimation();
            rootView.removeView(helloView);
            if (handler != null && runnableHideHello != null) {
                handler.removeCallbacks(runnableHideHello);
                helloView = null;
            }
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            @SuppressLint(value={"InflateParams"})
            public void run() {
                LayoutInflater inflater = LayoutInflater.from((Context)activity);
                helloView = inflater.inflate(R.layout.toast_notify, null);
                TextView tvMessage = (TextView)helloView.findViewById(R.id.tvDescription);
                ImageView ivToast = (ImageView)helloView.findViewById(R.id.ivToast);
                tvMessage.setText((CharSequence)mess);
                rootView.addView(helloView);
                helloView.startAnimation(AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_in));
            }
        });
        if (handler == null) {
            handler = new Handler();
        }
        if (runnableHideHello == null) {
            runnableHideHello = new Runnable(){

                @Override
                public void run() {
                    ToastUtils.hideHello(activity, true);
                }
            };
        }
        handler.postDelayed(runnableHideHello, duration + 500L);
    }

    public static void hideHello(final @NonNull Activity activity, boolean isAnimated) {
        if (activity == null) {
            return;
        }
        if (isAnimated) {
            try {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Animation animation = AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_out);
                        animation.setAnimationListener(new Animation.AnimationListener(){

                            public void onAnimationStart(Animation animation) {
                            }

                            public void onAnimationRepeat(Animation animation) {
                            }

                            public void onAnimationEnd(Animation animation) {
                                ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                                rootView.removeView(helloView);
                                helloView = null;
                            }
                        });
                        helloView.startAnimation(animation);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                rootView.removeView(helloView);
                helloView = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

