package com.mobgame.component;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;

import com.game.sdk.comon.game.GameSdk;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import com.mobgame.utils.Constants;

import java.io.IOException;

import static com.google.android.gms.auth.api.signin.GoogleSignInStatusCodes.SIGN_IN_CURRENTLY_IN_PROGRESS;

public final class GoogleAuthManager {

    private final static String TAG = GoogleAuthManager.class.getSimpleName();
    private static GoogleAuthManager INSTANCE;

    private static final int REQUEST_GOOGLE_PLAY_SERVICES = 412;

    private GoogleSignInClient mGoogleSignInClient;
    private boolean mResolvingError = false;
    private GooglePlusResultCallback googlePlusResultCallback;
    private GooglePlusResultCallback ggPlayGameResultCallback;
    private Activity activity;
    private String SCOPE = "oauth2:https://www.googleapis.com/auth/userinfo.profile";

    public static GoogleAuthManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GoogleAuthManager();
        }
        return INSTANCE;
    }

    private GoogleAuthManager() {
    }

    void init(Activity activity) {
        try {
            this.activity = activity;
            GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
//                    .requestIdToken("562161453459-30e2objiab5qjsq8hl58rs02uddhtmrs.apps.googleusercontent.com")
                    .requestEmail()
                    .build();

            mGoogleSignInClient = GoogleSignIn.getClient(activity, gso);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            if (requestCode == Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES) {
                try {
                    Task<GoogleSignInAccount> signinTask = GoogleSignIn.getSignedInAccountFromIntent(data);
                    GoogleSignInAccount account = signinTask.getResult(ApiException.class);
                    if (account != null) {
                        // Signed in successfully, show authenticated UI.
                        String str = account.getIdToken();
                        Log.d("TAG ", "GGOOOOOOO : " + str);
                        if (googlePlusResultCallback != null) {
                            Log.d("TAG ", "GGOOOOOOO");
                            new GetToken(activity, SCOPE, account.getEmail(), account, googlePlusResultCallback).execute();
                        }
                    } else {
                        if (googlePlusResultCallback != null) {
                            googlePlusResultCallback.onLoginError("Google Signin Error", -1);
                        }
                    }


                } catch (ApiException e) {
                    // The ApiException status code indicates the detailed failure reason.
                    // Please refer to the GoogleSignInStatusCodes class reference for more information.
                    Log.w(TAG, "signInResult:failed code=" + e.getStatusCode());
                    if (e.getStatusCode() == SIGN_IN_CURRENTLY_IN_PROGRESS) {
                        if (googlePlusResultCallback != null)
                            googlePlusResultCallback.onLoginError("Google Signin Error", SIGN_IN_CURRENTLY_IN_PROGRESS);
                    } else {
                        if (googlePlusResultCallback != null)
                            googlePlusResultCallback.onLoginError("Google Signin Error", -1);
                        Log.d(TAG, "onActivityResult: Google Signin Error, account = null");
                    }
                }
            } else if (requestCode == Constants.REQUEST_CODE_LOGIN_PLAY_GAME_SERVICE && data != null) {
                GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
                GoogleSignInAccount signedInAccount = null;
                if (result != null)
                    signedInAccount = result.getSignInAccount();
                if (signedInAccount != null) {
                    // Signed in successfully, show authenticated UI.
                    String str = signedInAccount.getIdToken();
                    Log.d("TAG ", "GGOOOOOOO : " + str);
                    if (ggPlayGameResultCallback != null) {
                        Log.d("TAG ", "GGOOOOOOO");
                        new GetToken(activity, SCOPE, signedInAccount.getEmail(), signedInAccount, ggPlayGameResultCallback).execute();
                    }
                } else {
                    if (ggPlayGameResultCallback != null) {
                        ggPlayGameResultCallback.onLoginError("Google Signin Error", -1);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void login(Activity activity, GooglePlusResultCallback googlePlusResultCallback) {
        try {
            this.googlePlusResultCallback = googlePlusResultCallback;
            Intent signInIntent = mGoogleSignInClient.getSignInIntent();
            activity.startActivityForResult(signInIntent, Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void login(Fragment fragment, GooglePlusResultCallback googlePlusResultCallback) {
        try {
            this.googlePlusResultCallback = googlePlusResultCallback;
            Intent signInIntent = mGoogleSignInClient.getSignInIntent();
            fragment.startActivityForResult(signInIntent, Constants.REQUEST_CODE_LOGIN_PLAY_GAME_SERVICE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loginGGGame(Fragment frg, Activity activity, GooglePlusResultCallback ggPlayGameResultCallback) {
        try {
            this.ggPlayGameResultCallback = ggPlayGameResultCallback;
            GoogleSignInOptions signInOptions = GoogleSignInOptions.DEFAULT_GAMES_SIGN_IN;
            GoogleSignInAccount account = GoogleSignIn.getLastSignedInAccount(activity);
            if (GoogleSignIn.hasPermissions(account, signInOptions.getScopeArray())) {
                // Already signed in.
                // The signed in account is stored in the 'account' variable.
                GoogleSignInAccount signedInAccount = account;
                if (signedInAccount != null) {
                    // Signed in successfully, show authenticated UI.
                    String str = signedInAccount.getIdToken();
                    Log.d("TAG ", "GGOOOOOOO : " + str);
                    if (ggPlayGameResultCallback != null) {
                        Log.d("TAG ", "GGOOOOOOO");
                        new GetToken(activity, SCOPE, signedInAccount.getEmail(), signedInAccount, ggPlayGameResultCallback).execute();
                    }
                }
            } else {
                GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_GAMES_SIGN_IN)
                        .requestEmail()
                        .build();
                GoogleSignInClient signInClient = GoogleSignIn.getClient(activity, gso);
                Intent intent = signInClient.getSignInIntent();
                frg.startActivityForResult(intent, Constants.REQUEST_CODE_LOGIN_PLAY_GAME_SERVICE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logout() {
        try {
            GoogleSignInAccount account = GoogleSignIn.getLastSignedInAccount(GameSdk.getInstance().getApplication());
            if (account != null && mGoogleSignInClient != null) {
                mGoogleSignInClient.signOut();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public interface GooglePlusResultCallback {
        void onLoginSuccess(GoogleSignInAccount account, String mToken);

        void onLoginError(String mess, int code);
    }

    public String getToken(Activity activity, String email, String scope) throws IOException, GoogleAuthException {
        return GoogleAuthUtil.getToken(activity, email, scope);
    }

    class GetToken extends AsyncTask<Void, Void, String> {

        Activity mActivity;
        String mScope;
        String mEmail;
        GooglePlusResultCallback mCallback;
        GoogleSignInAccount mGogleSignin;

        public GetToken(Activity activity, String scope, String email, GoogleSignInAccount googleSignInAccount
                , GooglePlusResultCallback callback) {

            this.mActivity = activity;
            this.mScope = scope;
            this.mEmail = email;
            this.mCallback = callback;
            this.mGogleSignin = googleSignInAccount;

        }

        @Override
        protected String doInBackground(Void... params) {

            try {
                return getToken(activity, mEmail, mScope);
            } catch (IOException e) {
                e.printStackTrace();
            } catch (GoogleAuthException e) {
                e.printStackTrace();
            }
            return "";
        }

        @Override
        protected void onPostExecute(String aVoid) {
            super.onPostExecute(aVoid);
            try {
                if (!TextUtils.isEmpty(aVoid))
                    mCallback.onLoginSuccess(mGogleSignin, aVoid);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isGoogleServiceAvailable(Activity activity) {
        try {
            GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
            int result = googleAPI.isGooglePlayServicesAvailable(activity);
            if (result != ConnectionResult.SUCCESS) {
                if (googleAPI.isUserResolvableError(result)) {
                    googleAPI.getErrorDialog(activity, result,
                            REQUEST_GOOGLE_PLAY_SERVICES).show();
                }
                return false;
            }

            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
