package com.game.sdk.comon.view;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;

import com.game.sdk.comon.game.BaseDialogFragment;
import com.game.sdk.comon.listener.ILoginListener;
import com.game.sdk.ui.login.AccountFragment;
import com.mobgame.R;

public class CustomProgressDialog extends BaseDialogFragment {
    TextView progressTitle;
    public static String MESS = "mesage";
    public static CustomProgressDialog frag;
    boolean showing;

    public static CustomProgressDialog getInstance(String mesage) {
        if (frag != null)
            return frag;
        frag = new CustomProgressDialog();
        Bundle bulde = new Bundle();
        bulde.putString(MESS, mesage);
        frag.setArguments(bulde);
        return frag;
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.progress_dialog_custom;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        setCancelable(false);
        progressTitle = (TextView) view.findViewById(R.id.progressTitle);
        progressTitle.setText(getArguments().getString(MESS, ""));
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        showing = false;
    }

    @Override
    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        showing = false;
    }

    @Override
    public void show(FragmentManager manager, String tag) {
        super.show(manager, tag);
        showing = true;
    }

    @Override
    public int show(FragmentTransaction transaction, String tag) {
        showing = true;
        return super.show(transaction, tag);
    }

    public boolean isShowing() {
        return showing;
    }

    public void setShowing(boolean showing) {
        this.showing = showing;
    }
}
