package com.game.sdk.ui.payment;


import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.MyCallback;
import com.game.sdk.comon.api.request.NotificationRequest;
import com.game.sdk.comon.api.request.PaymentRequest;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.err.InitialPurchaseErrObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.InitalizePuchaseRequestObj;
import com.game.sdk.comon.object.request.SaveFcmRequestObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.InitialPurchaseResponseObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.InteractorCallback;
import com.game.sdk.comon.utils.LogUtils;

import retrofit2.Call;
import retrofit2.Response;

public class PaymentInteractorImpl implements IPaymentInteractor {
    private static final String TAG = PaymentInteractorImpl.class.getName();

    private InteractorCallback mCallback;

    Call<VerifyPurchaseResponseObj> mVerifyPurchaseResponseObj;
    Call<InitialPurchaseResponseObj> initialPurchaseResponseObjCall;

    public PaymentInteractorImpl(InteractorCallback mCallback) {
        this.mCallback = mCallback;
    }


    @Override
    public void verifyPurchase(VerifyPurchaseRequestObj obj) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        mVerifyPurchaseResponseObj = request.verifyPurchase(obj.getOrder_no(), obj);

        LogUtils.d("RECEIPT", obj.getReceipt().toString());
        mVerifyPurchaseResponseObj.enqueue(callbackVerifyPurchase);
    }

    @Override
    public void initialPurchase(InitalizePuchaseRequestObj initalizePuchaseRequestObj) {
        PaymentRequest request = ApiUtils.getPaymentRequest();
        initialPurchaseResponseObjCall = request.initialPurchase(initalizePuchaseRequestObj);
        initialPurchaseResponseObjCall.enqueue(new MyCallback<InitialPurchaseResponseObj>() {
            @Override
            public void onSuccess(Call<InitialPurchaseResponseObj> call, Response<InitialPurchaseResponseObj> response) {
                if (response.isSuccessful()) {
                    mCallback.success(response.body());
                }
            }

            @Override
            public void onError(Call<InitialPurchaseResponseObj> call, Object object) {
                BaseObj obj = (BaseObj) object;
                InitialPurchaseErrObj err = new InitialPurchaseErrObj();
                err.setMessage(obj.getMessage());
                err.setStatus(obj.getStatus());
                mCallback.error(err);
            }
        });
    }


    @Override
    public void cancelRequest(String... tags) {
        if (mVerifyPurchaseResponseObj != null)
            mVerifyPurchaseResponseObj.cancel();
    }

    private MyCallback<VerifyPurchaseResponseObj> callbackVerifyPurchase = new MyCallback<VerifyPurchaseResponseObj>() {
        @Override
        public void onSuccess(Call<VerifyPurchaseResponseObj> call, Response<VerifyPurchaseResponseObj> response) {
            if (response.isSuccessful()) {
                mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<VerifyPurchaseResponseObj> call, Object object) {
            BaseObj obj = (BaseObj) object;
            VerifyPurchaseErrObj err = new VerifyPurchaseErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            mCallback.error(err);
        }
    };
}
