package com.game.sdk.comon.api.request;

import com.game.sdk.comon.constants.ConstantApi;
import com.game.sdk.comon.object.request.InitalizePuchaseRequestObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.InitialPurchaseResponseObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Created by dungnv
 */
public interface PaymentRequest {

    @Headers({"Content-Type: application/json","Accept:application/json"})
    @POST(ConstantApi.URL_VERIFY_PURCHASE)
    Call<VerifyPurchaseResponseObj> verifyPurchase(@Path("order_no") String order_no,
                                                   @Body VerifyPurchaseRequestObj body);


    @Headers({"Content-Type: application/json", "Accept:application/json"})
    @POST(ConstantApi.URL_INITIAL_PURCHASE)
    Call<InitialPurchaseResponseObj> initialPurchase(@Body InitalizePuchaseRequestObj body);

}
