/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class Preference {
    private static final String PREFERENCE_NAME = "sp_mobgame";

    public static SharedPreferences getSharedPreferences(Context context) {
        if (context != null) {
            return context.getSharedPreferences(PREFERENCE_NAME, 0);
        }
        return null;
    }

    public static boolean save(Context context, String key, String value) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getString(Context context, String key) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            return sharedPreferences.getString(key, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getString(Context context, String key, String def) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            return sharedPreferences.getString(key, def);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean save(Context context, HashMap<String, String> valuesMap) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            String value = "";
            for (String key : valuesMap.keySet()) {
                value = valuesMap.get(key);
                editor.putString(key, value);
            }
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean save(Context context, String key, boolean value) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putBoolean(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean getBoolean(Context context, String key, boolean defaultValue) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            return sharedPreferences.getBoolean(key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static void clear(Context context) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.clear();
            editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void remove(Context context, String key) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(key);
            editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean save(Context context, String key, int value) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean save(Context context, String key, long value) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putLong(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getInt(Context context, String key, int defaultValue) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            return sharedPreferences.getInt(key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static long getLong(Context context, String key, long defaultValue) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            return sharedPreferences.getLong(key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean save(Context context, String key, float value) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putFloat(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static float getFloat(Context context, String key, float defaultValue) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            return sharedPreferences.getFloat(key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static boolean save(Context context, String key, Set<String> value) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putStringSet(key, value);
            return editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Set<String> getStringSet(Context context, String key, Set<String> defaultValue) {
        try {
            SharedPreferences sharedPreferences = Preference.getSharedPreferences(context);
            return sharedPreferences.getStringSet(key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<String>();
        }
    }
}

